/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_DATA_BACKUP", indexes={@Index(columnList="backup_meta_file"), @Index(columnList="log_meta_file")})
public class DataBackup
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_DATA_BACKUP_SEQ")
    @SequenceGenerator(name="BASE_DATA_BACKUP_SEQ", sequenceName="BASE_DATA_BACKUP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Backup File")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile backupMetaFile;
    @Widget(title="Status", selection="data.backup.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Log")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile logMetaFile;
    @Widget(title="Backup On")
    private LocalDateTime backupDate;
    @Widget(title="Restored On")
    private LocalDateTime restoreDate;
    @Widget(title="CSV Backup Fetch Limit")
    private Integer fetchLimit = 0;
    @Widget(title="Relative Date")
    private Boolean isRelativeDate = Boolean.FALSE;
    @Widget(title="Update Import Id")
    private Boolean updateImportId = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MetaFile getBackupMetaFile() {
        return this.backupMetaFile;
    }

    public void setBackupMetaFile(MetaFile backupMetaFile) {
        this.backupMetaFile = backupMetaFile;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public MetaFile getLogMetaFile() {
        return this.logMetaFile;
    }

    public void setLogMetaFile(MetaFile logMetaFile) {
        this.logMetaFile = logMetaFile;
    }

    public LocalDateTime getBackupDate() {
        return this.backupDate;
    }

    public void setBackupDate(LocalDateTime backupDate) {
        this.backupDate = backupDate;
    }

    public LocalDateTime getRestoreDate() {
        return this.restoreDate;
    }

    public void setRestoreDate(LocalDateTime restoreDate) {
        this.restoreDate = restoreDate;
    }

    public Integer getFetchLimit() {
        return this.fetchLimit == null ? 0 : this.fetchLimit;
    }

    public void setFetchLimit(Integer fetchLimit) {
        this.fetchLimit = fetchLimit;
    }

    public Boolean getIsRelativeDate() {
        return this.isRelativeDate == null ? Boolean.FALSE : this.isRelativeDate;
    }

    public void setIsRelativeDate(Boolean isRelativeDate) {
        this.isRelativeDate = isRelativeDate;
    }

    public Boolean getUpdateImportId() {
        return this.updateImportId == null ? Boolean.FALSE : this.updateImportId;
    }

    public void setUpdateImportId(Boolean updateImportId) {
        this.updateImportId = updateImportId;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataBackup)) {
            return false;
        }
        DataBackup other = (DataBackup)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("backupDate", (Object)this.getBackupDate()).add("restoreDate", (Object)this.getRestoreDate()).add("fetchLimit", (Object)this.getFetchLimit()).add("isRelativeDate", (Object)this.getIsRelativeDate()).add("updateImportId", (Object)this.getUpdateImportId()).omitNullValues().toString();
    }
}

