/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.DataConfigLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_OBJECT_DATA_CONFIG", indexes={@Index(columnList="modelSelect")})
public class ObjectDataConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_OBJECT_DATA_CONFIG_SEQ")
    @SequenceGenerator(name="BASE_OBJECT_DATA_CONFIG_SEQ", sequenceName="BASE_OBJECT_DATA_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Title")
    private String title;
    @Widget(title="Model", selection="object.data.config.model.select")
    @NameColumn
    @NotNull
    private String modelSelect;
    @Widget(title="Status", selection="object.data.config.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="objectDataConfig", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DataConfigLine> dataConfigLineList;
    @Widget(title="Comment")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    @Column(name="comment_val")
    private String comment;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getModelSelect() {
        return this.modelSelect;
    }

    public void setModelSelect(String modelSelect) {
        this.modelSelect = modelSelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public List<DataConfigLine> getDataConfigLineList() {
        return this.dataConfigLineList;
    }

    public void setDataConfigLineList(List<DataConfigLine> dataConfigLineList) {
        this.dataConfigLineList = dataConfigLineList;
    }

    public void addDataConfigLineListItem(DataConfigLine item) {
        if (this.getDataConfigLineList() == null) {
            this.setDataConfigLineList(new ArrayList<DataConfigLine>());
        }
        this.getDataConfigLineList().add(item);
        item.setObjectDataConfig(this);
    }

    public void removeDataConfigLineListItem(DataConfigLine item) {
        if (this.getDataConfigLineList() == null) {
            return;
        }
        this.getDataConfigLineList().remove((Object)item);
    }

    public void clearDataConfigLineList() {
        if (this.getDataConfigLineList() != null) {
            this.getDataConfigLineList().clear();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectDataConfig)) {
            return false;
        }
        ObjectDataConfig other = (ObjectDataConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("modelSelect", (Object)this.getModelSelect()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

