/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ObjectDataConfig;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_OBJECT_DATA_CONFIG_EXPORT", indexes={@Index(columnList="object_data_config")})
public class ObjectDataConfigExport
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_OBJECT_DATA_CONFIG_EXPORT_SEQ")
    @SequenceGenerator(name="BASE_OBJECT_DATA_CONFIG_EXPORT_SEQ", sequenceName="BASE_OBJECT_DATA_CONFIG_EXPORT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Model", selection="object.data.config.model.select")
    @NotNull
    private String modelSelect;
    private Long modelSelectId = 0L;
    @Widget(title="Record name")
    private String recordName;
    @Widget(title="Export format", selection="object.data.export.format.select")
    private String exportFormatSelect;
    @Widget(title="Language", selection="select.language")
    private String langSelect;
    @Widget(title="Object data config")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ObjectDataConfig objectDataConfig;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getModelSelect() {
        return this.modelSelect;
    }

    public void setModelSelect(String modelSelect) {
        this.modelSelect = modelSelect;
    }

    public Long getModelSelectId() {
        return this.modelSelectId == null ? 0L : this.modelSelectId;
    }

    public void setModelSelectId(Long modelSelectId) {
        this.modelSelectId = modelSelectId;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public String getExportFormatSelect() {
        return this.exportFormatSelect;
    }

    public void setExportFormatSelect(String exportFormatSelect) {
        this.exportFormatSelect = exportFormatSelect;
    }

    public String getLangSelect() {
        return this.langSelect;
    }

    public void setLangSelect(String langSelect) {
        this.langSelect = langSelect;
    }

    public ObjectDataConfig getObjectDataConfig() {
        return this.objectDataConfig;
    }

    public void setObjectDataConfig(ObjectDataConfig objectDataConfig) {
        this.objectDataConfig = objectDataConfig;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectDataConfigExport)) {
            return false;
        }
        ObjectDataConfigExport other = (ObjectDataConfigExport)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("modelSelect", (Object)this.getModelSelect()).add("modelSelectId", (Object)this.getModelSelectId()).add("recordName", (Object)this.getRecordName()).add("exportFormatSelect", (Object)this.getExportFormatSelect()).add("langSelect", (Object)this.getLangSelect()).omitNullValues().toString();
    }
}

