/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.job;

import com.axelor.apps.base.job.UncheckedJobExecutionException;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.google.inject.persist.Transactional;
import com.google.inject.servlet.RequestScoper;
import com.google.inject.servlet.ServletScopes;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadedJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackOn={Exception.class})
    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.isRunning(context)) {
            return;
        }
        String name = context.getJobDetail().getKey().getName();
        Thread thread = new Thread(() -> this.executeInThreadedRequestScope(context));
        thread.setUncaughtExceptionHandler((t, e) -> {
            Throwable cause = e instanceof UncheckedJobExecutionException && e.getCause() != null ? e.getCause() : e;
            logger.error(cause.getMessage(), cause);
            TraceBackService.trace((Throwable)cause);
        });
        long startTime = System.currentTimeMillis();
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e2) {
            TraceBackService.trace((Throwable)e2);
            Thread.currentThread().interrupt();
        }
        finally {
            float duration = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            logger.info("Job {} duration: {} s", (Object)name, (Object)Float.valueOf(duration));
            JPA.clear();
        }
    }

    public abstract void executeInThread(JobExecutionContext var1);

    private void executeInThreadedRequestScope(JobExecutionContext context) {
        RequestScoper scope = ServletScopes.scopeRequest(Collections.emptyMap());
        try (RequestScoper.CloseableScope ignored = scope.open();){
            this.executeInThread(context);
        }
    }

    private boolean isRunning(JobExecutionContext context) {
        try {
            return context.getScheduler().getCurrentlyExecutingJobs().stream().anyMatch(j -> j.getTrigger().equals((Object)context.getTrigger()) && !j.getFireInstanceId().equals(context.getFireInstanceId()));
        }
        catch (SchedulerException e) {
            return false;
        }
    }
}

