/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.DataConfigLine;
import com.axelor.apps.base.db.ObjectDataConfig;
import com.axelor.apps.base.service.ObjectDataAnonymizeService;
import com.axelor.apps.base.service.ObjectDataCommonService;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.meta.db.MetaField;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectDataAnonymizeServiceImpl
implements ObjectDataAnonymizeService {
    @Inject
    private MailMessageRepository mailMessageRepo;

    @Override
    public void anonymize(ObjectDataConfig objectDataConfig, Long recordId) throws AxelorException {
        try {
            String rootModel = objectDataConfig.getModelSelect();
            for (DataConfigLine line : objectDataConfig.getDataConfigLineList()) {
                String path = line.getTypeSelect() == 0 ? line.getMetaFieldPath().getName() : line.getPath();
                Class<? extends Model> modelClass = ObjectDataCommonService.findModelClass(line.getMetaModel());
                Query<? extends Model> query = ObjectDataCommonService.createQuery(recordId, line, modelClass);
                List data = query.fetch();
                Mapper mapper = Mapper.of(modelClass);
                int reset = line.getResetPathSelect();
                if (reset != 0 && line.getTypeSelect() == 0) {
                    if (reset == 2) {
                        this.deleteLink(mapper, path, data);
                    } else {
                        this.replaceLink(mapper, path, data, rootModel, line.getRecordSelectId());
                    }
                }
                this.deleteFields(line.getToDeleteMetaFieldSet(), mapper, data);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(4, e.getMessage());
        }
    }

    @Transactional
    public void deleteLink(Mapper mapper, String path, List<? extends Model> data) {
        Property property = mapper.getProperty(path = path.split("\\.")[0]);
        if (property == null || property.isRequired()) {
            return;
        }
        for (Model model : data) {
            mapper.set((Object)model, path, null);
            JPA.save((Model)model);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void replaceLink(Mapper mapper, String path, List<? extends Model> data, String rootModel, Long recordValue) throws ClassNotFoundException, AxelorException {
        Property property = mapper.getProperty(path = path.split("\\.")[0]);
        if (property == null) {
            return;
        }
        Class<?> klass = Class.forName(rootModel);
        JpaRepository repo = JpaRepository.of(klass);
        Model object = repo.all().filter("self.id = ?1", new Object[]{recordValue}).fetchOne();
        if (object == null) {
            throw new AxelorException(3, I18n.get((String)"No record found for: %s"), new Object[]{recordValue});
        }
        for (Model model : data) {
            mapper.set((Object)model, path, (Object)object);
            JPA.save((Model)model);
        }
    }

    @Transactional
    public void deleteFields(Set<MetaField> fields, Mapper mapper, List<? extends Model> data) {
        if (fields.isEmpty()) {
            return;
        }
        Map<String, Object> defaultValues = this.getDefaultValues(mapper, fields);
        for (Model model : data) {
            for (String field : defaultValues.keySet()) {
                Object object = defaultValues.get(field);
                mapper.set((Object)model, field, object);
            }
            JPA.save((Model)model);
            this.mailMessageRepo.all().filter("self.relatedId = ?1 AND self.relatedModel = ?2", new Object[]{model.getId(), mapper.getBeanClass().getName()}).delete();
        }
    }

    private Map<String, Object> getDefaultValues(Mapper mapper, Set<MetaField> fields) {
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        LocalDate defaultDate = LocalDate.of(1900, 1, 1);
        for (MetaField field : fields) {
            String name = field.getName();
            Property property = mapper.getProperty(name);
            if (!property.isRequired()) {
                defaultValues.put(name, null);
                continue;
            }
            if (property.getTarget() != null) continue;
            switch (field.getTypeName()) {
                case "String": {
                    defaultValues.put(name, "anonymous");
                    break;
                }
                case "BigDecimal": {
                    defaultValues.put(name, BigDecimal.ZERO);
                    break;
                }
                case "Integer": {
                    defaultValues.put(name, new Integer(0));
                    break;
                }
                case "Boolean": {
                    defaultValues.put(name, Boolean.FALSE);
                    break;
                }
                case "Long": {
                    defaultValues.put(name, new Long(0L));
                    break;
                }
                case "LocalTime": {
                    defaultValues.put(name, LocalTime.MIDNIGHT);
                    break;
                }
                case "LocalDateTime": {
                    defaultValues.put(name, defaultDate.atStartOfDay());
                    break;
                }
                case "ZonedDateTime": {
                    defaultValues.put(name, defaultDate.atStartOfDay(ZoneId.systemDefault()));
                    break;
                }
            }
        }
        return defaultValues;
    }
}

