/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.DataConfigLine;
import com.axelor.apps.base.db.ObjectDataConfig;
import com.axelor.apps.base.db.ObjectDataConfigExport;
import com.axelor.apps.base.service.ObjectDataCommonService;
import com.axelor.apps.base.service.ObjectDataExportService;
import com.axelor.common.Inflector;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.schema.views.Selection;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDataExportServiceImpl
implements ObjectDataExportService {
    private final Logger logger = LoggerFactory.getLogger(ObjectDataExportServiceImpl.class);
    private Inflector inflector = Inflector.getInstance();
    @Inject
    private MetaFiles metaFiles;

    @Override
    public MetaFile export(ObjectDataConfig objectDataConfig, ObjectDataConfigExport objDataConfigExport) throws AxelorException {
        Long recordId = objDataConfigExport.getModelSelectId();
        String language = objDataConfigExport.getLangSelect();
        String format = objDataConfigExport.getExportFormatSelect();
        try {
            this.logger.debug("Exporting data for model: {}, id: {}, language: {}, format: {}", new Object[]{objectDataConfig.getModelSelect(), recordId, language, format});
            Map<String, List<String[]>> data = this.createData(objectDataConfig, recordId, language);
            if (format != null && format.equals("csv")) {
                return this.writeCSV(data);
            }
            return this.writeExcel(data);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(4, e.getMessage());
        }
    }

    private Map<String, List<String[]>> createData(ObjectDataConfig objectDataConfig, Long recordId, String language) throws ClassNotFoundException {
        HashMap<String, List<String[]>> data = new HashMap<String, List<String[]>>();
        for (DataConfigLine line : objectDataConfig.getDataConfigLineList()) {
            MetaModel metaModel = line.getMetaModel();
            this.logger.debug("Create data for: {}", (Object)metaModel.getName());
            Class<? extends Model> modelClass = ObjectDataCommonService.findModelClass(metaModel);
            Query<? extends Model> query = ObjectDataCommonService.createQuery(recordId, line, modelClass);
            ResourceBundle bundle = ObjectDataCommonService.getResourceBundle(language);
            String[][] fieldsData = this.createFieldsData(line.getToExportMetaFieldSet(), bundle);
            Map<String, String> selectMap = this.getSelectMap(Mapper.of(modelClass));
            List<String[]> dataList = this.fetchData(fieldsData, query, selectMap, bundle);
            data.put(line.getTabName(), dataList);
        }
        return data;
    }

    private Map<String, String> getSelectMap(Mapper mapper) {
        HashMap<String, String> selectionMap = new HashMap<String, String>();
        for (Property property : mapper.getProperties()) {
            String selection = property.getSelection();
            if (Strings.isNullOrEmpty((String)selection)) continue;
            selectionMap.put(property.getName(), selection);
        }
        return selectionMap;
    }

    private String[][] createFieldsData(Set<MetaField> metaFields, ResourceBundle bundle) throws ClassNotFoundException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        for (MetaField field : metaFields) {
            String label = field.getLabel();
            String name = field.getName();
            if (Strings.isNullOrEmpty((String)label)) {
                label = this.inflector.humanize(name);
            }
            if (field.getRelationship() != null) {
                name = name + "." + ObjectDataCommonService.getNameColumn(field);
            }
            names.add(name);
            String translated = bundle.getString(label);
            if (!Strings.isNullOrEmpty((String)translated)) {
                labels.add(translated);
                continue;
            }
            labels.add(label);
        }
        this.logger.debug("Fields: {}", names);
        this.logger.debug("Labels: {}", labels);
        return new String[][]{names.toArray(new String[names.size()]), labels.toArray(new String[labels.size()])};
    }

    private List<String[]> fetchData(String[][] fieldsData, Query<? extends Model> query, Map<String, String> selectMap, ResourceBundle bundle) {
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        dataList.add(fieldsData[1]);
        List records = query.select(fieldsData[0]).fetch(0, 0);
        for (Map record : records) {
            ArrayList<String> datas = new ArrayList<String>();
            for (String field : fieldsData[0]) {
                Object object = record.get(field);
                if (object == null) {
                    datas.add("");
                    continue;
                }
                if (selectMap.containsKey(field)) {
                    String selection = selectMap.get(field);
                    Selection.Option option = MetaStore.getSelectionItem((String)selection, (String)object.toString());
                    if (option == null) {
                        datas.add("");
                        continue;
                    }
                    String optionTitle = option.getTitle();
                    if ((optionTitle = bundle.getString(optionTitle)) != null) {
                        datas.add(optionTitle);
                        continue;
                    }
                    datas.add(option.getTitle());
                    continue;
                }
                datas.add(object.toString());
            }
            dataList.add(datas.toArray(new String[fieldsData[0].length]));
        }
        return dataList;
    }

    private MetaFile writeCSV(Map<String, List<String[]>> data) throws IOException {
        File zipFile = MetaFiles.createTempFile((String)"Data", (String)".zip", (FileAttribute[])new FileAttribute[0]).toFile();
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zipFile));){
            for (String model : data.keySet()) {
                File modelFile = MetaFiles.createTempFile((String)model, (String)".csv", (FileAttribute[])new FileAttribute[0]).toFile();
                CSVWriter writer = new CSVWriter((Writer)new FileWriter(modelFile), ';');
                writer.writeAll(data.get(model));
                writer.close();
                zout.putNextEntry(new ZipEntry(model + ".csv"));
                zout.write(IOUtils.toByteArray((InputStream)new FileInputStream(modelFile)));
                zout.closeEntry();
            }
            zout.close();
        }
        return this.metaFiles.upload(zipFile);
    }

    private MetaFile writeExcel(Map<String, List<String[]>> data) throws IOException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        for (String model : data.keySet()) {
            XSSFSheet sheet = workBook.createSheet(model);
            int count = 0;
            for (String[] record : data.get(model)) {
                XSSFRow row = sheet.createRow(count);
                int cellCount = 0;
                for (String val : record) {
                    XSSFCell cell = row.createCell(cellCount);
                    cell.setCellValue(val);
                    ++cellCount;
                }
                ++count;
            }
        }
        File excelFile = MetaFiles.createTempFile((String)"Data", (String)".xls", (FileAttribute[])new FileAttribute[0]).toFile();
        FileOutputStream out = new FileOutputStream(excelFile);
        workBook.write((OutputStream)out);
        out.close();
        return this.metaFiles.upload(excelFile);
    }
}

