/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.app;

import com.axelor.apps.base.db.App;
import com.axelor.apps.base.service.app.AccessTemplateService;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaMenuRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AccessTemplateServiceImpl
implements AccessTemplateService {
    private Map<String, String> menuApp;
    private Map<String, String> objMenu;
    private List<String> configMenus;
    private List<String> appMenus;
    private static final String[] objectHeaders = new String[]{"Object", "User", "Manager"};
    private static final String[] menuHeaders = new String[]{"Menu", "User", "Manager"};
    private String defaultApp = null;
    @Inject
    private MetaMenuRepository metaMenuRepo;
    @Inject
    private AppService appService;
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private MetaModelRepository metaModelRepo;

    @Override
    public MetaFile generateTemplate() throws AxelorException {
        try {
            this.menuApp = new HashMap<String, String>();
            this.objMenu = new HashMap<String, String>();
            this.configMenus = new ArrayList<String>();
            this.appMenus = new ArrayList<String>();
            this.defaultApp = null;
            App app = this.appService.getApp("base");
            if (app == null) {
                return null;
            }
            this.defaultApp = app.getCode();
            this.getMenusPerApp();
            this.updateNoMenuObjects();
            return this.createExcel();
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(4, e.getMessage());
        }
    }

    private void getMenusPerApp() {
        List menus = this.metaMenuRepo.all().filter("self.parent is null").order("id").fetch();
        this.processMenu(menus.iterator());
    }

    private void processMenu(Iterator<MetaMenu> menuIter) {
        String menuName;
        String model;
        if (!menuIter.hasNext()) {
            return;
        }
        MetaMenu menu = menuIter.next();
        String app = this.getApp(menu);
        this.menuApp.put(menu.getName(), app);
        MetaAction action = menu.getAction();
        if (action != null && action.getType().equals("action-view") && this.validModel(model = action.getModel()) && (menuName = this.getObjMenu(menu)) != null) {
            this.objMenu.put(model, menuName);
        }
        List menus = this.metaMenuRepo.all().filter("self.parent = ?1", new Object[]{menu}).order("id").fetch();
        this.processMenu(menus.iterator());
        this.processMenu(menuIter);
    }

    private boolean validModel(String model) {
        if (model == null) {
            return false;
        }
        if (this.objMenu.containsKey(model)) {
            return false;
        }
        return !model.equals(MetaJsonRecord.class.getName());
    }

    private String getObjMenu(MetaMenu menu) {
        MetaMenu parent;
        if (this.appMenus.contains(menu.getName())) {
            return menu.getName();
        }
        if (this.configMenus.contains(menu.getName())) {
            return menu.getName();
        }
        for (parent = menu.getParent(); parent != null && !this.configMenus.contains(parent.getName()) && !this.appMenus.contains(parent.getName()); parent = parent.getParent()) {
        }
        if (parent != null) {
            return parent.getName();
        }
        return null;
    }

    private String getApp(MetaMenu menu) {
        App app;
        String[] cond;
        String appCode = null;
        String condition = menu.getConditionToCheck();
        if (condition != null && (cond = condition.split("__config__\\.app\\.isApp\\('")).length > 1 && (app = this.appService.getApp(cond[1].split("'")[0])) != null) {
            if (condition.trim().equals("__config__.app.isApp('" + app.getCode() + "')") && menu.getAction() == null) {
                this.appMenus.add(menu.getName());
            }
            appCode = app.getCode();
        }
        MetaMenu parent = menu.getParent();
        if (appCode == null && parent != null && this.menuApp.containsKey(parent.getName())) {
            appCode = this.menuApp.get(parent.getName());
        }
        if (parent == null && appCode == null) {
            this.configMenus.add(menu.getName());
        }
        if (menu.getTitle().equals("Configuration") || menu.getTitle().equals("Configurations")) {
            this.configMenus.add(menu.getName());
            this.appMenus.remove(menu.getName());
        }
        if (appCode == null) {
            return this.defaultApp;
        }
        return appCode;
    }

    private MetaFile createExcel() throws FileNotFoundException, IOException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.objMenu.keySet());
        Collections.sort(keys);
        HashSet<String> menuProcessed = new HashSet<String>();
        for (String obj : keys) {
            String menu = this.objMenu.get(obj);
            String app = this.menuApp.get(menu);
            if (app == null) continue;
            this.writeObjectSheet(workBook, obj, menu, app);
            if (menuProcessed.contains(menu)) continue;
            this.writeMenuSheet(workBook, menu, app);
            menuProcessed.add(menu);
        }
        ArrayList<String> menusRemaining = new ArrayList<String>();
        menusRemaining.addAll(this.appMenus);
        for (String menu : menusRemaining) {
            this.writeMenuSheet(workBook, menu, this.menuApp.get(menu));
        }
        return this.createMetaFile(workBook);
    }

    public MetaFile createMetaFile(XSSFWorkbook workBook) throws IOException, FileNotFoundException {
        Path path = MetaFiles.createTempFile((String)"AccessConfigTemplate", (String)".xlsx", (FileAttribute[])new FileAttribute[0]);
        File file = path.toFile();
        FileOutputStream fout = new FileOutputStream(file);
        workBook.write((OutputStream)fout);
        fout.close();
        return this.metaFiles.upload(file);
    }

    public void writeObjectSheet(XSSFWorkbook workBook, String obj, String menu, String app) {
        XSSFSheet sheet = workBook.getSheet(app);
        if (sheet == null) {
            sheet = workBook.createSheet(app);
            this.writeRow(sheet, objectHeaders);
        }
        String usersRights = this.appMenus.contains(menu) ? "rwcde" : "r";
        this.writeRow(sheet, new String[]{obj, usersRights, "rwcde"});
    }

    private void writeMenuSheet(XSSFWorkbook workBook, String menu, String app) {
        XSSFSheet sheet = workBook.getSheet(app + "-menu");
        if (sheet == null) {
            sheet = workBook.createSheet(app + "-menu");
            this.writeRow(sheet, menuHeaders);
        }
        String usersRights = this.configMenus.contains(menu) ? "" : "x";
        this.writeRow(sheet, new String[]{menu, usersRights, "x"});
        this.appMenus.remove(menu);
    }

    private void writeRow(XSSFSheet sheet, String[] values) {
        XSSFRow row = sheet.createRow(sheet.getPhysicalNumberOfRows());
        for (int i = 0; i < values.length; ++i) {
            XSSFCell cell = row.createCell(i);
            cell.setCellValue(values[i]);
        }
    }

    private void updateNoMenuObjects() {
        List metaModels = this.metaModelRepo.all().filter("self.fullName not in ?1", new Object[]{this.objMenu.keySet()}).fetch();
        Iterator modelIter = metaModels.iterator();
        String appMenu = this.objMenu.get(App.class.getName());
        while (modelIter.hasNext()) {
            MetaModel model = (MetaModel)modelIter.next();
            try {
                Class<?> klass = Class.forName(model.getFullName());
                if (App.class.isAssignableFrom(klass)) {
                    this.objMenu.put(model.getFullName(), appMenu);
                    modelIter.remove();
                    continue;
                }
                if (this.addObject(model)) {
                    modelIter.remove();
                    continue;
                }
                this.objMenu.put(model.getFullName(), appMenu);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    private boolean addObject(MetaModel model) {
        for (String key : this.objMenu.keySet()) {
            if (!model.getFullName().contains(key)) continue;
            this.objMenu.put(model.getFullName(), this.objMenu.get(key));
            return true;
        }
        String pkgName = model.getPackageName();
        for (String key : this.objMenu.keySet()) {
            String objPkg = key.substring(0, key.lastIndexOf("."));
            if (!pkgName.equals(objPkg)) continue;
            this.objMenu.put(model.getFullName(), this.objMenu.get(key));
            return true;
        }
        return false;
    }
}

