/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.app;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.App;
import com.axelor.apps.base.db.repo.AppRepository;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.common.FileUtils;
import com.axelor.common.Inflector;
import com.axelor.data.csv.CSVConfig;
import com.axelor.data.csv.CSVImporter;
import com.axelor.data.csv.CSVInput;
import com.axelor.data.xml.XMLImporter;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AppServiceImpl
implements AppService {
    private final Logger log = LoggerFactory.getLogger(AppService.class);
    private static final String DIR_DEMO = "demo";
    private static final String DIR_INIT = "data-init" + File.separator + "app";
    private static final String DIR_ROLES = "roles";
    private static final String CONFIG_PATTERN = "-config.xml";
    private static final String IMG_DIR = "img";
    private static final String EXT_DIR = "extra";
    private static Pattern patCsv = Pattern.compile("^\\<\\s*csv-inputs");
    private static Pattern patXml = Pattern.compile("^\\<\\s*xml-inputs");
    private Inflector inflector = Inflector.getInstance();
    @Inject
    private AppRepository appRepo;
    @Inject
    private MetaModelRepository metaModelRepo;

    @Override
    public App importDataDemo(App app) throws AxelorException {
        if (app.getDemoDataLoaded().booleanValue()) {
            return app;
        }
        this.log.debug("Demo import: App code: {}, App lang: {}", (Object)app.getCode(), (Object)app.getLanguageSelect());
        this.importParentData(app);
        String lang = this.getLanguage(app);
        if (lang == null) {
            throw new AxelorException(4, I18n.get((String)"No application language set. Please set 'application.locale' property."));
        }
        this.importData(app, DIR_DEMO, true);
        app = (App)((Object)this.appRepo.find(app.getId()));
        app.setDemoDataLoaded(true);
        return this.saveApp(app);
    }

    @Transactional
    public App saveApp(App app) {
        return (App)((Object)this.appRepo.save((Model)((Object)app)));
    }

    private void importData(App app, String dataDir, boolean useLang) {
        String modules = app.getModules();
        if (modules == null) {
            return;
        }
        String code = app.getCode();
        String lang = useLang ? this.getLanguage(app) : "";
        this.log.debug("Data import: DataDir: {}, App code: {}, App lang: {}", new Object[]{dataDir, code, lang});
        for (String module : modules.split(",")) {
            File tmp = this.extract(module, dataDir, lang, code);
            if (tmp == null) continue;
            this.log.debug("Importing from module: {}", (Object)module);
            this.importPerConfig(code, new File(tmp, dataDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPerConfig(final String appCode, File dataDir) {
        try {
            Object[] configs = dataDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(appCode + "-") && name.endsWith(AppServiceImpl.CONFIG_PATTERN);
                }
            });
            if (configs.length == 0) {
                this.log.debug("No config file found for the app: {}", (Object)appCode);
                return;
            }
            Arrays.sort(configs);
            for (Object config : configs) {
                this.runImport((File)config, dataDir);
            }
        }
        finally {
            this.clean(dataDir);
        }
    }

    private String getLanguage(App app) {
        String lang = app.getLanguageSelect();
        if (app.getLanguageSelect() == null) {
            lang = AppSettings.get().get("application.locale");
        }
        return lang;
    }

    private void importParentData(App app) throws AxelorException {
        List<App> depends = this.getDepends(app, true);
        for (App parent : depends) {
            if ((parent = (App)((Object)this.appRepo.find(parent.getId()))).getDemoDataLoaded().booleanValue()) continue;
            this.importDataDemo(parent);
        }
    }

    private App importDataInit(App app) {
        String lang = this.getLanguage(app);
        if (lang == null) {
            return app;
        }
        this.importData(app, DIR_INIT, true);
        app = (App)((Object)this.appRepo.find(app.getId()));
        app.setInitDataLoaded(true);
        return app;
    }

    private void runImport(File config, File data) {
        this.log.debug("Running import with config path: {}, data path: {}", (Object)config.getAbsolutePath(), (Object)data.getAbsolutePath());
        try (Scanner scanner = new Scanner(config);){
            CSVImporter importer = null;
            while (scanner.hasNextLine()) {
                String str = scanner.nextLine();
                if (patCsv.matcher(str).find()) {
                    importer = new CSVImporter(config.getAbsolutePath(), data.getAbsolutePath(), null);
                    break;
                }
                if (!patXml.matcher(str).find()) continue;
                importer = new XMLImporter(config.getAbsolutePath(), data.getAbsolutePath());
                break;
            }
            scanner.close();
            if (importer != null) {
                importer.run();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private File extract(String module, String dirName, String lang, String code) {
        String dirNamePattern = dirName.replaceAll("/|\\\\", "(/|\\\\\\\\)");
        ArrayList<URL> files = new ArrayList<URL>();
        files.addAll(MetaScanner.findAll((String)module, (String)dirNamePattern, (String)(code + "(-+.*)?" + CONFIG_PATTERN)));
        if (files.isEmpty()) {
            return null;
        }
        if (lang.isEmpty()) {
            files.addAll(MetaScanner.findAll((String)module, (String)dirNamePattern, (String)(code + "*")));
        } else {
            String dirPath = dirName + "/";
            files.addAll(this.fetchUrls(module, dirPath + IMG_DIR));
            files.addAll(this.fetchUrls(module, dirPath + EXT_DIR));
            files.addAll(this.fetchUrls(module, dirPath + lang));
        }
        File tmp = Files.createTempDir();
        String dir = dirName.replace("\\", "/");
        for (URL file : files) {
            String name = file.toString();
            name = name.substring(name.lastIndexOf(dir));
            if (!lang.isEmpty()) {
                name = name.replace(dir + "/" + lang, dir);
            }
            if (File.separatorChar == '\\') {
                name = name.replace("/", "\\");
            }
            try {
                this.copy(file.openStream(), tmp, name);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return tmp;
    }

    private List<URL> fetchUrls(String module, String fileName) {
        String fileNamePattern = fileName.replaceAll("/|\\\\", "(/|\\\\\\\\)");
        return MetaScanner.findAll((String)module, (String)fileNamePattern, (String)"(.+?)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream in, File toDir, String name) throws IOException {
        File dst = FileUtils.getFile((File)toDir, (String)name, (String[])new String[0]);
        Files.createParentDirs((File)dst);
        try (FileOutputStream out = new FileOutputStream(dst);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
    }

    private void clean(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.clean(child);
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public App getApp(String code) {
        return this.appRepo.findByCode(code);
    }

    @Override
    public boolean isApp(String code) {
        App app = this.getApp(code);
        if (app == null) {
            return false;
        }
        return app.getActive();
    }

    private List<App> getDepends(App app, Boolean active) {
        ArrayList<App> apps = new ArrayList<App>();
        app = (App)((Object)this.appRepo.find(app.getId()));
        for (App depend : app.getDependsOnSet()) {
            if (!depend.getActive().equals(active)) continue;
            apps.add(depend);
        }
        return this.sortApps(apps);
    }

    private List<String> getNames(List<App> apps) {
        ArrayList<String> names = new ArrayList<String>();
        for (App app : apps) {
            names.add(app.getName());
        }
        return names;
    }

    private List<App> getChildren(App app, Boolean active) {
        String code = app.getCode();
        String query = "self.dependsOnSet.code = ?1";
        if (active != null) {
            query = "(" + query + ") AND self.active = " + active;
        }
        List apps = this.appRepo.all().filter(query, new Object[]{code}).fetch();
        this.log.debug("Parent app: {}, Total children: {}", (Object)app.getName(), (Object)apps.size());
        return apps;
    }

    @Override
    public App installApp(App app, String language) throws AxelorException {
        if ((app = (App)((Object)this.appRepo.find(app.getId()))).getActive().booleanValue()) {
            return app;
        }
        if (language != null) {
            app.setLanguageSelect(language);
        } else {
            language = app.getLanguageSelect();
        }
        List<App> apps = this.getDepends(app, false);
        for (App parentApp : apps) {
            this.installApp(parentApp, language);
        }
        this.log.debug("Init data loaded: {}, for app: {}", (Object)app.getInitDataLoaded(), (Object)app.getCode());
        if (!app.getInitDataLoaded().booleanValue()) {
            app = this.importDataInit(app);
        }
        app = (App)((Object)this.appRepo.find(app.getId()));
        app.setActive(true);
        return this.saveApp(app);
    }

    private List<App> sortApps(Collection<App> apps) {
        ArrayList<App> appsList = new ArrayList<App>();
        appsList.addAll(apps);
        appsList.sort(new Comparator<App>(){

            @Override
            public int compare(App app1, App app2) {
                Integer order1 = app1.getInstallOrder();
                Integer order2 = app2.getInstallOrder();
                if (order1 < order2) {
                    return -1;
                }
                if (order1 > order2) {
                    return 1;
                }
                return 0;
            }
        });
        this.log.debug("Apps sorted: {}", this.getNames(appsList));
        return appsList;
    }

    @Override
    public void refreshApp() throws IOException {
        CSVImporter importer;
        File dataDir = Files.createTempDir();
        File imgDir = new File(dataDir, IMG_DIR);
        imgDir.mkdir();
        CSVConfig csvConfig = new CSVConfig();
        csvConfig.setInputs(new ArrayList());
        List metaModels = this.metaModelRepo.all().filter("self.name != 'App' and self.name like 'App%' and self.packageName =  ?1", new Object[]{App.class.getPackage().getName()}).fetch();
        this.log.debug("Total app models: {}", (Object)metaModels.size());
        for (MetaModel metaModel : metaModels) {
            Class<?> klass;
            try {
                klass = Class.forName(metaModel.getFullName());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!App.class.isAssignableFrom(klass)) {
                this.log.debug("Not a App class : {}", (Object)metaModel.getName());
                continue;
            }
            Object obj = null;
            Query query = JPA.em().createQuery("SELECT id FROM " + metaModel.getName());
            try {
                obj = query.setMaxResults(1).getSingleResult();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj != null) continue;
            this.log.debug("App without app record: {}", (Object)metaModel.getName());
            String csvName = "base_" + this.inflector.camelize(klass.getSimpleName(), true) + ".csv";
            String pngName = this.inflector.dasherize(klass.getSimpleName()) + ".png";
            CSVInput input = new CSVInput();
            input.setFileName(csvName);
            input.setTypeName(klass.getName());
            input.setCallable("com.axelor.csv.script.ImportApp:importApp");
            input.setSearch("self.code =:code");
            input.setSeparator(';');
            csvConfig.getInputs().add(input);
            InputStream stream = klass.getResourceAsStream("/data-init/input/" + csvName);
            this.copyStream(stream, new File(dataDir, csvName));
            stream = klass.getResourceAsStream("/data-init/input/img/" + pngName);
            this.copyStream(stream, new File(imgDir, pngName));
        }
        if (!csvConfig.getInputs().isEmpty() && (importer = new CSVImporter(csvConfig, dataDir.getAbsolutePath())) != null) {
            importer.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStream(InputStream stream, File file) throws IOException {
        if (stream != null) {
            try (FileOutputStream out = new FileOutputStream(file);){
                ByteStreams.copy((InputStream)stream, (OutputStream)out);
                out.close();
            }
        }
    }

    @Override
    public App unInstallApp(App app) throws AxelorException {
        List<App> children = this.getChildren(app, true);
        if (!children.isEmpty()) {
            List<String> childrenNames = this.getNames(children);
            throw new AxelorException(5, "This app is used by %s. Please deactivate them before continue.", new Object[]{childrenNames});
        }
        app.setActive(false);
        return this.saveApp(app);
    }

    @Override
    public void bulkInstall(Collection<App> apps, Boolean importDemo, String language) throws AxelorException {
        apps = this.sortApps(apps);
        for (App app : apps) {
            app = this.installApp(app, language);
            if (importDemo == null || !importDemo.booleanValue()) continue;
            this.importDataDemo(app);
        }
    }

    @Override
    public App importRoles(App app) throws AxelorException {
        if (app.getIsRolesImported().booleanValue()) {
            return app;
        }
        this.importParentRoles(app);
        this.importData(app, DIR_ROLES, false);
        app = (App)((Object)this.appRepo.find(app.getId()));
        app.setIsRolesImported(true);
        return this.saveApp(app);
    }

    private void importParentRoles(App app) throws AxelorException {
        List<App> depends = this.getDepends(app, true);
        for (App parent : depends) {
            if ((parent = (App)((Object)this.appRepo.find(parent.getId()))).getIsRolesImported().booleanValue()) continue;
            this.importRoles(parent);
        }
    }

    @Override
    public void importRoles() throws AxelorException {
        List<App> apps = this.appRepo.all().filter("self.isRolesImported = false").fetch();
        apps = this.sortApps((Collection<App>)apps);
        for (App app : apps) {
            this.importRoles(app);
        }
    }
}

