/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.app;

import com.axelor.apps.base.db.App;
import com.axelor.apps.base.db.DataBackup;
import com.axelor.apps.base.service.app.DataBackupService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.auth.db.AuditableModel;
import com.axelor.common.StringUtils;
import com.axelor.data.csv.CSVBind;
import com.axelor.data.csv.CSVConfig;
import com.axelor.data.csv.CSVInput;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.opencsv.CSVWriter;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBackupCreateService {
    private static final char SEPARATOR = ',';
    private static final char QUOTE_CHAR = '\"';
    private static final char REFERENCE_FIELD_SEPARATOR = '|';
    private static final int BUFFER_SIZE = 1000;
    @Inject
    private MetaModelRepository metaModelRepo;
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    private boolean notNullReferenceFlag;
    private boolean referenceFlag;
    private boolean byteArrFieldFlag = false;
    private static Set<String> exceptColumnNameList = ImmutableSet.of((Object)"importOrigin", (Object)"importId", (Object)"updatedBy", (Object)"createdBy", (Object)"updatedOn", (Object)"createdOn", (Object[])new String[]{"archived", "version", "attrs"});
    private static Map<Object, Object> AutoImportModelMap = ImmutableMap.builder().put((Object)"com.axelor.apps.base.db.App", (Object)"self.code = :code").put((Object)"com.axelor.auth.db.Role", (Object)"self.name = :name").put((Object)"com.axelor.auth.db.User", (Object)"self.code = :code").put((Object)"com.axelor.auth.db.Permission", (Object)"self.name = :name").put((Object)"com.axelor.auth.db.Group", (Object)"self.code = :code").put((Object)"com.axelor.apps.base.db.Language", (Object)"self.code = :code").put((Object)"com.axelor.apps.base.db.BirtTemplate", (Object)"self.name = :name").put((Object)"com.axelor.apps.base.db.BirtTemplateParameter", (Object)"self.name = :name").put((Object)"com.axelor.apps.crm.db.EventCategory", (Object)"self.code = :code").put((Object)"com.axelor.apps.account.db.AccountChart", (Object)"self.code = :code").put((Object)"com.axelor.apps.bankpayment.db.BankOrderFileFormat", (Object)"self.name = :name").put((Object)"com.axelor.apps.bankpayment.db.BankStatementFileFormat", (Object)"self.name = :name").build();
    List<String> fileNameList;

    public File create(DataBackup dataBackup) throws InterruptedException {
        File tempDir = Files.createTempDir();
        String tempDirectoryPath = tempDir.getAbsolutePath();
        this.fileNameList = new ArrayList<String>();
        List<MetaModel> metaModelList = this.getMetaModels();
        LinkedList<CSVInput> simpleCsvs = new LinkedList<CSVInput>();
        LinkedList<CSVInput> refernceCsvs = new LinkedList<CSVInput>();
        LinkedList<CSVInput> notNullReferenceCsvs = new LinkedList<CSVInput>();
        Map<String, List<String>> subClassesMap = this.getSubClassesMap();
        for (MetaModel metaModel : metaModelList) {
            try {
                List<String> subClasses = subClassesMap.get(metaModel.getFullName());
                long totalRecord = this.getMetaModelDataCount(metaModel, subClasses);
                if (totalRecord <= 0L) continue;
                this.LOG.debug("Exporting Model : " + metaModel.getFullName());
                this.notNullReferenceFlag = false;
                this.referenceFlag = false;
                CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(tempDirectoryPath, metaModel.getName() + ".csv")), ',', '\"');
                CSVInput csvInput = this.writeCSVData(metaModel, csvWriter, dataBackup, totalRecord, subClasses, tempDirectoryPath);
                csvWriter.close();
                if (this.notNullReferenceFlag) {
                    notNullReferenceCsvs.add(csvInput);
                } else if (this.referenceFlag) {
                    refernceCsvs.add(csvInput);
                    CSVInput temcsv = new CSVInput();
                    temcsv.setFileName(csvInput.getFileName());
                    temcsv.setTypeName(csvInput.getTypeName());
                    if (dataBackup.getIsRelativeDate().booleanValue()) {
                        temcsv.setBindings(new ArrayList());
                        this.getCsvInputForDateorDateTime(metaModel, temcsv);
                    }
                    if (AutoImportModelMap.containsKey(csvInput.getTypeName())) {
                        temcsv.setSearch(AutoImportModelMap.get(csvInput.getTypeName()).toString());
                    }
                    if (Class.forName(metaModel.getFullName()).getSuperclass() == App.class) {
                        temcsv.setSearch("self.code = :code");
                    }
                    simpleCsvs.add(temcsv);
                } else {
                    simpleCsvs.add(csvInput);
                }
                this.fileNameList.add(metaModel.getName() + ".csv");
            }
            catch (ClassNotFoundException subClasses) {
            }
            catch (IOException e) {
                TraceBackService.trace((Throwable)e, (String)DataBackupService.class.getName());
            }
        }
        CSVConfig csvConfig = new CSVConfig();
        csvConfig.setInputs(simpleCsvs);
        csvConfig.getInputs().addAll(notNullReferenceCsvs);
        csvConfig.getInputs().addAll(refernceCsvs);
        csvConfig.getInputs().addAll(notNullReferenceCsvs);
        this.generateConfig(tempDirectoryPath, csvConfig);
        this.fileNameList.add("config.xml");
        File zippedFile = this.generateZIP(tempDirectoryPath, this.fileNameList);
        return zippedFile;
    }

    void getCsvInputForDateorDateTime(MetaModel metaModel, CSVInput csvInput) {
        try {
            Property[] properties;
            Mapper metaModelMapper = Mapper.of(Class.forName(metaModel.getFullName()));
            for (Property property : properties = metaModelMapper.getProperties()) {
                String propertyType = property.getType().toString();
                if (!propertyType.equals("DATE") && !propertyType.equals("DATETIME") || property.getName().equals("createdOn") || property.getName().equals("updatedOn")) continue;
                this.getDateOrDateTimeHeader(property, csvInput);
            }
        }
        catch (ClassNotFoundException e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    private List<MetaModel> getMetaModels() {
        String filterStr = "self.packageName NOT LIKE '%meta%' AND self.packageName !='com.axelor.studio.db' AND self.name!='DataBackup' AND self.tableName IS NOT NULL";
        List metaModels = this.metaModelRepo.all().filter(filterStr).order("fullName").fetch();
        metaModels.add(this.metaModelRepo.findByName(MetaFile.class.getSimpleName()));
        metaModels.add(this.metaModelRepo.findByName(MetaJsonField.class.getSimpleName()));
        return metaModels;
    }

    private Map<String, List<String>> getSubClassesMap() {
        List<MetaModel> metaModels = this.getMetaModels();
        HashMap<String, List<String>> subClassMap = new HashMap<String, List<String>>();
        for (MetaModel metaModel : metaModels) {
            try {
                List<String> subClasses = new ArrayList<String>();
                Class<?> superClass = Class.forName(metaModel.getFullName()).getSuperclass();
                if (superClass == AuditableModel.class) continue;
                if (!subClassMap.isEmpty() && subClassMap.containsKey(superClass.getName())) {
                    subClasses = (List)subClassMap.get(superClass.getName());
                }
                subClasses.add(metaModel.getName());
                subClassMap.put(superClass.getName(), subClasses);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return subClassMap;
    }

    private List<Model> getMetaModelDataList(MetaModel metaModel, int start, Integer fetchLimit, List<String> subClasses) throws ClassNotFoundException {
        Query<Model> query = this.getQuery(metaModel, subClasses);
        if (query != null) {
            return query.fetch(fetchLimit.intValue(), start);
        }
        return null;
    }

    private long getMetaModelDataCount(MetaModel metaModel, List<String> subClasses) throws InterruptedException, ClassNotFoundException {
        Query<Model> query = this.getQuery(metaModel, subClasses);
        long count = 0L;
        if (query != null) {
            count = query.count();
        }
        return count;
    }

    private Query<Model> getQuery(MetaModel metaModel, List<String> subClasses) throws ClassNotFoundException {
        String whereStr = "";
        if (subClasses != null && subClasses.size() > 0) {
            for (String subClassName : subClasses) {
                whereStr = whereStr + (whereStr.length() > 0 ? " AND " : "");
                whereStr = whereStr + "id NOT IN (select id from " + subClassName + ")";
            }
        }
        Class<?> klass = Class.forName(metaModel.getFullName());
        JpaRepository model = null;
        Query query = null;
        try {
            model = JpaRepository.of(klass);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e, (String)DataBackupService.class.getName());
        }
        if (model != null) {
            query = JpaRepository.of(klass).all();
            if (StringUtils.notEmpty((CharSequence)whereStr)) {
                query.filter(whereStr);
            }
        }
        return query;
    }

    private CSVInput writeCSVData(MetaModel metaModel, CSVWriter csvWriter, DataBackup dataBackup, long totalRecord, List<String> subClasses, String dirPath) {
        CSVInput csvInput = new CSVInput();
        boolean headerFlag = true;
        ArrayList<String> dataArr = null;
        ArrayList<String> headerArr = new ArrayList<String>();
        List<Model> dataList = null;
        try {
            Mapper metaModelMapper = Mapper.of(Class.forName(metaModel.getFullName()));
            Property[] pro = metaModelMapper.getProperties();
            Integer fetchLimit = dataBackup.getFetchLimit();
            boolean isRelativeDate = dataBackup.getIsRelativeDate();
            boolean updateImportId = dataBackup.getUpdateImportId();
            csvInput.setFileName(metaModel.getName() + ".csv");
            csvInput.setTypeName(metaModel.getFullName());
            csvInput.setBindings(new ArrayList());
            int i = 0;
            while ((long)i < totalRecord) {
                dataList = this.getMetaModelDataList(metaModel, i, fetchLimit, subClasses);
                if (dataList != null && dataList.size() > 0) {
                    for (Model dataObject : dataList) {
                        dataArr = new ArrayList<String>();
                        for (Property property : pro) {
                            if (!this.isPropertyExportable(property)) continue;
                            if (headerFlag) {
                                String headerStr = this.getMetaModelHeader(dataObject, property, csvInput, isRelativeDate);
                                headerArr.add(headerStr);
                            }
                            dataArr.add(this.getMetaModelData(metaModel.getName(), metaModelMapper, property, dataObject, dirPath, isRelativeDate, updateImportId));
                        }
                        if (headerFlag) {
                            if (this.byteArrFieldFlag) {
                                csvInput.setCallable("com.axelor.apps.base.service.app.DataBackupRestoreService:importObjectWithByteArray");
                                this.byteArrFieldFlag = false;
                            }
                            csvWriter.writeNext(headerArr.toArray(new String[headerArr.size()]), true);
                            headerFlag = false;
                        }
                        csvWriter.writeNext(dataArr.toArray(new String[dataArr.size()]), true);
                    }
                }
                i += fetchLimit.intValue();
            }
            if (AutoImportModelMap.containsKey(csvInput.getTypeName())) {
                csvInput.setSearch(AutoImportModelMap.get(csvInput.getTypeName()).toString());
            } else if (Class.forName(metaModel.getFullName()).getSuperclass() == App.class) {
                csvInput.setSearch("self.code = :code");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return csvInput;
    }

    private boolean isPropertyExportable(Property property) {
        return !exceptColumnNameList.contains(property.getName()) && (StringUtils.isEmpty((CharSequence)property.getMappedBy()) || !StringUtils.isEmpty((CharSequence)property.getMappedBy()) && property.getTarget() != null && property.getTarget().getPackage().equals(Package.getPackage("com.axelor.meta.db")) && !property.getTarget().isAssignableFrom(MetaFile.class) && !property.getTarget().isAssignableFrom(MetaJsonField.class)) && !property.isTransient();
    }

    private String getMetaModelHeader(Object value, Property property, CSVInput csvInput, boolean isRelativeDate) {
        String propertyTypeStr = property.getType().toString();
        String propertyName = property.getName();
        switch (propertyTypeStr) {
            case "DATE": 
            case "DATETIME": {
                if (isRelativeDate) {
                    return this.getDateOrDateTimeHeader(property, csvInput);
                }
                return propertyName;
            }
            case "LONG": {
                return propertyName.equalsIgnoreCase("id") ? "importId" : propertyName;
            }
            case "BINARY": {
                this.byteArrFieldFlag = true;
                return "byte_" + propertyName;
            }
            case "ONE_TO_ONE": 
            case "MANY_TO_ONE": {
                return this.getRelationalFieldHeader(property, csvInput, "ONE");
            }
            case "ONE_TO_MANY": 
            case "MANY_TO_MANY": {
                return this.getRelationalFieldHeader(property, csvInput, "MANY");
            }
        }
        return propertyName;
    }

    private String getDateOrDateTimeHeader(Property property, CSVInput csvInput) {
        String propertyName = property.getName();
        CSVBind csvBind = new CSVBind();
        csvBind.setField(propertyName);
        csvBind.setColumn(propertyName);
        if (property.getType().toString().equals("DATE")) {
            csvBind.setExpression("call:com.axelor.csv.script.ImportDateTime:importDate(" + propertyName + ")");
        } else {
            csvBind.setExpression("call:com.axelor.csv.script.ImportDateTime:importDateTime(" + propertyName + ")");
        }
        csvInput.getBindings().add(csvBind);
        return propertyName;
    }

    private String getRelationalFieldHeader(Property property, CSVInput csvInput, String relationship) {
        String search;
        csvInput.setSearch("self.importId = :importId");
        CSVBind csvBind = new CSVBind();
        String columnName = property.getName() + "_importId";
        String string = search = relationship.equalsIgnoreCase("ONE") ? "self.importId = :" + columnName : "self.importId in :" + columnName;
        if (property.getTarget() != null && property.getTarget().getPackage().equals(Package.getPackage("com.axelor.meta.db")) && !property.getTarget().getTypeName().equals("com.axelor.meta.db.MetaFile")) {
            columnName = property.getName() + "_name";
            search = relationship.equalsIgnoreCase("ONE") ? "self.name = :" + columnName : "self.name in :" + columnName;
        }
        csvBind.setColumn(columnName);
        csvBind.setField(property.getName());
        csvBind.setSearch(search);
        csvBind.setUpdate(true);
        if (relationship.equalsIgnoreCase("MANY")) {
            csvBind.setExpression(columnName + ".split('\\\\|') as List");
        }
        csvInput.getBindings().add(csvBind);
        this.referenceFlag = true;
        if (property.isRequired()) {
            this.notNullReferenceFlag = true;
        }
        return columnName;
    }

    private String getMetaModelData(String metaModelName, Mapper metaModelMapper, Property property, Object dataObject, String dirPath, boolean isRelativeDate, boolean updateImportId) {
        String propertyTypeStr;
        String id = metaModelMapper.get(dataObject, "id").toString();
        Object value = metaModelMapper.get(dataObject, property.getName());
        if (value == null) {
            return "";
        }
        switch (propertyTypeStr = property.getType().toString()) {
            case "LONG": {
                if (updateImportId) {
                    return ((Model)dataObject).getImportId();
                }
                return value.toString();
            }
            case "DATE": {
                if (isRelativeDate) {
                    return this.createRelativeDate((LocalDate)value);
                }
                return value.toString();
            }
            case "DATETIME": {
                if (isRelativeDate) {
                    if (property.getJavaType() == ZonedDateTime.class) {
                        return this.createRelativeDateTime(((ZonedDateTime)value).toLocalDateTime());
                    }
                    return this.createRelativeDateTime((LocalDateTime)value);
                }
                return property.getJavaType() == ZonedDateTime.class ? ((ZonedDateTime)value).toLocalDateTime().toString() : value.toString();
            }
            case "BINARY": {
                String fileName = metaModelName + "_" + property.getName() + "_" + id + ".png";
                try {
                    FileUtils.writeByteArrayToFile((File)new File(dirPath, fileName), (byte[])((byte[])value));
                    this.fileNameList.add(fileName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return fileName;
            }
            case "ONE_TO_ONE": 
            case "MANY_TO_ONE": {
                return this.getRelationalFieldValue(property, value, updateImportId);
            }
            case "ONE_TO_MANY": 
            case "MANY_TO_MANY": {
                return this.getRelationalFieldData(property, value, updateImportId);
            }
        }
        return value.toString();
    }

    public String createRelativeDateTime(LocalDateTime dateT) {
        LocalDateTime currentDateTime = LocalDateTime.now();
        long years = currentDateTime.until(dateT, ChronoUnit.YEARS);
        currentDateTime = currentDateTime.plusYears(years);
        long months = currentDateTime.until(dateT, ChronoUnit.MONTHS);
        currentDateTime = currentDateTime.plusMonths(months);
        long days = currentDateTime.until(dateT, ChronoUnit.DAYS);
        currentDateTime = currentDateTime.plusDays(days);
        long hours = currentDateTime.until(dateT, ChronoUnit.HOURS);
        currentDateTime = currentDateTime.plusHours(hours);
        long minutes = currentDateTime.until(dateT, ChronoUnit.MINUTES);
        long seconds = (currentDateTime = currentDateTime.plusMinutes(minutes)).until(dateT, ChronoUnit.SECONDS);
        if (seconds < 0L || minutes < 0L || hours < 0L || days < 0L || months < 0L || years < 0L) {
            return "NOW[" + (years == 0L ? "" : years + "y") + (months == 0L ? "" : months + "M") + (days == 0L ? "" : days + "d") + (hours == 0L ? "" : hours + "H") + (minutes == 0L ? "" : minutes + "m") + (seconds == 0L ? "" : seconds + "s") + "]";
        }
        return "NOW[" + (years == 0L ? "" : "+" + years + "y") + (months == 0L ? "" : "+" + months + "M") + (days == 0L ? "" : "+" + days + "d") + (hours == 0L ? "" : "+" + hours + "H") + (minutes == 0L ? "" : "+" + minutes + "m") + (seconds == 0L ? "" : "+" + seconds + "s") + "]";
    }

    public String createRelativeDate(LocalDate date) {
        LocalDate currentDate = DateTool.getTodayDate(null);
        long years = currentDate.until(date, ChronoUnit.YEARS);
        currentDate = currentDate.plusYears(years);
        long months = currentDate.until(date, ChronoUnit.MONTHS);
        currentDate = currentDate.plusMonths(months);
        long days = currentDate.until(date, ChronoUnit.DAYS);
        currentDate = currentDate.plusDays(days);
        if (days < 0L || months < 0L || years < 0L) {
            return "TODAY[" + (years == 0L ? "" : years + "y") + (months == 0L ? "" : months + "M") + (days == 0L ? "" : days + "d") + "]";
        }
        if (days == 0L && months == 0L && years == 0L) {
            return "TODAY";
        }
        return "TODAY[" + (years == 0L ? "" : "+" + years + "y") + (months == 0L ? "" : "+" + months + "M") + (days == 0L ? "" : "+" + days + "d") + "]";
    }

    public String getRelationalFieldData(Property property, Object value, boolean updateImportId) {
        StringBuilder idStringBuilder = new StringBuilder();
        Collection valueList = (Collection)value;
        String referenceData = "";
        for (Object val : valueList) {
            referenceData = this.getRelationalFieldValue(property, val, updateImportId);
            if (!StringUtils.notBlank((CharSequence)referenceData)) continue;
            idStringBuilder.append(referenceData + '|');
        }
        if (StringUtils.notBlank((CharSequence)idStringBuilder)) {
            idStringBuilder.setLength(idStringBuilder.length() - 1);
        }
        return idStringBuilder.toString();
    }

    private String getRelationalFieldValue(Property property, Object val, boolean updateImportId) {
        if (property.getTarget() != null && property.getTarget().getPackage().equals(Package.getPackage("com.axelor.meta.db")) && !property.getTarget().getTypeName().equals("com.axelor.meta.db.MetaFile")) {
            try {
                return Mapper.of(val.getClass()).get(val, "name").toString();
            }
            catch (Exception e) {
                return updateImportId ? ((Model)val).getImportId() : ((Model)val).getId().toString();
            }
        }
        return updateImportId ? ((Model)val).getImportId() : ((Model)val).getId().toString();
    }

    private File generateZIP(String dirPath, List<String> fileNameList) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmSS");
        String backupZipFileName = "DataBackup_" + LocalDateTime.now().format(formatter) + ".zip";
        File zipFile = new File(dirPath, backupZipFileName);
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));){
            for (String fileName : fileNameList) {
                ZipEntry e = new ZipEntry(fileName);
                out.putNextEntry(e);
                File file = new File(dirPath, fileName);
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
                Throwable throwable = null;
                try {
                    while (bin.available() > 0) {
                        byte[] data = bin.available() < 1000 ? new byte[bin.available()] : new byte[1000];
                        bin.read(data, 0, data.length);
                        out.write(data, 0, data.length);
                    }
                    bin.close();
                    out.closeEntry();
                    file.delete();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bin == null) continue;
                    if (throwable != null) {
                        try {
                            bin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bin.close();
                }
            }
            out.close();
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e, (String)"Error From DataBackupCreateService - generateZIP()");
        }
        return zipFile;
    }

    private void generateConfig(String dirPath, CSVConfig csvConfig) {
        File file = new File(dirPath, "config.xml");
        try (FileWriter fileWriter = new FileWriter(file, true);){
            XStream xStream = new XStream();
            xStream.processAnnotations(CSVConfig.class);
            xStream.setMode(1001);
            fileWriter.append(xStream.toXML((Object)csvConfig));
            fileWriter.close();
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e, (String)"Error From DataBackupCreateService - generateConfig()");
        }
    }
}

