/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.app;

import com.axelor.apps.base.db.DataBackup;
import com.axelor.apps.base.db.repo.DataBackupRepository;
import com.axelor.apps.base.service.app.DataBackupCreateService;
import com.axelor.apps.base.service.app.DataBackupRestoreService;
import com.axelor.apps.base.service.app.DataBackupService;
import com.axelor.auth.AuditableRunner;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.google.inject.servlet.RequestScoper;
import com.google.inject.servlet.ServletScopes;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBackupServiceImpl
implements DataBackupService {
    static final String CONFIG_FILE_NAME = "config.xml";
    @Inject
    private DataBackupCreateService createService;
    @Inject
    private DataBackupRestoreService restoreService;
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private DataBackupRepository dataBackupRepository;
    @Inject
    private MetaModelRepository metaModelRepo;
    private ExecutorService executor = Executors.newCachedThreadPool();

    @Override
    @Transactional
    public void createBackUp(DataBackup dataBackup) {
        final DataBackup obj = (DataBackup)((Object)this.dataBackupRepository.find(dataBackup.getId()));
        obj.setStatusSelect(1);
        this.dataBackupRepository.save((Model)((Object)obj));
        if (dataBackup.getUpdateImportId().booleanValue()) {
            this.updateImportId();
        }
        try {
            this.executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    RequestScoper scope = ServletScopes.scopeRequest(Collections.emptyMap());
                    try (RequestScoper.CloseableScope ignored = scope.open();){
                        DataBackupServiceImpl.this.startBackup(obj);
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void startBackup(final DataBackup dataBackup) throws Exception {
        AuditableRunner runner = (AuditableRunner)Beans.get(AuditableRunner.class);
        Callable<Boolean> job = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Logger LOG = LoggerFactory.getLogger(this.getClass());
                DataBackup obj = (DataBackup)((Object)((DataBackupRepository)((Object)Beans.get(DataBackupRepository.class))).find(dataBackup.getId()));
                File backupFile = DataBackupServiceImpl.this.createService.create(obj);
                DataBackupServiceImpl.this.dataBackupRepository.refresh((Model)((Object)obj));
                obj.setBackupMetaFile(DataBackupServiceImpl.this.metaFiles.upload(backupFile));
                obj.setStatusSelect(2);
                ((DataBackupRepository)((Object)Beans.get(DataBackupRepository.class))).save((Model)((Object)obj));
                LOG.info("Data BackUp Saved");
                return true;
            }
        };
        runner.run((Callable)job);
    }

    @Override
    @Transactional
    public void restoreBackUp(final DataBackup dataBackup) {
        DataBackup obj = (DataBackup)((Object)this.dataBackupRepository.find(dataBackup.getId()));
        obj.setStatusSelect(1);
        this.dataBackupRepository.save((Model)((Object)obj));
        try {
            this.executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    DataBackupServiceImpl.this.startRestore(dataBackup);
                    return true;
                }
            });
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    protected void startRestore(final DataBackup dataBackup) throws Exception {
        AuditableRunner runner = (AuditableRunner)Beans.get(AuditableRunner.class);
        Callable<Boolean> job = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Logger LOG = LoggerFactory.getLogger(this.getClass());
                DataBackup obj = (DataBackup)((Object)((DataBackupRepository)((Object)Beans.get(DataBackupRepository.class))).find(dataBackup.getId()));
                File logFile = DataBackupServiceImpl.this.restoreService.restore(obj.getBackupMetaFile());
                this.save(logFile, obj);
                LOG.info("Data Restore Saved");
                return true;
            }

            public void save(File logFile, DataBackup obj) {
                try {
                    JPA.em().getTransaction().begin();
                    obj = (DataBackup)((Object)((DataBackupRepository)((Object)Beans.get(DataBackupRepository.class))).find(dataBackup.getId()));
                    if (logFile != null) {
                        obj.setStatusSelect(3);
                        obj.setLogMetaFile(DataBackupServiceImpl.this.metaFiles.upload(logFile));
                    } else {
                        obj.setStatusSelect(4);
                    }
                    ((DataBackupRepository)((Object)Beans.get(DataBackupRepository.class))).save((Model)((Object)obj));
                    JPA.em().getTransaction().commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        runner.run((Callable)job);
    }

    @Override
    public boolean sequencesOrMrpLineTypesExist() {
        return this.restoreService.sequencesOrMrpLineTypesExist();
    }

    @Transactional
    public void updateImportId() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddMMyyHHmm");
        String filterStr = "self.packageName NOT LIKE '%meta%' AND self.packageName !='com.axelor.studio.db' AND self.name!='DataBackup' AND self.tableName IS NOT NULL";
        List metaModelList = this.metaModelRepo.all().filter(filterStr).fetch();
        metaModelList.add(this.metaModelRepo.findByName(MetaFile.class.getSimpleName()));
        metaModelList.add(this.metaModelRepo.findByName(MetaJsonField.class.getSimpleName()));
        for (MetaModel metaModel : metaModelList) {
            try {
                Class.forName(metaModel.getFullName());
                String currentDateTimeStr = "'" + LocalDateTime.now().format(formatter).toString() + "'";
                String query = "Update " + metaModel.getName() + " self SET self.importId = CONCAT(CAST(self.id as text)," + currentDateTimeStr + ") WHERE self.importId=null";
                JPA.execute((String)query);
            }
            catch (ClassNotFoundException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
    }
}

