/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.service;

import com.axelor.apps.tool.StringTool;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.PermissionAssistant;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.auth.db.repo.PermissionAssistantRepository;
import com.axelor.auth.db.repo.PermissionRepository;
import com.axelor.auth.db.repo.RoleRepository;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaPermission;
import com.axelor.meta.db.MetaPermissionRule;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.db.repo.MetaPermissionRepository;
import com.axelor.meta.db.repo.MetaPermissionRuleRepository;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionAssistantService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private MetaPermissionRepository metaPermissionRepository;
    @Inject
    private PermissionRepository permissionRepository;
    @Inject
    private MetaPermissionRuleRepository ruleRepository;
    @Inject
    private GroupRepository groupRepository;
    @Inject
    private MetaModelRepository modelRepository;
    @Inject
    private MetaFieldRepository fieldRepository;
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private RoleRepository roleRepo;
    private String errorLog = "";
    private Collection<String> header = Arrays.asList("Object", "Field", "Title");
    private Collection<String> groupHeader = Arrays.asList("", "Read", "Write", "Create", "Delete", "Export", "Condition", "ConditionParams", "Readonly If", "Hide If");

    private String getFileName(PermissionAssistant assistant) {
        String userCode = assistant.getCreatedBy().getCode();
        String dateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
        String fileName = userCode + "-" + dateString + ".csv";
        return fileName;
    }

    public void createFile(PermissionAssistant assistant) {
        File permFile = new File(Files.createTempDir(), this.getFileName(assistant));
        try {
            try (FileWriterWithEncoding fileWriter = new FileWriterWithEncoding(permFile, StandardCharsets.UTF_8);){
                CSVWriter csvWriter = new CSVWriter((Writer)fileWriter, ';');
                this.writeGroup(csvWriter, assistant);
            }
            this.createMetaFile(permFile, assistant);
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage());
            TraceBackService.trace((Throwable)e);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createMetaFile(File permFile, PermissionAssistant assistant) throws IOException {
        assistant.setMetaFile(this.metaFiles.upload(permFile));
        ((PermissionAssistantRepository)((Object)Beans.get(PermissionAssistantRepository.class))).save((Model)((Object)assistant));
    }

    private Collection<String> getTranslatedStrings(Collection<String> strings, ResourceBundle bundle) {
        return strings.stream().map(bundle::getString).collect(Collectors.toList());
    }

    private void writeGroup(CSVWriter csvWriter, PermissionAssistant assistant) {
        String[] groupRow = null;
        Integer count = this.header.size();
        ResourceBundle bundle = I18n.getBundle((Locale)new Locale(assistant.getLanguage()));
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.addAll(this.getTranslatedStrings(this.header, bundle));
        if (assistant.getTypeSelect() == 1) {
            groupRow = new String[this.header.size() + assistant.getGroupSet().size() * this.groupHeader.size()];
            for (Group group : assistant.getGroupSet()) {
                groupRow[count.intValue() + 1] = group.getCode();
                headerRow.addAll(this.getTranslatedStrings(this.groupHeader, bundle));
                count = count + this.groupHeader.size();
            }
        } else if (assistant.getTypeSelect() == 2) {
            groupRow = new String[this.header.size() + assistant.getRoleSet().size() * this.groupHeader.size()];
            for (Role role : assistant.getRoleSet()) {
                groupRow[count.intValue() + 1] = role.getName();
                headerRow.addAll(this.getTranslatedStrings(this.groupHeader, bundle));
                count = count + this.groupHeader.size();
            }
        }
        LOG.debug("Header row created: {}", headerRow);
        csvWriter.writeNext(groupRow);
        csvWriter.writeNext(headerRow.toArray(groupRow));
        this.writeObject(csvWriter, assistant, groupRow.length, bundle);
    }

    public Comparator<Object> compareField() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object field1, Object field2) {
                return ((MetaField)field1).getName().compareTo(((MetaField)field2).getName());
            }
        };
    }

    private void writeObject(CSVWriter csvWriter, PermissionAssistant assistant, Integer size, ResourceBundle bundle) {
        MetaField userField = assistant.getMetaField();
        for (MetaModel object : assistant.getObjectSet()) {
            String permName;
            int colIndex = this.header.size() + 1;
            String[] row = new String[size.intValue()];
            row[0] = object.getFullName();
            if (assistant.getTypeSelect() == 1) {
                for (Group group : assistant.getGroupSet()) {
                    permName = this.getPermissionName(userField, object.getName(), group.getCode());
                    colIndex = this.writePermission(object, userField, row, colIndex, permName);
                    ++colIndex;
                }
            } else if (assistant.getTypeSelect() == 2) {
                for (Role role : assistant.getRoleSet()) {
                    permName = this.getPermissionName(userField, object.getName(), role.getName());
                    colIndex = this.writePermission(object, userField, row, colIndex, permName);
                    ++colIndex;
                }
            }
            csvWriter.writeNext(row);
            if (!assistant.getFieldPermission().booleanValue()) continue;
            List fieldList = object.getMetaFields();
            Collections.sort(fieldList, this.compareField());
            for (MetaField field : fieldList) {
                String permName2;
                colIndex = this.header.size() + 1;
                row = new String[size.intValue()];
                row[1] = field.getName();
                row[2] = this.getFieldTitle(field, bundle);
                if (assistant.getTypeSelect() == 1) {
                    for (Group group : assistant.getGroupSet()) {
                        permName2 = this.getPermissionName(null, object.getName(), group.getCode());
                        colIndex = this.writeFieldPermission(field, row, colIndex, permName2);
                        ++colIndex;
                    }
                } else if (assistant.getTypeSelect() == 2) {
                    for (Role role : assistant.getRoleSet()) {
                        permName2 = this.getPermissionName(null, object.getName(), role.getName());
                        colIndex = this.writeFieldPermission(field, row, colIndex, permName2);
                        ++colIndex;
                    }
                }
                csvWriter.writeNext(row);
            }
        }
    }

    private String getPermissionName(MetaField userField, String objectName, String suffix) {
        String permName = "perm." + objectName + "." + suffix;
        if (userField != null) {
            permName = permName + "." + userField.getName();
        }
        return permName;
    }

    private String getFieldTitle(MetaField field, ResourceBundle bundle) {
        String title = field.getLabel();
        if (!Strings.isNullOrEmpty((String)title) && Strings.isNullOrEmpty((String)(title = bundle.getString(title)))) {
            title = field.getLabel();
        }
        return title;
    }

    private int writeFieldPermission(MetaField field, String[] row, int colIndex, String permName) {
        MetaPermissionRule rule = (MetaPermissionRule)this.ruleRepository.all().filter("self.metaPermission.name = ?1 and self.metaPermission.object = ?2 and self.field = ?3", new Object[]{permName, field.getMetaModel().getFullName(), field.getName()}).fetchOne();
        if (rule != null) {
            row[colIndex++] = rule.getCanRead() == false ? "" : "x";
            row[colIndex++] = rule.getCanWrite() == false ? "" : "x";
            row[colIndex++] = "";
            row[colIndex++] = "";
            row[colIndex++] = rule.getCanExport() == false ? "" : "x";
            row[colIndex++] = "";
            row[colIndex++] = "";
            row[colIndex++] = Strings.isNullOrEmpty((String)rule.getReadonlyIf()) ? "" : rule.getReadonlyIf();
            row[colIndex++] = Strings.isNullOrEmpty((String)rule.getHideIf()) ? "" : rule.getHideIf();
        }
        return colIndex;
    }

    private int writePermission(MetaModel object, MetaField userField, String[] row, int colIndex, String permName) {
        MetaField objectField;
        Permission perm = this.permissionRepository.findByName(permName);
        if (perm != null && perm.getObject().equals(object.getFullName())) {
            row[colIndex++] = perm.getCanRead() == false ? "" : "x";
            row[colIndex++] = perm.getCanWrite() == false ? "" : "x";
            row[colIndex++] = perm.getCanCreate() == false ? "" : "x";
            row[colIndex++] = perm.getCanRemove() == false ? "" : "x";
            row[colIndex++] = perm.getCanExport() == false ? "" : "x";
            row[colIndex++] = Strings.isNullOrEmpty((String)perm.getCondition()) ? "" : perm.getCondition();
            row[colIndex++] = Strings.isNullOrEmpty((String)perm.getConditionParams()) ? "" : perm.getConditionParams();
            row[colIndex++] = "";
            row[colIndex++] = "";
        } else if (userField != null && (objectField = (MetaField)this.fieldRepository.all().filter("self.typeName = ?1 and self.metaModel = ?2 and self.relationship = 'ManyToOne'", new Object[]{userField.getTypeName(), object}).fetchOne()) != null) {
            String condition = "";
            String conditionParams = "__user__." + userField.getName();
            condition = userField.getRelationship().contentEquals("ManyToOne") ? "self." + objectField.getName() + " = ?" : "self." + objectField.getName() + " in (?)";
            row[colIndex++] = "x";
            row[colIndex++] = "x";
            row[colIndex++] = "x";
            row[colIndex++] = "x";
            row[colIndex++] = "x";
            row[colIndex++] = condition;
            row[colIndex++] = conditionParams;
            row[colIndex++] = "";
            row[colIndex++] = "";
        }
        return colIndex;
    }

    private static boolean headerEquals(Collection<String> standardRow, Collection<String> translatedRow, Collection<String> headerRow) {
        if (standardRow.size() != translatedRow.size() || headerRow.size() != standardRow.size()) {
            return false;
        }
        Iterator<String> itStandard = standardRow.iterator();
        Iterator<String> itTranslated = translatedRow.iterator();
        Iterator<String> it = headerRow.iterator();
        while (it.hasNext()) {
            String standard = itStandard.next();
            String translated = itTranslated.next();
            String name = it.next();
            if (StringTool.equalsIgnoreCaseAndAccents((String)standard, (String)name) || StringTool.equalsIgnoreCaseAndAccents((String)translated, (String)name)) continue;
            return false;
        }
        return true;
    }

    private boolean checkHeaderRow(Collection<String> headerRow, ResourceBundle bundle) {
        Collection<String> translatedHeader = this.getTranslatedStrings(this.header, bundle);
        Collection<String> translatedGroupHeader = this.getTranslatedStrings(this.groupHeader, bundle);
        ArrayList standardRow = Lists.newArrayList(this.header);
        for (int count = this.header.size(); count < headerRow.size(); count += this.groupHeader.size()) {
            standardRow.addAll(this.groupHeader);
        }
        ArrayList translatedRow = Lists.newArrayList(translatedHeader);
        for (int count = this.header.size(); count < headerRow.size(); count += this.groupHeader.size()) {
            translatedRow.addAll(translatedGroupHeader);
        }
        LOG.debug("Standard Headers: {}", (Object)standardRow);
        LOG.debug("File Headers: {}", headerRow);
        return PermissionAssistantService.headerEquals(standardRow, translatedRow, headerRow);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String importPermissions(PermissionAssistant permissionAssistant) {
        try {
            ResourceBundle bundle = I18n.getBundle((Locale)new Locale(permissionAssistant.getLanguage()));
            MetaFile metaFile = permissionAssistant.getMetaFile();
            File csvFile = MetaFiles.getPath((MetaFile)metaFile).toFile();
            try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(csvFile), StandardCharsets.UTF_8), ';');){
                String[] headerRow;
                String[] groupRow = csvReader.readNext();
                if (groupRow == null || groupRow.length < 11) {
                    this.errorLog = I18n.get((String)"Bad import file");
                }
                if ((headerRow = csvReader.readNext()) == null) {
                    this.errorLog = I18n.get((String)"No header row found");
                }
                if (!this.checkHeaderRow(Arrays.asList(headerRow), bundle)) {
                    this.errorLog = I18n.get((String)"Bad header row:") + " " + Arrays.asList(headerRow);
                }
                if (!this.errorLog.equals("")) {
                    String string = this.errorLog;
                    return string;
                }
                if (permissionAssistant.getTypeSelect() == 1) {
                    Map<String, Group> groupMap = this.checkBadGroups(groupRow);
                    this.processGroupCSV(csvReader, groupRow, groupMap, permissionAssistant.getMetaField(), permissionAssistant.getFieldPermission());
                    this.saveGroups(groupMap);
                    return this.errorLog;
                }
                if (permissionAssistant.getTypeSelect() != 2) return this.errorLog;
                Map<String, Role> roleMap = this.checkBadRoles(groupRow);
                this.processRoleCSV(csvReader, groupRow, roleMap, permissionAssistant.getMetaField(), permissionAssistant.getFieldPermission());
                this.saveRoles(roleMap);
                return this.errorLog;
            }
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage());
            TraceBackService.trace((Throwable)e);
            this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Error in import: %s. Please check the server log"), e.getMessage());
        }
        return this.errorLog;
    }

    @Transactional
    public void saveGroups(Map<String, Group> groupMap) {
        for (Group group : groupMap.values()) {
            this.groupRepository.save((Model)group);
        }
    }

    @Transactional
    public void saveRoles(Map<String, Role> roleMap) {
        for (Role role : roleMap.values()) {
            this.roleRepo.save((Model)role);
        }
    }

    private Map<String, Group> checkBadGroups(String[] groupRow) {
        ArrayList<String> badGroups = new ArrayList<String>();
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        Integer glen = this.header.size() + 1;
        while (glen < groupRow.length) {
            String groupName = groupRow[glen];
            Group group = (Group)this.groupRepository.all().filter("self.code = ?1", new Object[]{groupName}).fetchOne();
            if (group == null) {
                badGroups.add(groupName);
            } else {
                groupMap.put(groupName, group);
            }
            glen = glen + this.groupHeader.size();
        }
        if (!badGroups.isEmpty()) {
            this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Groups not found: %s"), badGroups);
        }
        return groupMap;
    }

    private Map<String, Role> checkBadRoles(String[] roleRow) {
        ArrayList<String> badroles = new ArrayList<String>();
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        Integer len = this.header.size() + 1;
        while (len < roleRow.length) {
            String roleName = roleRow[len];
            Role role = (Role)this.roleRepo.all().filter("self.name = ?1", new Object[]{roleName}).fetchOne();
            if (roleName == null) {
                badroles.add(roleName);
            } else {
                roleMap.put(roleName, role);
            }
            len = len + this.groupHeader.size();
        }
        if (!badroles.isEmpty()) {
            this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Roles not found: %s"), badroles);
        }
        return roleMap;
    }

    private String checkObject(String objectName) {
        MetaModel model = (MetaModel)this.modelRepository.all().filter("self.fullName = ?1", new Object[]{objectName}).fetchOne();
        if (model == null) {
            this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Object not found: %s"), objectName);
            return null;
        }
        return objectName;
    }

    private void processGroupCSV(CSVReader csvReader, String[] groupRow, Map<String, Group> groupMap, MetaField field, Boolean fieldBoolean) throws IOException {
        HashMap<String, MetaPermission> metaPermDict = new HashMap<String, MetaPermission>();
        String objectName = null;
        String[] row = csvReader.readNext();
        while (row != null) {
            Integer groupIndex = this.header.size() + 1;
            while (groupIndex < row.length) {
                String groupName = groupRow[groupIndex];
                if (groupMap.containsKey(groupName)) {
                    String[] rowGroup = Arrays.copyOfRange(row, (int)groupIndex, groupIndex + this.groupHeader.size());
                    if (!Strings.isNullOrEmpty((String)groupName) && !Strings.isNullOrEmpty((String)row[0])) {
                        objectName = this.checkObject(row[0]);
                        if (objectName == null) break;
                        if (fieldBoolean.booleanValue()) {
                            metaPermDict.put(groupName, this.getMetaPermission(groupMap.get(groupName), objectName));
                        }
                        this.updatePermission(groupMap.get(groupName), objectName, field, rowGroup);
                    } else if (fieldBoolean.booleanValue() && objectName != null && !Strings.isNullOrEmpty((String)row[1])) {
                        this.updateFieldPermission((MetaPermission)metaPermDict.get(groupName), row[1], rowGroup);
                    }
                }
                groupIndex = groupIndex + this.groupHeader.size();
            }
            row = csvReader.readNext();
        }
    }

    private void processRoleCSV(CSVReader csvReader, String[] roleRow, Map<String, Role> roleMap, MetaField field, Boolean fieldPermission) throws IOException {
        HashMap<String, MetaPermission> metaPermDict = new HashMap<String, MetaPermission>();
        String objectName = null;
        String[] row = csvReader.readNext();
        while (row != null) {
            Integer groupIndex = this.header.size() + 1;
            while (groupIndex < row.length) {
                String roleName = roleRow[groupIndex];
                if (roleMap.containsKey(roleName)) {
                    String[] rowGroup = Arrays.copyOfRange(row, (int)groupIndex, groupIndex + this.groupHeader.size());
                    if (!Strings.isNullOrEmpty((String)roleName) && !Strings.isNullOrEmpty((String)row[0])) {
                        objectName = this.checkObject(row[0]);
                        if (objectName == null) break;
                        if (fieldPermission.booleanValue()) {
                            metaPermDict.put(roleName, this.getMetaPermission(roleMap.get(roleName), objectName));
                        }
                        this.updatePermission(roleMap.get(roleName), objectName, field, rowGroup);
                    } else if (fieldPermission.booleanValue() && objectName != null && !Strings.isNullOrEmpty((String)row[1])) {
                        this.updateFieldPermission((MetaPermission)metaPermDict.get(roleName), row[1], rowGroup);
                    }
                }
                groupIndex = groupIndex + this.groupHeader.size();
            }
            row = csvReader.readNext();
        }
    }

    public MetaPermission getMetaPermission(Group group, String objectName) {
        String[] objectNames = objectName.split("\\.");
        String groupName = group.getCode();
        String permName = this.getPermissionName(null, objectNames[objectNames.length - 1], group.getCode());
        MetaPermission metaPermission = (MetaPermission)this.metaPermissionRepository.all().filter("self.name = ?1", new Object[]{permName}).fetchOne();
        if (metaPermission == null) {
            LOG.debug("Create metaPermission group: {}, object: {}", (Object)groupName, (Object)objectName);
            metaPermission = new MetaPermission();
            metaPermission.setName(permName);
            metaPermission.setObject(objectName);
            group.addMetaPermission(metaPermission);
        }
        return metaPermission;
    }

    public MetaPermission getMetaPermission(Role role, String objectName) {
        String[] objectNames = objectName.split("\\.");
        String roleName = role.getName();
        String permName = this.getPermissionName(null, objectNames[objectNames.length - 1], roleName);
        MetaPermission metaPermission = (MetaPermission)this.metaPermissionRepository.all().filter("self.name = ?1", new Object[]{permName}).fetchOne();
        if (metaPermission == null) {
            LOG.debug("Create metaPermission role: {}, object: {}", (Object)roleName, (Object)objectName);
            metaPermission = new MetaPermission();
            metaPermission.setName(permName);
            metaPermission.setObject(objectName);
            role.addMetaPermission(metaPermission);
        }
        return metaPermission;
    }

    public MetaPermission updateFieldPermission(MetaPermission metaPermission, String field, String[] row) {
        MetaPermissionRule permissionRule = (MetaPermissionRule)this.ruleRepository.all().filter("self.field = ?1 and self.metaPermission.name = ?2", new Object[]{field, metaPermission.getName()}).fetchOne();
        if (permissionRule == null) {
            permissionRule = new MetaPermissionRule();
            permissionRule.setMetaPermission(metaPermission);
            permissionRule.setField(field);
        }
        permissionRule.setCanRead(Boolean.valueOf(row[0].equalsIgnoreCase("x")));
        permissionRule.setCanWrite(Boolean.valueOf(row[1].equalsIgnoreCase("x")));
        permissionRule.setCanExport(Boolean.valueOf(row[4].equalsIgnoreCase("x")));
        permissionRule.setReadonlyIf(row[5]);
        permissionRule.setHideIf(row[6]);
        metaPermission.addRule(permissionRule);
        return metaPermission;
    }

    public void updatePermission(Group group, String objectName, MetaField field, String[] row) {
        String[] objectNames = objectName.split("\\.");
        String permName = this.getPermissionName(field, objectNames[objectNames.length - 1], group.getCode());
        Permission permission = (Permission)this.permissionRepository.all().filter("self.name = ?1", new Object[]{permName}).fetchOne();
        boolean newPermission = false;
        if (permission == null) {
            newPermission = true;
            permission = new Permission();
            permission.setName(permName);
            permission.setObject(objectName);
        }
        permission.setCanRead(Boolean.valueOf(row[0].equalsIgnoreCase("x")));
        permission.setCanWrite(Boolean.valueOf(row[1].equalsIgnoreCase("x")));
        permission.setCanCreate(Boolean.valueOf(row[2].equalsIgnoreCase("x")));
        permission.setCanRemove(Boolean.valueOf(row[3].equalsIgnoreCase("x")));
        permission.setCanExport(Boolean.valueOf(row[4].equalsIgnoreCase("x")));
        if (newPermission) {
            group.addPermission(permission);
        }
    }

    public void updatePermission(Role role, String objectName, MetaField field, String[] row) {
        String[] objectNames = objectName.split("\\.");
        String permName = this.getPermissionName(field, objectNames[objectNames.length - 1], role.getName());
        Permission permission = (Permission)this.permissionRepository.all().filter("self.name = ?1", new Object[]{permName}).fetchOne();
        boolean newPermission = false;
        if (permission == null) {
            newPermission = true;
            permission = new Permission();
            permission.setName(permName);
            permission.setObject(objectName);
        }
        permission.setCanRead(Boolean.valueOf(row[0].equalsIgnoreCase("x")));
        permission.setCanWrite(Boolean.valueOf(row[1].equalsIgnoreCase("x")));
        permission.setCanCreate(Boolean.valueOf(row[2].equalsIgnoreCase("x")));
        permission.setCanRemove(Boolean.valueOf(row[3].equalsIgnoreCase("x")));
        permission.setCanExport(Boolean.valueOf(row[4].equalsIgnoreCase("x")));
        permission.setCondition(row[5]);
        permission.setConditionParams(row[6]);
        if (newPermission) {
            role.addPermission(permission);
        }
    }
}

