/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaMenu;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="META_GROUP_MENU_ASSISTANT", indexes={@Index(columnList="meta_file")})
public class MetaGroupMenuAssistant
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_GROUP_MENU_ASSISTANT_SEQ")
    @SequenceGenerator(name="META_GROUP_MENU_ASSISTANT_SEQ", sequenceName="META_GROUP_MENU_ASSISTANT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Groups")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groupSet;
    @Widget(title="Roles")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roleSet;
    @Widget(title="Menus")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaMenu> menuSet;
    @Widget(title="File")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @Widget(title="Import date")
    private LocalDateTime importDate;
    @Widget(title="Language", selection="select.language")
    private String language = "en";
    @Widget(title="Log")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String log;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<Group> getGroupSet() {
        return this.groupSet;
    }

    public void setGroupSet(Set<Group> groupSet) {
        this.groupSet = groupSet;
    }

    public void addGroupSetItem(Group item) {
        if (this.getGroupSet() == null) {
            this.setGroupSet(new HashSet<Group>());
        }
        this.getGroupSet().add(item);
    }

    public void removeGroupSetItem(Group item) {
        if (this.getGroupSet() == null) {
            return;
        }
        this.getGroupSet().remove(item);
    }

    public void clearGroupSet() {
        if (this.getGroupSet() != null) {
            this.getGroupSet().clear();
        }
    }

    public Set<Role> getRoleSet() {
        return this.roleSet;
    }

    public void setRoleSet(Set<Role> roleSet) {
        this.roleSet = roleSet;
    }

    public void addRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            this.setRoleSet(new HashSet<Role>());
        }
        this.getRoleSet().add(item);
    }

    public void removeRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            return;
        }
        this.getRoleSet().remove(item);
    }

    public void clearRoleSet() {
        if (this.getRoleSet() != null) {
            this.getRoleSet().clear();
        }
    }

    public Set<MetaMenu> getMenuSet() {
        return this.menuSet;
    }

    public void setMenuSet(Set<MetaMenu> menuSet) {
        this.menuSet = menuSet;
    }

    public void addMenuSetItem(MetaMenu item) {
        if (this.getMenuSet() == null) {
            this.setMenuSet(new HashSet<MetaMenu>());
        }
        this.getMenuSet().add(item);
    }

    public void removeMenuSetItem(MetaMenu item) {
        if (this.getMenuSet() == null) {
            return;
        }
        this.getMenuSet().remove(item);
    }

    public void clearMenuSet() {
        if (this.getMenuSet() != null) {
            this.getMenuSet().clear();
        }
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public LocalDateTime getImportDate() {
        return this.importDate;
    }

    public void setImportDate(LocalDateTime importDate) {
        this.importDate = importDate;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaGroupMenuAssistant)) {
            return false;
        }
        MetaGroupMenuAssistant other = (MetaGroupMenuAssistant)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("importDate", (Object)this.getImportDate()).add("language", (Object)this.getLanguage()).omitNullValues().toString();
    }
}

