/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db;

import com.axelor.apps.crm.db.CatalogType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CRM_CATALOG", indexes={@Index(columnList="name"), @Index(columnList="catalog_type"), @Index(columnList="pdf_file")})
@Track(fields={@TrackField(name="name"), @TrackField(name="description"), @TrackField(name="catalogType"), @TrackField(name="pdfFile")})
public class Catalog
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CRM_CATALOG_SEQ")
    @SequenceGenerator(name="CRM_CATALOG_SEQ", sequenceName="CRM_CATALOG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Catalog type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CatalogType catalogType;
    @Widget(title="PDF file")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile pdfFile;
    @Widget(title="Image")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] image;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Catalog() {
    }

    public Catalog(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    public void setCatalogType(CatalogType catalogType) {
        this.catalogType = catalogType;
    }

    public MetaFile getPdfFile() {
        return this.pdfFile;
    }

    public void setPdfFile(MetaFile pdfFile) {
        this.pdfFile = pdfFile;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Catalog)) {
            return false;
        }
        Catalog other = (Catalog)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

