/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.Lead;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CRM_EVENT_ATTENDEE", indexes={@Index(columnList="event"), @Index(columnList="contact_partner"), @Index(columnList="lead"), @Index(columnList="name")})
public class EventAttendee
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CRM_EVENT_ATTENDEE_SEQ")
    @SequenceGenerator(name="CRM_EVENT_ATTENDEE_SEQ", sequenceName="CRM_EVENT_ATTENDEE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Event")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Event event;
    @Widget(title="Status", selection="crm.event.attendee.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Contact")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="Lead")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Lead lead;
    @Widget(title="Attendee")
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EventAttendee() {
    }

    public EventAttendee(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public Lead getLead() {
        return this.lead;
    }

    public void setLead(Lead lead) {
        this.lead = lead;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventAttendee)) {
            return false;
        }
        EventAttendee other = (EventAttendee)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

