/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db;

import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Function;
import com.axelor.apps.base.db.IndustrySector;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Region;
import com.axelor.apps.base.db.Source;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.LostReason;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CRM_LEAD", indexes={@Index(columnList="name"), @Index(columnList="job_title_function"), @Index(columnList="primary_city"), @Index(columnList="primary_state"), @Index(columnList="primary_country"), @Index(columnList="email_address"), @Index(columnList="source"), @Index(columnList="partner"), @Index(columnList="user_id"), @Index(columnList="team"), @Index(columnList="industry_sector"), @Index(columnList="lost_reason"), @Index(columnList="fullName")})
@Track(fields={@TrackField(name="name"), @TrackField(name="statusSelect", on={TrackEvent.UPDATE})}, messages={@TrackMessage(message="Lead created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Lead Assigned", condition="statusSelect == 2", tag="important"), @TrackMessage(message="Lead Converted", condition="statusSelect == 5", tag="success")})
public class Lead
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CRM_LEAD_SEQ")
    @SequenceGenerator(name="CRM_LEAD_SEQ", sequenceName="CRM_LEAD_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Title", selection="partner.title.type.select")
    private String titleSelect;
    @Widget(title="Last name")
    @NotNull
    private String name;
    @Widget(title="First name")
    private String firstName;
    @Widget(title="Enterprise")
    private String enterpriseName;
    @Widget(title="Office name")
    private String officeName;
    @Widget(title="Job Title")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Function jobTitleFunction;
    @Widget(title="Mobile N\u00b0")
    private String mobilePhone;
    @Widget(title="Fixed Phone")
    private String fixedPhone;
    @Widget(title="Dep./Div.")
    private String department;
    @Widget(title="Fax")
    private String fax;
    @Widget(title="Website")
    private String webSite;
    @Widget(title="Address")
    private String primaryAddress;
    @Widget(title="City")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private City primaryCity;
    @Widget(title="Region")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Region primaryState;
    @Widget(title="Postal code")
    private String primaryPostalCode;
    @Widget(title="Country")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country primaryCountry;
    @Widget(title="Email")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAddress emailAddress;
    @Widget(title="Picture")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] picture;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Contact date")
    private LocalDate contactDate;
    @Widget(title="Status", selection="crm.lead.status.select", massUpdate=true)
    @NotNull
    private Integer statusSelect = 1;
    @Widget(title="Recycled")
    private Boolean isRecycled = Boolean.FALSE;
    @Widget(title="Source")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Source source;
    @Widget(title="Status description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String statusDescription;
    @Widget(title="Estimated budget")
    private BigDecimal estimatedBudget = BigDecimal.ZERO;
    @Widget(title="Source description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String sourceDescription;
    @Widget(title="Referred by")
    private String referredBy;
    @Widget(title="Rejection of calls")
    private Boolean isDoNotCall = Boolean.FALSE;
    @Widget(title="Rejection of e-mails")
    private Boolean isDoNotSendEmail = Boolean.FALSE;
    @Widget(title="Contact", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Assigned to", massUpdate=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Industry sector", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private IndustrySector industrySector;
    @Widget(title="Events")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="lead", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Event> eventList;
    @Widget(title="Opportunities")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="lead", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Opportunity> opportunitiesList;
    @Widget(title="Lost reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LostReason lostReason;
    @Widget(title="Lost reason")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String lostReasonStr;
    @Widget(title="Contact name")
    @NameColumn
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Lead() {
    }

    public Lead(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitleSelect() {
        return this.titleSelect;
    }

    public void setTitleSelect(String titleSelect) {
        this.titleSelect = titleSelect;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getEnterpriseName() {
        return this.enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getOfficeName() {
        return this.officeName;
    }

    public void setOfficeName(String officeName) {
        this.officeName = officeName;
    }

    public Function getJobTitleFunction() {
        return this.jobTitleFunction;
    }

    public void setJobTitleFunction(Function jobTitleFunction) {
        this.jobTitleFunction = jobTitleFunction;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getFixedPhone() {
        return this.fixedPhone;
    }

    public void setFixedPhone(String fixedPhone) {
        this.fixedPhone = fixedPhone;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getWebSite() {
        return this.webSite;
    }

    public void setWebSite(String webSite) {
        this.webSite = webSite;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public void setPrimaryAddress(String primaryAddress) {
        this.primaryAddress = primaryAddress;
    }

    public City getPrimaryCity() {
        return this.primaryCity;
    }

    public void setPrimaryCity(City primaryCity) {
        this.primaryCity = primaryCity;
    }

    public Region getPrimaryState() {
        return this.primaryState;
    }

    public void setPrimaryState(Region primaryState) {
        this.primaryState = primaryState;
    }

    public String getPrimaryPostalCode() {
        return this.primaryPostalCode;
    }

    public void setPrimaryPostalCode(String primaryPostalCode) {
        this.primaryPostalCode = primaryPostalCode;
    }

    public Country getPrimaryCountry() {
        return this.primaryCountry;
    }

    public void setPrimaryCountry(Country primaryCountry) {
        this.primaryCountry = primaryCountry;
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }

    public byte[] getPicture() {
        return this.picture;
    }

    public void setPicture(byte[] picture) {
        this.picture = picture;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDate getContactDate() {
        return this.contactDate;
    }

    public void setContactDate(LocalDate contactDate) {
        this.contactDate = contactDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIsRecycled() {
        return this.isRecycled == null ? Boolean.FALSE : this.isRecycled;
    }

    public void setIsRecycled(Boolean isRecycled) {
        this.isRecycled = isRecycled;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public BigDecimal getEstimatedBudget() {
        return this.estimatedBudget == null ? BigDecimal.ZERO : this.estimatedBudget;
    }

    public void setEstimatedBudget(BigDecimal estimatedBudget) {
        this.estimatedBudget = estimatedBudget;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public void setSourceDescription(String sourceDescription) {
        this.sourceDescription = sourceDescription;
    }

    public String getReferredBy() {
        return this.referredBy;
    }

    public void setReferredBy(String referredBy) {
        this.referredBy = referredBy;
    }

    public Boolean getIsDoNotCall() {
        return this.isDoNotCall == null ? Boolean.FALSE : this.isDoNotCall;
    }

    public void setIsDoNotCall(Boolean isDoNotCall) {
        this.isDoNotCall = isDoNotCall;
    }

    public Boolean getIsDoNotSendEmail() {
        return this.isDoNotSendEmail == null ? Boolean.FALSE : this.isDoNotSendEmail;
    }

    public void setIsDoNotSendEmail(Boolean isDoNotSendEmail) {
        this.isDoNotSendEmail = isDoNotSendEmail;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public IndustrySector getIndustrySector() {
        return this.industrySector;
    }

    public void setIndustrySector(IndustrySector industrySector) {
        this.industrySector = industrySector;
    }

    public List<Event> getEventList() {
        return this.eventList;
    }

    public void setEventList(List<Event> eventList) {
        this.eventList = eventList;
    }

    public void addEventListItem(Event item) {
        if (this.getEventList() == null) {
            this.setEventList(new ArrayList<Event>());
        }
        this.getEventList().add(item);
        item.setLead(this);
    }

    public void removeEventListItem(Event item) {
        if (this.getEventList() == null) {
            return;
        }
        this.getEventList().remove((Object)item);
    }

    public void clearEventList() {
        if (this.getEventList() != null) {
            this.getEventList().clear();
        }
    }

    public List<Opportunity> getOpportunitiesList() {
        return this.opportunitiesList;
    }

    public void setOpportunitiesList(List<Opportunity> opportunitiesList) {
        this.opportunitiesList = opportunitiesList;
    }

    public void addOpportunitiesListItem(Opportunity item) {
        if (this.getOpportunitiesList() == null) {
            this.setOpportunitiesList(new ArrayList<Opportunity>());
        }
        this.getOpportunitiesList().add(item);
        item.setLead(this);
    }

    public void removeOpportunitiesListItem(Opportunity item) {
        if (this.getOpportunitiesList() == null) {
            return;
        }
        this.getOpportunitiesList().remove((Object)item);
    }

    public void clearOpportunitiesList() {
        if (this.getOpportunitiesList() != null) {
            this.getOpportunitiesList().clear();
        }
    }

    public LostReason getLostReason() {
        return this.lostReason;
    }

    public void setLostReason(LostReason lostReason) {
        this.lostReason = lostReason;
    }

    public String getLostReasonStr() {
        return this.lostReasonStr;
    }

    public void setLostReasonStr(String lostReasonStr) {
        this.lostReasonStr = lostReasonStr;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Lead)) {
            return false;
        }
        Lead other = (Lead)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("titleSelect", (Object)this.getTitleSelect()).add("name", (Object)this.getName()).add("firstName", (Object)this.getFirstName()).add("enterpriseName", (Object)this.getEnterpriseName()).add("officeName", (Object)this.getOfficeName()).add("mobilePhone", (Object)this.getMobilePhone()).add("fixedPhone", (Object)this.getFixedPhone()).add("department", (Object)this.getDepartment()).add("fax", (Object)this.getFax()).add("webSite", (Object)this.getWebSite()).add("primaryAddress", (Object)this.getPrimaryAddress()).omitNullValues().toString();
    }
}

