/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CRM_TARGET", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="user_id"), @Index(columnList="team")})
public class Target
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CRM_TARGET_SEQ")
    @SequenceGenerator(name="CRM_TARGET_SEQ", sequenceName="CRM_TARGET_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="Assigned to")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Amount won", readonly=true)
    private BigDecimal opportunityAmountWon = BigDecimal.ZERO;
    @Widget(title="Created Nbr.", readonly=true)
    private Integer opportunityCreatedNumber = 0;
    @Widget(title="Created Won", readonly=true)
    private Integer opportunityCreatedWon = 0;
    @Widget(title="Amount Won")
    private BigDecimal opportunityAmountWonTarget = BigDecimal.ZERO;
    @Widget(title="Created Nbr.")
    private Integer opportunityCreatedNumberTarget = 0;
    @Widget(title="Closed Won")
    private Integer opportunityCreatedWonTarget = 0;
    @Widget(title="Call emitted Nbr.", readonly=true)
    private Integer callEmittedNumber = 0;
    @Widget(title="Meeting Nbr.", readonly=true)
    private Integer meetingNumber = 0;
    @Widget(title="Call emitted Nbr.")
    private Integer callEmittedNumberTarget = 0;
    @Widget(title="Meeting Nbr.")
    private Integer meetingNumberTarget = 0;
    @Widget(title="Period type", selection="crm.target.configuration.period.type.select")
    private Integer periodTypeSelect = 0;
    @Widget(title="Starting Date")
    private LocalDate fromDate;
    @Widget(title="End date")
    private LocalDate toDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Target() {
    }

    public Target(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public BigDecimal getOpportunityAmountWon() {
        return this.opportunityAmountWon == null ? BigDecimal.ZERO : this.opportunityAmountWon;
    }

    public void setOpportunityAmountWon(BigDecimal opportunityAmountWon) {
        this.opportunityAmountWon = opportunityAmountWon;
    }

    public Integer getOpportunityCreatedNumber() {
        return this.opportunityCreatedNumber == null ? 0 : this.opportunityCreatedNumber;
    }

    public void setOpportunityCreatedNumber(Integer opportunityCreatedNumber) {
        this.opportunityCreatedNumber = opportunityCreatedNumber;
    }

    public Integer getOpportunityCreatedWon() {
        return this.opportunityCreatedWon == null ? 0 : this.opportunityCreatedWon;
    }

    public void setOpportunityCreatedWon(Integer opportunityCreatedWon) {
        this.opportunityCreatedWon = opportunityCreatedWon;
    }

    public BigDecimal getOpportunityAmountWonTarget() {
        return this.opportunityAmountWonTarget == null ? BigDecimal.ZERO : this.opportunityAmountWonTarget;
    }

    public void setOpportunityAmountWonTarget(BigDecimal opportunityAmountWonTarget) {
        this.opportunityAmountWonTarget = opportunityAmountWonTarget;
    }

    public Integer getOpportunityCreatedNumberTarget() {
        return this.opportunityCreatedNumberTarget == null ? 0 : this.opportunityCreatedNumberTarget;
    }

    public void setOpportunityCreatedNumberTarget(Integer opportunityCreatedNumberTarget) {
        this.opportunityCreatedNumberTarget = opportunityCreatedNumberTarget;
    }

    public Integer getOpportunityCreatedWonTarget() {
        return this.opportunityCreatedWonTarget == null ? 0 : this.opportunityCreatedWonTarget;
    }

    public void setOpportunityCreatedWonTarget(Integer opportunityCreatedWonTarget) {
        this.opportunityCreatedWonTarget = opportunityCreatedWonTarget;
    }

    public Integer getCallEmittedNumber() {
        return this.callEmittedNumber == null ? 0 : this.callEmittedNumber;
    }

    public void setCallEmittedNumber(Integer callEmittedNumber) {
        this.callEmittedNumber = callEmittedNumber;
    }

    public Integer getMeetingNumber() {
        return this.meetingNumber == null ? 0 : this.meetingNumber;
    }

    public void setMeetingNumber(Integer meetingNumber) {
        this.meetingNumber = meetingNumber;
    }

    public Integer getCallEmittedNumberTarget() {
        return this.callEmittedNumberTarget == null ? 0 : this.callEmittedNumberTarget;
    }

    public void setCallEmittedNumberTarget(Integer callEmittedNumberTarget) {
        this.callEmittedNumberTarget = callEmittedNumberTarget;
    }

    public Integer getMeetingNumberTarget() {
        return this.meetingNumberTarget == null ? 0 : this.meetingNumberTarget;
    }

    public void setMeetingNumberTarget(Integer meetingNumberTarget) {
        this.meetingNumberTarget = meetingNumberTarget;
    }

    public Integer getPeriodTypeSelect() {
        return this.periodTypeSelect == null ? 0 : this.periodTypeSelect;
    }

    public void setPeriodTypeSelect(Integer periodTypeSelect) {
        this.periodTypeSelect = periodTypeSelect;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("opportunityAmountWon", (Object)this.getOpportunityAmountWon()).add("opportunityCreatedNumber", (Object)this.getOpportunityCreatedNumber()).add("opportunityCreatedWon", (Object)this.getOpportunityCreatedWon()).add("opportunityAmountWonTarget", (Object)this.getOpportunityAmountWonTarget()).add("opportunityCreatedNumberTarget", (Object)this.getOpportunityCreatedNumberTarget()).add("opportunityCreatedWonTarget", (Object)this.getOpportunityCreatedWonTarget()).add("callEmittedNumber", (Object)this.getCallEmittedNumber()).add("meetingNumber", (Object)this.getMeetingNumber()).add("callEmittedNumberTarget", (Object)this.getCallEmittedNumberTarget()).omitNullValues().toString();
    }
}

