/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db.repo;

import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.ICalendarUser;
import com.axelor.apps.base.db.repo.ICalendarEventRepository;
import com.axelor.apps.base.db.repo.ICalendarUserRepository;
import com.axelor.apps.base.ical.ICalendarService;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.crm.service.CalendarService;
import com.axelor.apps.crm.service.EventService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.List;

public class EventManagementRepository
extends EventRepository {
    @Inject
    protected ICalendarService calendarService;

    public Event copy(Event entity, boolean deep) {
        int eventType = entity.getTypeSelect();
        switch (eventType) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                entity.setStatusSelect(11);
            }
        }
        return (Event)((Object)super.copy((Model)((Object)entity), deep));
    }

    public Event save(Event entity) {
        String email;
        User creator;
        if (entity.getTypeSelect() == 2) {
            super.save((Model)((Object)entity));
            ((EventService)Beans.get(EventService.class)).manageFollowers(entity);
        }
        if ((creator = entity.getCreatedBy()) == null) {
            creator = AuthUtils.getUser();
        }
        if (entity.getOrganizer() == null && creator != null && creator.getPartner() != null && creator.getPartner().getEmailAddress() != null && !Strings.isNullOrEmpty((String)(email = creator.getPartner().getEmailAddress().getAddress()))) {
            ICalendarUser organizer = (ICalendarUser)((ICalendarUserRepository)Beans.get(ICalendarUserRepository.class)).all().filter("self.email = ?1 AND self.user.id = ?2", new Object[]{email, creator.getId()}).fetchOne();
            if (organizer == null) {
                organizer = new ICalendarUser();
                organizer.setEmail(email);
                organizer.setName(creator.getFullName());
                organizer.setUser(creator);
            }
            entity.setOrganizer(organizer);
        }
        entity.setSubjectTeam(entity.getSubject());
        if (entity.getVisibilitySelect() == ICalendarEventRepository.VISIBILITY_PRIVATE) {
            entity.setSubjectTeam(I18n.get((String)"Available"));
            if (entity.getDisponibilitySelect() == ICalendarEventRepository.DISPONIBILITY_BUSY) {
                entity.setSubjectTeam(I18n.get((String)"Busy"));
            }
        }
        return (Event)((Object)super.save((Model)((Object)entity)));
    }

    public void remove(Event entity) {
        this.remove(entity, true);
    }

    public void remove(Event entity, boolean removeRemote) {
        try {
            if (entity.getCalendar() == null && Strings.isNullOrEmpty((String)entity.getUid())) {
                super.remove((Model)((Object)entity));
                return;
            }
            User user = AuthUtils.getUser();
            List<Long> calendarIdlist = ((CalendarService)((Object)Beans.get(CalendarService.class))).showSharedCalendars(user);
            if (calendarIdlist.isEmpty() || !calendarIdlist.contains(entity.getCalendar().getId())) {
                throw new AxelorException((Model)((Object)entity), 4, I18n.get((String)"You don't have the rights to delete this event"));
            }
            this.calendarService.removeEventFromIcal((ICalendarEvent)entity);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        entity.setArchived(true);
    }
}

