/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service;

import com.axelor.apps.base.db.CalendarManagement;
import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.repo.ICalendarRepository;
import com.axelor.apps.base.ical.ICalendarService;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.auth.db.User;
import com.axelor.inject.Beans;
import com.axelor.team.db.Team;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CalendarService
extends ICalendarService {
    @Inject
    private ICalendarRepository icalRepo;

    public List<Long> showSharedCalendars(User user) {
        Team team = user.getActiveTeam();
        Set<User> followedUsers = user.getFollowersCalUserSet();
        ArrayList<Long> calendarIdlist = new ArrayList<Long>();
        for (User userIt : followedUsers) {
            for (CalendarManagement calendarManagement : userIt.getCalendarManagementList()) {
                if (!user.equals((Object)calendarManagement.getUser()) && (team == null || !team.equals((Object)calendarManagement.getTeam()))) continue;
                List icalList = this.icalRepo.all().filter("self.user.id = ?1", new Object[]{userIt.getId()}).fetch();
                calendarIdlist.addAll(Lists.transform((List)icalList, it -> it.getId()));
            }
        }
        List icalList = this.icalRepo.all().filter("self.user.id = ?1", new Object[]{user.getId()}).fetch();
        calendarIdlist.addAll(Lists.transform((List)icalList, it -> it.getId()));
        return calendarIdlist;
    }

    public List<ICalendarEvent> getICalendarEvents(ICalendar calendar) {
        if (calendar.getSynchronizationSelect().contentEquals("Event")) {
            LocalDateTime lastSynchro = calendar.getLastSynchronizationDateT();
            if (lastSynchro != null) {
                return new ArrayList<ICalendarEvent>(((EventRepository)((Object)Beans.get(EventRepository.class))).all().filter("COALESCE(self.archived, false) = false AND self.calendar = :calendar AND COALESCE(self.updatedOn, self.createdOn) > :lastSynchro").bind("calendar", (Object)calendar).bind("lastSynchro", (Object)lastSynchro).fetch());
            }
            return new ArrayList<ICalendarEvent>(((EventRepository)((Object)Beans.get(EventRepository.class))).all().filter("COALESCE(self.archived, false) = false AND self.calendar = :calendar").bind("calendar", (Object)calendar).fetch());
        }
        return super.getICalendarEvents(calendar);
    }
}

