/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.CountryRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.wizard.ConvertWizardService;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.crm.service.LeadService;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Optional;

public class ConvertLeadWizardService {
    @Inject
    private LeadService leadService;
    @Inject
    private ConvertWizardService convertWizardService;
    @Inject
    private AddressService addressService;
    @Inject
    private PartnerService partnerService;
    @Inject
    private CountryRepository countryRepo;
    @Inject
    private AppBaseService appBaseService;

    public Partner createPartner(Map<String, Object> context, Address primaryAddress) throws AxelorException {
        Mapper mapper = Mapper.of(Partner.class);
        Partner partner = (Partner)Mapper.toBean(Partner.class, null);
        partner = (Partner)this.convertWizardService.createObject(context, (Object)partner, mapper);
        this.setEmailAddress(partner);
        if (this.appBaseService.getAppBase().getGeneratePartnerSequence().booleanValue()) {
            partner.setPartnerSeq(this.leadService.getSequence());
        }
        this.partnerService.setPartnerFullName(partner);
        this.setAddress(partner, primaryAddress);
        Company activeCompany = Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null);
        if (activeCompany != null) {
            partner.addCompanySetItem(activeCompany);
            if (partner.getCurrency() == null) {
                partner.setCurrency(activeCompany.getCurrency());
            }
        }
        return partner;
    }

    public void setEmailAddress(Partner partner) {
        EmailAddress emailAddress = partner.getEmailAddress();
        if (emailAddress != null) {
            partner.setEmailAddress(this.createEmailAddress(emailAddress.getAddress(), null, partner));
        }
    }

    public void setAddress(Partner partner, Address primaryAddress) {
        if (primaryAddress != null) {
            primaryAddress.setFullName(this.addressService.computeFullName(primaryAddress));
            if (!partner.getIsContact().booleanValue()) {
                this.partnerService.addPartnerAddress(partner, primaryAddress, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            partner.setMainAddress(primaryAddress);
        }
    }

    public Address createPrimaryAddress(Map<String, Object> context) {
        Country addressL7Country;
        String addressL6;
        Map leadContext = (Map)context.get("_lead");
        Lead lead = (Lead)((Object)((LeadRepository)((Object)Beans.get(LeadRepository.class))).find(((Integer)leadContext.get("id")).longValue()));
        String addressL4 = lead.getPrimaryAddress();
        if (addressL4 == null) {
            return null;
        }
        String addressL5 = lead.getPrimaryState() != null ? lead.getPrimaryState().getName() : null;
        Address address = this.addressService.getAddress(null, null, addressL4, addressL5, addressL6 = lead.getPrimaryPostalCode() + " " + (lead.getPrimaryCity() != null ? lead.getPrimaryCity().getName() : ""), addressL7Country = lead.getPrimaryCountry());
        if (address == null) {
            address = this.addressService.createAddress(null, null, addressL4, addressL5, addressL6, addressL7Country);
        }
        return address;
    }

    public EmailAddress createEmailAddress(String address, Lead lead, Partner partner) {
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setAddress(address);
        emailAddress.setLead(lead);
        emailAddress.setPartner(partner);
        return emailAddress;
    }
}

