/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.ICalendarUser;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.ical.ICalendarService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.RecurrenceConfiguration;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.crm.service.EventAttendeeService;
import com.axelor.apps.crm.service.EventService;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.repo.EmailAddressRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailAddress;
import com.axelor.mail.db.repo.MailAddressRepository;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.exception.TooManyIterationsException;

public class EventServiceImpl
implements EventService {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter MONTH_FORMAT = DateTimeFormatter.ofPattern("dd/MM");
    private PartnerService partnerService;
    private EventRepository eventRepo;
    @Inject
    private EmailAddressRepository emailAddressRepo;
    @Inject
    private PartnerRepository partnerRepo;
    @Inject
    private LeadRepository leadRepo;
    private static final int ITERATION_LIMIT = 1000;

    @Inject
    public EventServiceImpl(EventAttendeeService eventAttendeeService, PartnerService partnerService, EventRepository eventRepository, MailFollowerRepository mailFollowerRepo, ICalendarService iCalendarService, MessageService messageService, TemplateMessageService templateMessageService) {
        this.partnerService = partnerService;
        this.eventRepo = eventRepository;
    }

    @Override
    @Transactional
    public void saveEvent(Event event) {
        this.eventRepo.save((Model)((Object)event));
    }

    @Override
    public Event createEvent(LocalDateTime fromDateTime, LocalDateTime toDateTime, User user, String description, int type, String subject) {
        Event event = new Event();
        event.setSubject(subject);
        event.setStartDateTime(fromDateTime);
        event.setEndDateTime(toDateTime);
        event.setUser(user);
        event.setTypeSelect(type);
        if (!Strings.isNullOrEmpty((String)description)) {
            event.setDescription(description);
        }
        if (fromDateTime != null && toDateTime != null) {
            long duration = Duration.between(fromDateTime, toDateTime).getSeconds();
            event.setDuration(duration);
        }
        return event;
    }

    @Override
    public String getInvoicingAddressFullName(Partner partner) {
        Address address = this.partnerService.getInvoicingAddress(partner);
        if (address != null) {
            return address.getFullName();
        }
        return null;
    }

    @Override
    @Transactional
    public void manageFollowers(Event event) {
        MailFollowerRepository mailFollowerRepo = (MailFollowerRepository)Beans.get(MailFollowerRepository.class);
        List followers = mailFollowerRepo.findAll((Model)((Object)event));
        List attendeesSet = event.getAttendees();
        if (followers != null) {
            followers.forEach(x -> mailFollowerRepo.remove((Model)x));
        }
        mailFollowerRepo.follow((Model)((Object)event), event.getUser());
        if (attendeesSet != null) {
            for (ICalendarUser user : attendeesSet) {
                if (user.getUser() != null) {
                    mailFollowerRepo.follow((Model)((Object)event), user.getUser());
                    continue;
                }
                MailAddress mailAddress = ((MailAddressRepository)Beans.get(MailAddressRepository.class)).findOrCreate(user.getEmail(), user.getName());
                mailFollowerRepo.follow((Model)((Object)event), mailAddress);
            }
        }
    }

    @Override
    @Transactional
    public void addRecurrentEventsByDays(Event event, int periodicity, int endType, int repetitionsNumber, LocalDate endDate) {
        Event lastEvent = event;
        if (endType == 1) {
            for (int repeated = 0; repeated != repetitionsNumber; ++repeated) {
                Event copy = (Event)((Object)this.eventRepo.copy((Model)((Object)lastEvent), false));
                copy.setParentEvent(event);
                copy.setStartDateTime(copy.getStartDateTime().plusDays(periodicity));
                copy.setEndDateTime(copy.getEndDateTime().plusDays(periodicity));
                lastEvent = (Event)((Object)this.eventRepo.save((Model)((Object)copy)));
            }
        } else {
            while (lastEvent.getStartDateTime().plusDays(periodicity).isBefore(endDate.atStartOfDay().plusDays(1L))) {
                Event copy = (Event)((Object)this.eventRepo.copy((Model)((Object)lastEvent), false));
                copy.setParentEvent(event);
                copy.setStartDateTime(copy.getStartDateTime().plusDays(periodicity));
                copy.setEndDateTime(copy.getEndDateTime().plusDays(periodicity));
                lastEvent = (Event)((Object)this.eventRepo.save((Model)((Object)copy)));
            }
        }
    }

    @Override
    @Transactional
    public void addRecurrentEventsByWeeks(Event event, int periodicity, int endType, int repetitionsNumber, LocalDate endDate, Map<Integer, Boolean> daysCheckedMap) {
        List dayOfWeekList = daysCheckedMap.keySet().stream().sorted().map(DayOfWeek::of).collect(Collectors.toList());
        Duration duration = Duration.between(event.getStartDateTime(), event.getEndDateTime());
        Event lastEvent = event;
        BiFunction<Integer, LocalDateTime, Boolean> breakCondition = endType == 1 ? (iteration, dateTime) -> iteration >= repetitionsNumber : (iteration, dateTime) -> dateTime.toLocalDate().isAfter(endDate);
        boolean loop = true;
        int iteration2 = 0;
        while (loop) {
            if (iteration2 > 1000) {
                throw new TooManyIterationsException((Number)iteration2);
            }
            LocalDateTime nextStartDateTime = lastEvent.getStartDateTime().plusWeeks((long)periodicity - 1L);
            for (DayOfWeek dayOfWeek : dayOfWeekList) {
                nextStartDateTime = nextStartDateTime.with(TemporalAdjusters.next(dayOfWeek));
                if (breakCondition.apply(iteration2, nextStartDateTime).booleanValue()) {
                    loop = false;
                    break;
                }
                Event copy = (Event)((Object)this.eventRepo.copy((Model)((Object)lastEvent), false));
                copy.setParentEvent(event);
                copy.setStartDateTime(nextStartDateTime);
                copy.setEndDateTime(nextStartDateTime.plus(duration));
                lastEvent = (Event)((Object)this.eventRepo.save((Model)((Object)copy)));
            }
            ++iteration2;
        }
    }

    @Override
    @Transactional
    public void addRecurrentEventsByMonths(Event event, int periodicity, int endType, int repetitionsNumber, LocalDate endDate, int monthRepeatType) {
        int weekNo = 1 + (event.getStartDateTime().getDayOfMonth() - 1) / 7;
        Duration duration = Duration.between(event.getStartDateTime(), event.getEndDateTime());
        Event lastEvent = event;
        BiFunction<Integer, LocalDateTime, Boolean> breakConditionFunc = endType == 1 ? (iteration, dateTime) -> iteration >= repetitionsNumber : (iteration, dateTime) -> dateTime.toLocalDate().isAfter(endDate);
        Function<LocalDateTime, LocalDateTime> nextStartDateTimeFunc = monthRepeatType == 1 ? dateTime -> dateTime.withDayOfMonth(1).plusMonths(periodicity).withDayOfMonth(event.getStartDateTime().getDayOfMonth()) : dateTime -> {
            LocalDateTime baseNextDateTime = dateTime.withDayOfMonth(1).plusMonths(periodicity);
            if (!(dateTime = baseNextDateTime.with(TemporalAdjusters.dayOfWeekInMonth(weekNo, event.getStartDateTime().getDayOfWeek()))).getMonth().equals(baseNextDateTime.getMonth()) && weekNo > 1) {
                dateTime = baseNextDateTime.with(TemporalAdjusters.dayOfWeekInMonth(weekNo - 1, event.getStartDateTime().getDayOfWeek()));
            }
            return dateTime;
        };
        int iteration2 = 0;
        while (true) {
            if (iteration2 > 1000) {
                throw new TooManyIterationsException((Number)iteration2);
            }
            LocalDateTime nextStartDateTime = nextStartDateTimeFunc.apply(lastEvent.getStartDateTime());
            if (breakConditionFunc.apply(iteration2, nextStartDateTime).booleanValue()) break;
            Event copy = (Event)((Object)this.eventRepo.copy((Model)((Object)lastEvent), false));
            copy.setParentEvent(event);
            copy.setStartDateTime(nextStartDateTime);
            copy.setEndDateTime(nextStartDateTime.plus(duration));
            lastEvent = (Event)((Object)this.eventRepo.save((Model)((Object)copy)));
            ++iteration2;
        }
    }

    @Override
    @Transactional
    public void addRecurrentEventsByYears(Event event, int periodicity, int endType, int repetitionsNumber, LocalDate endDate) {
        Event lastEvent = event;
        if (endType == 1) {
            for (int repeated = 0; repeated != repetitionsNumber; ++repeated) {
                Event copy = (Event)((Object)this.eventRepo.copy((Model)((Object)lastEvent), false));
                copy.setParentEvent(event);
                copy.setStartDateTime(copy.getStartDateTime().plusYears(periodicity));
                copy.setEndDateTime(copy.getEndDateTime().plusYears(periodicity));
                lastEvent = (Event)((Object)this.eventRepo.save((Model)((Object)copy)));
            }
        } else {
            while (lastEvent.getStartDateTime().plusYears(periodicity).isBefore(endDate.atStartOfDay().plusYears(1L))) {
                Event copy = (Event)((Object)this.eventRepo.copy((Model)((Object)lastEvent), false));
                copy.setParentEvent(event);
                copy.setStartDateTime(copy.getStartDateTime().plusYears(periodicity));
                copy.setEndDateTime(copy.getEndDateTime().plusYears(periodicity));
                lastEvent = (Event)((Object)this.eventRepo.save((Model)((Object)copy)));
            }
        }
    }

    @Override
    @Transactional
    public void applyChangesToAll(Event event) {
        Event child = (Event)((Object)this.eventRepo.all().filter("self.parentEvent.id = ?1", new Object[]{event.getId()}).fetchOne());
        Event parent = event.getParentEvent();
        Event copyEvent = (Event)((Object)this.eventRepo.copy((Model)((Object)event), false));
        while (child != null) {
            child.setSubject(event.getSubject());
            child.setCalendar(event.getCalendar());
            child.setStartDateTime(child.getStartDateTime().withHour(event.getStartDateTime().getHour()));
            child.setStartDateTime(child.getStartDateTime().withMinute(event.getStartDateTime().getMinute()));
            child.setEndDateTime(child.getEndDateTime().withHour(event.getEndDateTime().getHour()));
            child.setEndDateTime(child.getEndDateTime().withMinute(event.getEndDateTime().getMinute()));
            child.setDuration(event.getDuration());
            child.setUser(event.getUser());
            child.setTeam(event.getTeam());
            child.setDisponibilitySelect(event.getDisponibilitySelect());
            child.setVisibilitySelect(event.getVisibilitySelect());
            child.setDescription(event.getDescription());
            child.setPartner(event.getPartner());
            child.setContactPartner(event.getContactPartner());
            child.setLead(event.getLead());
            child.setTypeSelect(event.getTypeSelect());
            child.setLocation(event.getLocation());
            this.eventRepo.save((Model)((Object)child));
            copyEvent = child;
            child = (Event)((Object)this.eventRepo.all().filter("self.parentEvent.id = ?1", new Object[]{copyEvent.getId()}).fetchOne());
        }
        while (parent != null) {
            Event nextParent = parent.getParentEvent();
            parent.setSubject(event.getSubject());
            parent.setCalendar(event.getCalendar());
            parent.setStartDateTime(parent.getStartDateTime().withHour(event.getStartDateTime().getHour()));
            parent.setStartDateTime(parent.getStartDateTime().withMinute(event.getStartDateTime().getMinute()));
            parent.setEndDateTime(parent.getEndDateTime().withHour(event.getEndDateTime().getHour()));
            parent.setEndDateTime(parent.getEndDateTime().withMinute(event.getEndDateTime().getMinute()));
            parent.setDuration(event.getDuration());
            parent.setUser(event.getUser());
            parent.setTeam(event.getTeam());
            parent.setDisponibilitySelect(event.getDisponibilitySelect());
            parent.setVisibilitySelect(event.getVisibilitySelect());
            parent.setDescription(event.getDescription());
            parent.setPartner(event.getPartner());
            parent.setContactPartner(event.getContactPartner());
            parent.setLead(event.getLead());
            parent.setTypeSelect(event.getTypeSelect());
            parent.setLocation(event.getLocation());
            this.eventRepo.save((Model)((Object)parent));
            parent = nextParent;
        }
    }

    @Override
    public String computeRecurrenceName(RecurrenceConfiguration recurrConf) {
        String recurrName = "";
        switch (recurrConf.getRecurrenceType()) {
            case 1: {
                recurrName = recurrConf.getPeriodicity() == 1 ? recurrName + I18n.get((String)"Every day") : recurrName + String.format(I18n.get((String)"Every %d days"), recurrConf.getPeriodicity());
                if (recurrConf.getEndType() == 1) {
                    recurrName = recurrName + String.format(", " + I18n.get((String)"%d times"), recurrConf.getRepetitionsNumber());
                    break;
                }
                if (recurrConf.getEndDate() == null) break;
                recurrName = recurrName + ", " + I18n.get((String)"until the") + " " + recurrConf.getEndDate().format(DATE_FORMAT);
                break;
            }
            case 2: {
                recurrName = recurrConf.getPeriodicity() == 1 ? recurrName + I18n.get((String)"Every week") + " " : recurrName + String.format(I18n.get((String)"Every %d weeks") + " ", recurrConf.getPeriodicity());
                if (recurrConf.getMonday().booleanValue() && recurrConf.getTuesday().booleanValue() && recurrConf.getWednesday().booleanValue() && recurrConf.getThursday().booleanValue() && recurrConf.getFriday().booleanValue() && !recurrConf.getSaturday().booleanValue() && !recurrConf.getSunday().booleanValue()) {
                    recurrName = recurrName + I18n.get((String)"every week's day");
                } else if (recurrConf.getMonday().booleanValue() && recurrConf.getTuesday().booleanValue() && recurrConf.getWednesday().booleanValue() && recurrConf.getThursday().booleanValue() && recurrConf.getFriday().booleanValue() && recurrConf.getSaturday().booleanValue() && recurrConf.getSunday().booleanValue()) {
                    recurrName = recurrName + I18n.get((String)"everyday");
                } else {
                    recurrName = recurrName + I18n.get((String)"on") + " ";
                    if (recurrConf.getMonday().booleanValue()) {
                        recurrName = recurrName + I18n.get((String)"mon,");
                    }
                    if (recurrConf.getTuesday().booleanValue()) {
                        recurrName = recurrName + I18n.get((String)"tues,");
                    }
                    if (recurrConf.getWednesday().booleanValue()) {
                        recurrName = recurrName + I18n.get((String)"wed,");
                    }
                    if (recurrConf.getThursday().booleanValue()) {
                        recurrName = recurrName + I18n.get((String)"thur,");
                    }
                    if (recurrConf.getFriday().booleanValue()) {
                        recurrName = recurrName + I18n.get((String)"fri,");
                    }
                    if (recurrConf.getSaturday().booleanValue()) {
                        recurrName = recurrName + I18n.get((String)"sat,");
                    }
                    if (recurrConf.getSunday().booleanValue()) {
                        recurrName = recurrName + I18n.get((String)"sun,");
                    }
                }
                if (recurrConf.getEndType() == 1) {
                    recurrName = recurrName + String.format(" " + I18n.get((String)"%d times"), recurrConf.getRepetitionsNumber());
                    break;
                }
                if (recurrConf.getEndDate() == null) break;
                recurrName = recurrName + " " + I18n.get((String)"until the") + " " + recurrConf.getEndDate().format(DATE_FORMAT);
                break;
            }
            case 3: {
                recurrName = recurrConf.getPeriodicity() == 1 ? recurrName + I18n.get((String)"Every month the") + " " + recurrConf.getStartDate().getDayOfMonth() : recurrName + String.format(I18n.get((String)"Every %d months the %d"), recurrConf.getPeriodicity(), recurrConf.getStartDate().getDayOfMonth());
                if (recurrConf.getEndType() == 1) {
                    recurrName = recurrName + String.format(", " + I18n.get((String)"%d times"), recurrConf.getRepetitionsNumber());
                    break;
                }
                if (recurrConf.getEndDate() == null) break;
                recurrName = recurrName + ", " + I18n.get((String)"until the") + " " + recurrConf.getEndDate().format(DATE_FORMAT);
                break;
            }
            case 4: {
                recurrName = recurrConf.getPeriodicity() == 1 ? recurrName + I18n.get((String)"Every year the") + recurrConf.getStartDate().format(MONTH_FORMAT) : recurrName + String.format(I18n.get((String)"Every %d years the %s"), recurrConf.getPeriodicity(), recurrConf.getStartDate().format(MONTH_FORMAT));
                if (recurrConf.getEndType() == 1) {
                    recurrName = recurrName + String.format(", " + I18n.get((String)"%d times"), recurrConf.getRepetitionsNumber());
                    break;
                }
                if (recurrConf.getEndDate() == null) break;
                recurrName = recurrName + ", " + I18n.get((String)"until the") + " " + recurrConf.getEndDate().format(DATE_FORMAT);
                break;
            }
        }
        return recurrName;
    }

    @Override
    public void generateRecurrentEvents(Event event, RecurrenceConfiguration conf) throws AxelorException {
        if (conf.getRecurrenceType() == null) {
            throw new AxelorException(4, "You must choose a recurrence type");
        }
        int recurrenceType = new Integer(conf.getRecurrenceType().toString());
        if (conf.getPeriodicity() == null) {
            throw new AxelorException(4, I18n.get((String)"Periodicity must be greater than 0"));
        }
        int periodicity = new Integer(conf.getPeriodicity().toString());
        if (periodicity < 1) {
            throw new AxelorException(4, I18n.get((String)"Periodicity must be greater than 0"));
        }
        boolean monday = conf.getMonday();
        boolean tuesday = conf.getTuesday();
        boolean wednesday = conf.getWednesday();
        boolean thursday = conf.getThursday();
        boolean friday = conf.getFriday();
        boolean saturday = conf.getSaturday();
        boolean sunday = conf.getSunday();
        HashMap<Integer, Boolean> daysMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> daysCheckedMap = new HashMap<Integer, Boolean>();
        if (recurrenceType == 2) {
            daysMap.put(DayOfWeek.MONDAY.getValue(), monday);
            daysMap.put(DayOfWeek.TUESDAY.getValue(), tuesday);
            daysMap.put(DayOfWeek.WEDNESDAY.getValue(), wednesday);
            daysMap.put(DayOfWeek.THURSDAY.getValue(), thursday);
            daysMap.put(DayOfWeek.FRIDAY.getValue(), friday);
            daysMap.put(DayOfWeek.SATURDAY.getValue(), saturday);
            daysMap.put(DayOfWeek.SUNDAY.getValue(), sunday);
            for (Integer day : daysMap.keySet()) {
                if (!((Boolean)daysMap.get(day)).booleanValue()) continue;
                daysCheckedMap.put(day, (Boolean)daysMap.get(day));
            }
            if (daysCheckedMap.isEmpty()) {
                throw new AxelorException(4, I18n.get((String)"You must choose at least one day in the week"));
            }
        }
        int monthRepeatType = new Integer(conf.getMonthRepeatType().toString());
        int endType = new Integer(conf.getEndType().toString());
        int repetitionsNumber = 0;
        if (endType == 1) {
            if (conf.getRepetitionsNumber() == null) {
                throw new AxelorException(4, I18n.get((String)"The number of repetitions must be greater than 0"));
            }
            repetitionsNumber = new Integer(conf.getRepetitionsNumber().toString());
            if (repetitionsNumber < 1) {
                throw new AxelorException(4, I18n.get((String)"The number of repetitions must be greater than 0"));
            }
        }
        LocalDate endDate = event.getEndDateTime().toLocalDate();
        if (endType == 2) {
            if (conf.getEndDate() == null) {
                throw new AxelorException(4, I18n.get((String)"The end date must be after the start date"));
            }
            endDate = LocalDate.parse(conf.getEndDate().toString(), DateTimeFormatter.ISO_DATE);
            if (endDate.isBefore(event.getStartDateTime().toLocalDate()) || endDate.isEqual(event.getStartDateTime().toLocalDate())) {
                throw new AxelorException(4, I18n.get((String)"The end date must be after the start date"));
            }
        }
        switch (recurrenceType) {
            case 1: {
                this.addRecurrentEventsByDays(event, periodicity, endType, repetitionsNumber, endDate);
                break;
            }
            case 2: {
                this.addRecurrentEventsByWeeks(event, periodicity, endType, repetitionsNumber, endDate, daysCheckedMap);
                break;
            }
            case 3: {
                this.addRecurrentEventsByMonths(event, periodicity, endType, repetitionsNumber, endDate, monthRepeatType);
                break;
            }
            case 4: {
                this.addRecurrentEventsByYears(event, periodicity, endType, repetitionsNumber, endDate);
                break;
            }
        }
    }

    @Override
    public EmailAddress getEmailAddress(Event event) {
        Lead lead;
        EmailAddress emailAddress = null;
        if (event.getPartner() != null && event.getPartner().getPartnerTypeSelect() == 2) {
            Partner partner = (Partner)this.partnerRepo.find(event.getPartner().getId());
            if (partner.getEmailAddress() != null) {
                emailAddress = (EmailAddress)((Object)this.emailAddressRepo.find(partner.getEmailAddress().getId()));
            }
        } else if (event.getContactPartner() != null) {
            Partner contactPartner = (Partner)this.partnerRepo.find(event.getContactPartner().getId());
            if (contactPartner.getEmailAddress() != null) {
                emailAddress = (EmailAddress)((Object)this.emailAddressRepo.find(contactPartner.getEmailAddress().getId()));
            }
        } else if (event.getPartner() == null && event.getContactPartner() == null && event.getLead() != null && (lead = (Lead)((Object)this.leadRepo.find(event.getLead().getId()))).getEmailAddress() != null) {
            emailAddress = (EmailAddress)((Object)this.emailAddressRepo.find(lead.getEmailAddress().getId()));
        }
        return emailAddress;
    }
}

