/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.apps.crm.service.OpportunityService;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class OpportunityServiceImpl
implements OpportunityService {
    @Inject
    protected OpportunityRepository opportunityRepo;
    @Inject
    protected AddressService addressService;

    @Override
    @Transactional
    public void saveOpportunity(Opportunity opportunity) {
        this.opportunityRepo.save((Model)((Object)opportunity));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Partner createClientFromLead(Opportunity opportunity) throws AxelorException {
        Lead lead = opportunity.getLead();
        if (lead == null) {
            throw new AxelorException((Model)((Object)opportunity), 4, I18n.get((String)"Please select a lead"));
        }
        String name = lead.getFullName();
        Address address = null;
        if (lead.getPrimaryAddress() != null) {
            String addressL6 = lead.getPrimaryPostalCode() == null ? "" : lead.getPrimaryPostalCode() + " ";
            addressL6 = addressL6 + (lead.getPrimaryCity() == null ? "" : lead.getPrimaryCity().getName());
            address = this.addressService.createAddress(null, null, lead.getPrimaryAddress(), null, addressL6, lead.getPrimaryCountry());
            address.setFullName(this.addressService.computeFullName(address));
        }
        EmailAddress email = null;
        if (lead.getEmailAddress() != null) {
            email = new EmailAddress(lead.getEmailAddress().getAddress());
        }
        Partner partner = ((PartnerService)Beans.get(PartnerService.class)).createPartner(name, null, lead.getFixedPhone(), lead.getMobilePhone(), email, opportunity.getCurrency(), address, address, true);
        opportunity.setPartner(partner);
        this.opportunityRepo.save((Model)((Object)opportunity));
        return partner;
    }

    @Override
    public void setSequence(Opportunity opportunity) throws AxelorException {
        Company company = opportunity.getCompany();
        String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("opportunity", company);
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"There's no configured sequence for opportunities for the company %s"), new Object[]{company != null ? company.getName() : null});
        }
        opportunity.setOpportunitySeq(seq);
    }
}

