/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service.batch;

import com.axelor.apps.base.db.ICalendarUser;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.EventReminder;
import com.axelor.apps.crm.db.repo.EventReminderRepository;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.crm.message.MessageServiceCrmImpl;
import com.axelor.apps.crm.service.batch.BatchStrategy;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.EmailAddressRepository;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.apps.message.service.MessageService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDateTime;
import java.util.List;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchEventReminder
extends BatchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean stop = false;
    @Inject
    private EventRepository eventRepo;
    @Inject
    private EmailAddressRepository emailAddressRepo;

    @Inject
    public BatchEventReminder(MessageServiceCrmImpl messageServiceCrmImpl, MailAccountService mailAccountService) {
        super(messageServiceCrmImpl, mailAccountService);
    }

    protected void process() {
        this.markEventReminderProcess();
        this.generateMessageProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markEventReminderProcess() {
        if (!this.stop) {
            int i = 0;
            List eventReminderList = this.eventReminderRepo.all().fetch();
            for (EventReminder eventReminder : eventReminderList) {
                try {
                    boolean eventIsNotFinished;
                    eventReminder = (EventReminder)((Object)this.eventReminderRepo.find(eventReminder.getId()));
                    Integer eventStatusSelect = eventReminder.getEvent().getStatusSelect();
                    boolean bl = eventIsNotFinished = eventStatusSelect == 1 || eventStatusSelect == 11 || eventStatusSelect == 12 || eventStatusSelect == 13;
                    if (eventReminder.getIsReminded().booleanValue() || !this.isExpired(eventReminder) || !eventIsNotFinished) continue;
                    this.updateEventReminder(eventReminder);
                    ++i;
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Event reminder %s"), ((EventReminder)((Object)this.eventReminderRepo.find(eventReminder.getId()))).getEvent().getSubject()), e), (String)"crm", (long)this.batch.getId());
                    this.incrementAnomaly();
                    LOG.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le rappel de l'\u00e9v\u00e8nement {}", (Object)((EventReminder)((Object)this.eventReminderRepo.find(eventReminder.getId()))).getEvent().getSubject());
                }
                finally {
                    if (i % 1 == 0) {
                        JPA.clear();
                    }
                }
            }
        }
    }

    private boolean isExpired(EventReminder eventReminder) {
        LocalDateTime startDateTime = eventReminder.getEvent().getStartDateTime();
        if (EventReminderRepository.MODE_AT_DATE.equals(eventReminder.getModeSelect())) {
            return eventReminder.getSendingDateT().isBefore(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
        }
        int durationTypeSelect = eventReminder.getDurationTypeSelect();
        switch (durationTypeSelect) {
            case 1: {
                if (!startDateTime.minusMinutes(eventReminder.getDuration().intValue()).isBefore(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime())) break;
                return true;
            }
            case 2: {
                if (!startDateTime.minusHours(eventReminder.getDuration().intValue()).isBefore(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime())) break;
                return true;
            }
            case 3: {
                if (!startDateTime.minusDays(eventReminder.getDuration().intValue()).isBefore(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime())) break;
                return true;
            }
            case 4: {
                if (!startDateTime.minusWeeks(eventReminder.getDuration().intValue()).isBefore(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime())) break;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateMessageProcess() {
        MessageRepository messageRepo = (MessageRepository)((Object)Beans.get(MessageRepository.class));
        if (!this.stop) {
            int i = 0;
            Query q = JPA.em().createQuery(" SELECT er FROM EventReminder as er WHERE er.isReminded = true and ?1 MEMBER OF er.batchSet");
            q.setParameter(1, (Object)this.batch);
            List eventReminderList = q.getResultList();
            for (EventReminder eventReminder : eventReminderList) {
                try {
                    eventReminder = (EventReminder)((Object)this.eventReminderRepo.find(eventReminder.getId()));
                    Message message = this.messageServiceCrmImpl.createMessage(eventReminder.getEvent());
                    if (eventReminder.getUser().getPartner() != null && eventReminder.getUser().getPartner().getEmailAddress() != null) {
                        message.addToEmailAddressSetItem(eventReminder.getUser().getPartner().getEmailAddress());
                    } else if (eventReminder.getUser().getEmail() != null) {
                        message.addToEmailAddressSetItem(this.findOrCreateEmailAddress(eventReminder.getUser().getEmail(), "[" + eventReminder.getUser().getEmail() + "]"));
                    } else {
                        messageRepo.remove((Model)((Object)message));
                        throw new AxelorException(4, I18n.get((String)"User %s does not have an email address configured nor is it linked to a partner with an email address configured."), new Object[]{eventReminder.getUser().getName()});
                    }
                    if (EventReminderRepository.ASSIGN_TO_ALL.equals(eventReminder.getAssignToSelect()) && eventReminder.getEvent().getAttendees() != null) {
                        for (ICalendarUser iCalUser : eventReminder.getEvent().getAttendees()) {
                            if (iCalUser.getUser() != null && iCalUser.getUser().getPartner() != null) {
                                message.addToEmailAddressSetItem(iCalUser.getUser().getPartner().getEmailAddress());
                                continue;
                            }
                            message.addToEmailAddressSetItem(this.findOrCreateEmailAddress(iCalUser.getEmail(), iCalUser.getName()));
                        }
                    }
                    message = ((MessageService)Beans.get(MessageService.class)).sendByEmail(message);
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Event") + " %s", ((Event)((Object)this.eventRepo.find(eventReminder.getEvent().getId()))).getSubject()), e), (String)"crm", (long)this.batch.getId());
                    this.incrementAnomaly();
                    LOG.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour l'\u00e9v\u00e8nement {}", (Object)((Event)((Object)this.eventRepo.find(eventReminder.getEvent().getId()))).getSubject());
                }
                finally {
                    if (i % 1 == 0) {
                        JPA.clear();
                    }
                }
            }
        }
    }

    protected void stop() {
        String comment = I18n.get((String)"Event's reminder's generation's reporting :") + "\n";
        comment = comment + String.format("\t* %s " + I18n.get((String)"Reminder(s) treated") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }

    @Transactional
    protected EmailAddress findOrCreateEmailAddress(String email, String name) {
        EmailAddress emailAddress = (EmailAddress)((Object)this.emailAddressRepo.all().filter("self.name = '" + name + "'").fetchOne());
        if (emailAddress == null) {
            emailAddress = new EmailAddress();
            emailAddress.setAddress(email);
            emailAddress = (EmailAddress)((Object)this.emailAddressRepo.save((Model)((Object)emailAddress)));
        }
        return emailAddress;
    }
}

