/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.web;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.crm.service.ConvertLeadWizardService;
import com.axelor.apps.crm.service.LeadService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.util.Map;

@Singleton
public class ConvertLeadWizardController {
    public void convertLead(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            Map leadContext = (Map)context.get((Object)"_lead");
            Lead lead = (Lead)((Object)((LeadRepository)((Object)Beans.get(LeadRepository.class))).find(((Integer)leadContext.get("id")).longValue()));
            Partner partner = this.createPartnerData(context);
            Partner contactPartner = null;
            if (partner != null) {
                contactPartner = this.createContactData(context, partner);
            }
            try {
                lead = ((LeadService)Beans.get(LeadService.class)).convertLead(lead, partner, contactPartner);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
            }
            if (lead.getPartner() == null) {
                throw new AxelorException(5, I18n.get((String)"Error in lead conversion"));
            }
            this.openPartner(response, lead);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private Partner createPartnerData(Context context) throws AxelorException {
        Integer leadToPartnerSelect = (Integer)context.get((Object)"leadToPartnerSelect");
        ConvertLeadWizardService convertLeadWizardService = (ConvertLeadWizardService)Beans.get(ConvertLeadWizardService.class);
        Partner partner = null;
        if (leadToPartnerSelect == 1) {
            Address primaryAddress = convertLeadWizardService.createPrimaryAddress((Map<String, Object>)context);
            if (primaryAddress != null && (primaryAddress.getAddressL6() == null || primaryAddress.getAddressL7Country() == null)) {
                throw new AxelorException(1, I18n.get((String)"Please complete the partner address."));
            }
            partner = convertLeadWizardService.createPartner((Map)context.get((Object)"partner"), primaryAddress);
        } else if (leadToPartnerSelect == 2) {
            Map selectPartnerContext = (Map)context.get((Object)"selectPartner");
            partner = (Partner)((PartnerRepository)Beans.get(PartnerRepository.class)).find(Long.valueOf(((Integer)selectPartnerContext.get("id")).longValue()));
            if (!partner.getIsCustomer().booleanValue()) {
                partner.setIsProspect(Boolean.valueOf(true));
            }
        }
        return partner;
    }

    private Partner createContactData(Context context, Partner partner) throws AxelorException {
        Partner contactPartner = null;
        Integer leadToContactSelect = (Integer)context.get((Object)"leadToContactSelect");
        ConvertLeadWizardService convertLeadWizardService = (ConvertLeadWizardService)Beans.get(ConvertLeadWizardService.class);
        if (leadToContactSelect == null) {
            return null;
        }
        if (leadToContactSelect == 1 && partner.getPartnerTypeSelect() != 2) {
            Address primaryAddress = convertLeadWizardService.createPrimaryAddress((Map<String, Object>)context);
            if (primaryAddress != null && (primaryAddress.getAddressL6() == null || primaryAddress.getAddressL7Country() == null)) {
                throw new AxelorException(1, I18n.get((String)"Please complete the contact address."));
            }
            contactPartner = convertLeadWizardService.createPartner((Map)context.get((Object)"contactPartner"), primaryAddress);
            contactPartner.setIsContact(Boolean.valueOf(true));
        } else if (leadToContactSelect == 2 && partner.getPartnerTypeSelect() != 2) {
            Map selectContactContext = (Map)context.get((Object)"selectContact");
            contactPartner = (Partner)((PartnerRepository)Beans.get(PartnerRepository.class)).find(Long.valueOf(((Integer)selectContactContext.get("id")).longValue()));
        }
        return contactPartner;
    }

    private void openPartner(ActionResponse response, Lead lead) {
        Partner partner = lead.getPartner();
        String form = "partner-customer-form";
        String grid = "partner-customer-grid";
        if (partner.getIsSupplier().booleanValue() && !partner.getIsCustomer().booleanValue() && !partner.getIsProspect().booleanValue()) {
            form = "partner-supplier-form";
            grid = "partner-supplier-grid";
        }
        response.setFlash(I18n.get((String)"Lead converted"));
        response.setCanClose(true);
        response.setView(ActionView.define((String)I18n.get((String)"Lead converted")).model(Partner.class.getName()).add("form", form).add("grid", grid).param("search-filters", "partner-filters").context("_showRecord", (Object)partner.getId()).map());
    }

    public void setDefaults(ActionRequest request, ActionResponse response) throws AxelorException {
        Lead lead = this.findLead(request);
        response.setAttr("$partner.$primaryAddress", "value", (Object)lead.getPrimaryAddress());
        response.setAttr("$partner.$primaryCity", "value", (Object)lead.getPrimaryCity());
        response.setAttr("$partner.$primaryState", "value", (Object)lead.getPrimaryState());
        response.setAttr("$partner.$primaryPostalCode", "value", (Object)lead.getPrimaryPostalCode());
        response.setAttr("$partner.$primaryCountry", "value", (Object)lead.getPrimaryCountry());
        response.setAttr("$contactAddress", "value", (Object)lead.getPrimaryAddress());
        response.setAttr("$contactCity", "value", (Object)lead.getPrimaryCity());
        response.setAttr("$contactState", "value", (Object)lead.getPrimaryState());
        response.setAttr("$contactPostalCode", "value", (Object)lead.getPrimaryPostalCode());
        response.setAttr("$contactCountry", "value", (Object)lead.getPrimaryCountry());
        response.setAttr("$leadToPartnerSelect", "value", (Object)1);
        response.setAttr("$leadToContactSelect", "value", (Object)1);
    }

    public void setPartnerDefaults(ActionRequest request, ActionResponse response) throws AxelorException {
        Lead lead = this.findLead(request);
        AppBase appBase = ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase();
        response.setAttr("name", "value", (Object)lead.getEnterpriseName());
        response.setAttr("industrySector", "value", (Object)lead.getIndustrySector());
        response.setAttr("titleSelect", "value", (Object)lead.getTitleSelect());
        response.setAttr("emailAddress", "value", (Object)lead.getEmailAddress());
        response.setAttr("fax", "value", (Object)lead.getFax());
        response.setAttr("mobilePhone", "value", (Object)lead.getMobilePhone());
        response.setAttr("fixedPhone", "value", (Object)lead.getFixedPhone());
        response.setAttr("webSite", "value", (Object)lead.getWebSite());
        response.setAttr("source", "value", (Object)lead.getSource());
        response.setAttr("department", "value", (Object)lead.getDepartment());
        response.setAttr("team", "value", (Object)lead.getTeam());
        response.setAttr("user", "value", (Object)lead.getUser());
        response.setAttr("isProspect", "value", (Object)true);
        response.setAttr("partnerTypeSelect", "value", (Object)"1");
        response.setAttr("language", "value", (Object)appBase.getDefaultPartnerLanguage());
        response.setAttr("nbrEmployees", "value", (Object)0);
    }

    public void setIndividualPartner(ActionRequest request, ActionResponse response) throws AxelorException {
        Lead lead = this.findLead(request);
        if (request.getContext().get((Object)"partnerTypeSelect").toString().equals("2")) {
            response.setAttr("firstName", "value", (Object)lead.getFirstName());
            response.setAttr("name", "value", (Object)lead.getName());
        } else {
            response.setAttr("name", "value", (Object)lead.getEnterpriseName());
        }
    }

    public void setContactDefaults(ActionRequest request, ActionResponse response) throws AxelorException {
        Lead lead = this.findLead(request);
        response.setAttr("firstName", "value", (Object)lead.getFirstName());
        response.setAttr("name", "value", (Object)lead.getName());
        response.setAttr("titleSelect", "value", (Object)lead.getTitleSelect());
        response.setAttr("emailAddress", "value", (Object)lead.getEmailAddress());
        response.setAttr("fax", "value", (Object)lead.getFax());
        response.setAttr("mobilePhone", "value", (Object)lead.getMobilePhone());
        response.setAttr("fixedPhone", "value", (Object)lead.getFixedPhone());
        response.setAttr("user", "value", (Object)lead.getUser());
        response.setAttr("team", "value", (Object)lead.getTeam());
        response.setAttr("jobTitleFunction", "value", (Object)lead.getJobTitleFunction());
    }

    public void setConvertLeadIntoOpportunity(ActionRequest request, ActionResponse response) throws AxelorException {
        Lead lead = this.findLead(request);
        AppBase appBase = ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase();
        response.setAttr("lead", "value", (Object)lead);
        response.setAttr("amount", "value", (Object)lead.getEstimatedBudget());
        response.setAttr("customerDescription", "value", (Object)lead.getDescription());
        response.setAttr("source", "value", (Object)lead.getSource());
        response.setAttr("partner", "value", (Object)lead.getPartner());
        response.setAttr("user", "value", (Object)lead.getUser());
        response.setAttr("team", "value", (Object)lead.getTeam());
        response.setAttr("webSite", "value", (Object)lead.getWebSite());
        response.setAttr("source", "value", (Object)lead.getSource());
        response.setAttr("department", "value", (Object)lead.getDepartment());
        response.setAttr("isCustomer", "value", (Object)true);
        response.setAttr("partnerTypeSelect", "value", (Object)"1");
        response.setAttr("language", "value", (Object)appBase.getDefaultPartnerLanguage());
        Company company = null;
        CompanyRepository companyRepo = (CompanyRepository)((Object)Beans.get(CompanyRepository.class));
        if (lead.getUser() != null && lead.getUser().getActiveCompany() != null) {
            company = lead.getUser().getActiveCompany();
        } else if (companyRepo.all().count() == 1L) {
            company = (Company)((Object)companyRepo.all().fetchOne());
        }
        if (company != null) {
            response.setAttr("company", "value", (Object)company);
            response.setAttr("currency", "value", (Object)company.getCurrency());
        }
    }

    protected Lead findLead(ActionRequest request) throws AxelorException {
        Map leadMap;
        Context context = request.getContext();
        Lead lead = null;
        if (context.getParent() != null && context.getParent().get((Object)"_model").equals("com.axelor.apps.base.db.Wizard")) {
            context = context.getParent();
        }
        if ((leadMap = (Map)context.get((Object)"_lead")) != null && leadMap.get("id") != null) {
            lead = (Lead)((Object)((LeadRepository)((Object)Beans.get(LeadRepository.class))).find(Long.parseLong(leadMap.get("id").toString())));
        }
        if (lead == null) {
            throw new AxelorException(3, I18n.get((String)"Parent lead is missing."));
        }
        return lead;
    }
}

