/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.web;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.EventReminder;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.RecurrenceConfiguration;
import com.axelor.apps.crm.db.repo.EventReminderRepository;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.crm.db.repo.RecurrenceConfigurationRepository;
import com.axelor.apps.crm.service.CalendarService;
import com.axelor.apps.crm.service.EventService;
import com.axelor.apps.crm.service.LeadService;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.apps.tool.date.DurationTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.base.service.ical.ICalendarEventService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void computeFromStartDateTime(ActionRequest request, ActionResponse response) {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        LOG.debug("event : {}", (Object)event);
        if (event.getStartDateTime() != null) {
            if (event.getDuration() != null && event.getDuration() != 0L) {
                response.setValue("endDateTime", (Object)DateTool.plusSeconds((LocalDateTime)event.getStartDateTime(), (long)event.getDuration()));
            } else if (event.getEndDateTime() != null && event.getEndDateTime().isAfter(event.getStartDateTime())) {
                Duration duration = DurationTool.computeDuration((LocalDateTime)event.getStartDateTime(), (LocalDateTime)event.getEndDateTime());
                response.setValue("duration", (Object)DurationTool.getSecondsDuration((Duration)duration));
            } else {
                Duration duration = Duration.ofHours(1L);
                response.setValue("duration", (Object)DurationTool.getSecondsDuration((Duration)duration));
                response.setValue("endDateTime", (Object)event.getStartDateTime().plus(duration));
            }
        }
    }

    public void computeFromEndDateTime(ActionRequest request, ActionResponse response) {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        LOG.debug("event : {}", (Object)event);
        if (event.getEndDateTime() != null) {
            if (event.getStartDateTime() != null && event.getStartDateTime().isBefore(event.getEndDateTime())) {
                Duration duration = DurationTool.computeDuration((LocalDateTime)event.getStartDateTime(), (LocalDateTime)event.getEndDateTime());
                response.setValue("duration", (Object)DurationTool.getSecondsDuration((Duration)duration));
            } else if (event.getDuration() != null) {
                response.setValue("startDateTime", (Object)DateTool.minusSeconds((LocalDateTime)event.getEndDateTime(), (long)event.getDuration()));
            }
        }
    }

    public void computeFromDuration(ActionRequest request, ActionResponse response) {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        LOG.debug("event : {}", (Object)event);
        if (event.getDuration() != null) {
            if (event.getStartDateTime() != null) {
                response.setValue("endDateTime", (Object)DateTool.plusSeconds((LocalDateTime)event.getStartDateTime(), (long)event.getDuration()));
            } else if (event.getEndDateTime() != null) {
                response.setValue("startDateTime", (Object)DateTool.minusSeconds((LocalDateTime)event.getEndDateTime(), (long)event.getDuration()));
            }
        }
    }

    public void computeFromCalendar(ActionRequest request, ActionResponse response) {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        LOG.debug("event : {}", (Object)event);
        if (event.getStartDateTime() != null && event.getEndDateTime() != null) {
            Duration duration = DurationTool.computeDuration((LocalDateTime)event.getStartDateTime(), (LocalDateTime)event.getEndDateTime());
            response.setValue("duration", (Object)DurationTool.getSecondsDuration((Duration)duration));
        }
    }

    public void saveEventTaskStatusSelect(ActionRequest request, ActionResponse response) throws AxelorException {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        Event persistEvent = (Event)((Object)((EventRepository)((Object)Beans.get(EventRepository.class))).find(event.getId()));
        persistEvent.setStatusSelect(event.getStatusSelect());
        ((EventService)Beans.get(EventService.class)).saveEvent(persistEvent);
    }

    public void saveEventTicketStatusSelect(ActionRequest request, ActionResponse response) throws AxelorException {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        Event persistEvent = (Event)((Object)((EventRepository)((Object)Beans.get(EventRepository.class))).find(event.getId()));
        persistEvent.setStatusSelect(event.getStatusSelect());
        ((EventService)Beans.get(EventService.class)).saveEvent(persistEvent);
    }

    public void viewMap(ActionRequest request, ActionResponse response) {
        try {
            Event event = (Event)((Object)request.getContext().asType(Event.class));
            if (event.getLocation() != null) {
                Map result = ((MapService)Beans.get(MapService.class)).getMap(event.getLocation());
                if (result != null) {
                    HashMap<String, String> mapView = new HashMap<String, String>();
                    mapView.put("title", "Map");
                    mapView.put("resource", (String)result.get("url"));
                    mapView.put("viewType", "html");
                    response.setView(mapView);
                } else {
                    response.setFlash(String.format(I18n.get((String)"<B>%s</B> not found"), event.getLocation()));
                }
            } else {
                response.setFlash(I18n.get((String)"Input location please"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void assignToMeLead(ActionRequest request, ActionResponse response) {
        LeadService leadService = (LeadService)Beans.get(LeadService.class);
        LeadRepository leadRepo = (LeadRepository)((Object)Beans.get(LeadRepository.class));
        if (request.getContext().get((Object)"id") != null) {
            Lead lead = (Lead)((Object)leadRepo.find((Long)request.getContext().get((Object)"id")));
            lead.setUser(AuthUtils.getUser());
            if (lead.getStatusSelect() == 1) {
                lead.setStatusSelect(2);
            }
            leadService.saveLead(lead);
        } else if ((List)request.getContext().get((Object)"_ids") != null) {
            for (Lead lead : leadRepo.all().filter("id in ?1", new Object[]{request.getContext().get((Object)"_ids")}).fetch()) {
                lead.setUser(AuthUtils.getUser());
                if (lead.getStatusSelect() == 1) {
                    lead.setStatusSelect(2);
                }
                leadService.saveLead(lead);
            }
        }
        response.setReload(true);
    }

    public void assignToMeEvent(ActionRequest request, ActionResponse response) {
        EventRepository eventRepository = (EventRepository)((Object)Beans.get(EventRepository.class));
        if (request.getContext().get((Object)"id") != null) {
            Event event = (Event)((Object)eventRepository.find((Long)request.getContext().get((Object)"id")));
            event.setUser(AuthUtils.getUser());
            ((EventService)Beans.get(EventService.class)).saveEvent(event);
        } else if (!((List)request.getContext().get((Object)"_ids")).isEmpty()) {
            for (Event event : eventRepository.all().filter("id in ?1", new Object[]{request.getContext().get((Object)"_ids")}).fetch()) {
                event.setUser(AuthUtils.getUser());
                ((EventService)Beans.get(EventService.class)).saveEvent(event);
            }
        }
        response.setReload(true);
    }

    public void manageFollowers(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Event event = (Event)((Object)request.getContext().asType(Event.class));
            event = (Event)((Object)((EventRepository)((Object)Beans.get(EventRepository.class))).find(event.getId()));
            ((EventService)Beans.get(EventService.class)).manageFollowers(event);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void generateRecurrentEvents(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Long eventId = (Long)request.getContext().get((Object)"id");
            if (eventId == null) {
                throw new AxelorException(Event.class, 5, I18n.get((String)"Please save the event before setting the recurrence"));
            }
            Event event = (Event)((Object)((EventRepository)((Object)Beans.get(EventRepository.class))).find(eventId));
            RecurrenceConfigurationRepository confRepo = (RecurrenceConfigurationRepository)((Object)Beans.get(RecurrenceConfigurationRepository.class));
            RecurrenceConfiguration conf = event.getRecurrenceConfiguration();
            if (conf != null) {
                conf = (RecurrenceConfiguration)((Object)confRepo.save((Model)((Object)conf)));
                ((EventService)Beans.get(EventService.class)).generateRecurrentEvents(event, conf);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void deleteThis(ActionRequest request, ActionResponse response) {
        Long eventId = new Long(request.getContext().getParent().get((Object)"id").toString());
        EventRepository eventRepository = (EventRepository)((Object)Beans.get(EventRepository.class));
        Event event = (Event)((Object)eventRepository.find(eventId));
        Event child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{event.getId()}).fetchOne());
        if (child != null) {
            child.setParentEvent(event.getParentEvent());
        }
        eventRepository.remove((Model)((Object)event));
        response.setCanClose(true);
        response.setReload(true);
    }

    @Transactional
    public void deleteNext(ActionRequest request, ActionResponse response) {
        Long eventId = new Long(request.getContext().getParent().get((Object)"id").toString());
        EventRepository eventRepository = (EventRepository)((Object)Beans.get(EventRepository.class));
        Event event = (Event)((Object)eventRepository.find(eventId));
        Event child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{event.getId()}).fetchOne());
        while (child != null) {
            child.setParentEvent(null);
            eventRepository.remove((Model)((Object)event));
            event = child;
            child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{event.getId()}).fetchOne());
        }
        response.setCanClose(true);
        response.setReload(true);
    }

    @Transactional
    public void deleteAll(ActionRequest request, ActionResponse response) {
        Long eventId = new Long(request.getContext().getParent().get((Object)"id").toString());
        EventRepository eventRepository = (EventRepository)((Object)Beans.get(EventRepository.class));
        Event event = (Event)((Object)eventRepository.find(eventId));
        Event child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{event.getId()}).fetchOne());
        Event parent = event.getParentEvent();
        while (child != null) {
            child.setParentEvent(null);
            eventRepository.remove((Model)((Object)event));
            event = child;
            child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{event.getId()}).fetchOne());
        }
        while (parent != null) {
            Event nextParent = parent.getParentEvent();
            eventRepository.remove((Model)((Object)parent));
            parent = nextParent;
        }
        response.setCanClose(true);
        response.setReload(true);
    }

    @Transactional(rollbackOn={Exception.class})
    public void changeAll(ActionRequest request, ActionResponse response) throws AxelorException {
        Long eventId = new Long(request.getContext().getParent().get((Object)"id").toString());
        EventRepository eventRepository = (EventRepository)((Object)Beans.get(EventRepository.class));
        Event event = (Event)((Object)eventRepository.find(eventId));
        Event child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{event.getId()}).fetchOne());
        Event parent = event.getParentEvent();
        child.setParentEvent(null);
        Event eventDeleted = child;
        child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{eventDeleted.getId()}).fetchOne());
        while (child != null) {
            child.setParentEvent(null);
            eventRepository.remove((Model)((Object)eventDeleted));
            eventDeleted = child;
            child = (Event)((Object)eventRepository.all().filter("self.parentEvent.id = ?1", new Object[]{eventDeleted.getId()}).fetchOne());
        }
        while (parent != null) {
            Event nextParent = parent.getParentEvent();
            eventRepository.remove((Model)((Object)parent));
            parent = nextParent;
        }
        RecurrenceConfiguration conf = (RecurrenceConfiguration)((Object)request.getContext().asType(RecurrenceConfiguration.class));
        RecurrenceConfigurationRepository confRepo = (RecurrenceConfigurationRepository)((Object)Beans.get(RecurrenceConfigurationRepository.class));
        conf = (RecurrenceConfiguration)((Object)confRepo.save((Model)((Object)conf)));
        event.setRecurrenceConfiguration(conf);
        event = (Event)((Object)eventRepository.save((Model)((Object)event)));
        if (conf.getRecurrenceType() == null) {
            throw new AxelorException(4, I18n.get((String)"You must choose a recurrence type"));
        }
        int recurrenceType = conf.getRecurrenceType();
        if (conf.getPeriodicity() == null) {
            throw new AxelorException(4, I18n.get((String)"Periodicity must be greater than 0"));
        }
        int periodicity = conf.getPeriodicity();
        if (periodicity < 1) {
            throw new AxelorException(4, I18n.get((String)"Periodicity must be greater than 0"));
        }
        boolean monday = conf.getMonday();
        boolean tuesday = conf.getTuesday();
        boolean wednesday = conf.getWednesday();
        boolean thursday = conf.getThursday();
        boolean friday = conf.getFriday();
        boolean saturday = conf.getSaturday();
        boolean sunday = conf.getSunday();
        HashMap<Integer, Boolean> daysMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> daysCheckedMap = new HashMap<Integer, Boolean>();
        if (recurrenceType == 2) {
            daysMap.put(DayOfWeek.MONDAY.getValue(), monday);
            daysMap.put(DayOfWeek.TUESDAY.getValue(), tuesday);
            daysMap.put(DayOfWeek.WEDNESDAY.getValue(), wednesday);
            daysMap.put(DayOfWeek.THURSDAY.getValue(), thursday);
            daysMap.put(DayOfWeek.FRIDAY.getValue(), friday);
            daysMap.put(DayOfWeek.SATURDAY.getValue(), saturday);
            daysMap.put(DayOfWeek.SUNDAY.getValue(), sunday);
            for (Integer day : daysMap.keySet()) {
                if (!((Boolean)daysMap.get(day)).booleanValue()) continue;
                daysCheckedMap.put(day, (Boolean)daysMap.get(day));
            }
            if (daysMap.isEmpty()) {
                throw new AxelorException(4, I18n.get((String)"You must choose at least one day in the week"));
            }
        }
        int monthRepeatType = conf.getMonthRepeatType();
        int endType = conf.getEndType();
        int repetitionsNumber = 0;
        if (endType == 1) {
            if (conf.getRepetitionsNumber() == null) {
                throw new AxelorException(4, I18n.get((String)"The number of repetitions must be greater than 0"));
            }
            repetitionsNumber = conf.getRepetitionsNumber();
            if (repetitionsNumber < 1) {
                throw new AxelorException(4, "The number of repetitions must be greater than 0");
            }
        }
        LocalDate endDate = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(event.getUser() != null ? event.getUser().getActiveCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
        if (endType == 2) {
            if (conf.getEndDate() == null) {
                throw new AxelorException(4, I18n.get((String)"The end date must be after the start date"));
            }
            endDate = conf.getEndDate();
            if (endDate.isBefore(event.getStartDateTime().toLocalDate()) && endDate.isEqual(event.getStartDateTime().toLocalDate())) {
                throw new AxelorException(4, I18n.get((String)"The end date must be after the start date"));
            }
        }
        switch (recurrenceType) {
            case 1: {
                ((EventService)Beans.get(EventService.class)).addRecurrentEventsByDays(event, periodicity, endType, repetitionsNumber, endDate);
                break;
            }
            case 2: {
                ((EventService)Beans.get(EventService.class)).addRecurrentEventsByWeeks(event, periodicity, endType, repetitionsNumber, endDate, daysCheckedMap);
                break;
            }
            case 3: {
                ((EventService)Beans.get(EventService.class)).addRecurrentEventsByMonths(event, periodicity, endType, repetitionsNumber, endDate, monthRepeatType);
                break;
            }
            case 4: {
                ((EventService)Beans.get(EventService.class)).addRecurrentEventsByYears(event, periodicity, endType, repetitionsNumber, endDate);
                break;
            }
        }
        response.setCanClose(true);
        response.setReload(true);
    }

    public void applyChangesToAll(ActionRequest request, ActionResponse response) {
        EventRepository eventRepository = (EventRepository)((Object)Beans.get(EventRepository.class));
        Event thisEvent = (Event)((Object)eventRepository.find(new Long(request.getContext().get((Object)"_idEvent").toString())));
        Event event = (Event)((Object)eventRepository.find(thisEvent.getId()));
        ((EventService)Beans.get(EventService.class)).applyChangesToAll(event);
        response.setCanClose(true);
        response.setReload(true);
    }

    public void computeRecurrenceName(ActionRequest request, ActionResponse response) {
        RecurrenceConfiguration recurrConf = (RecurrenceConfiguration)((Object)request.getContext().asType(RecurrenceConfiguration.class));
        response.setValue("recurrenceName", (Object)((EventService)Beans.get(EventService.class)).computeRecurrenceName(recurrConf));
    }

    public void setCalendarDomain(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        List<Long> calendarIdlist = ((CalendarService)((Object)Beans.get(CalendarService.class))).showSharedCalendars(user);
        if (calendarIdlist.isEmpty()) {
            response.setAttr("calendar", "domain", (Object)"self.id is null");
        } else {
            response.setAttr("calendar", "domain", (Object)("self.id in (" + Joiner.on((String)",").join(calendarIdlist) + ")"));
        }
    }

    public void checkRights(ActionRequest request, ActionResponse response) {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        User user = AuthUtils.getUser();
        List<Long> calendarIdlist = ((CalendarService)((Object)Beans.get(CalendarService.class))).showSharedCalendars(user);
        if (calendarIdlist.isEmpty() || !calendarIdlist.contains(event.getCalendar().getId())) {
            response.setAttr("meetingGeneralPanel", "readonly", (Object)"true");
            response.setAttr("addGuestsPanel", "readonly", (Object)"true");
            response.setAttr("meetingAttributesPanel", "readonly", (Object)"true");
            response.setAttr("meetingLinkedPanel", "readonly", (Object)"true");
        }
    }

    public void changeCreator(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        response.setValue("organizer", (Object)((CalendarService)((Object)Beans.get(CalendarService.class))).findOrCreateUser(user));
    }

    public void addGuest(ActionRequest request, ActionResponse response) {
        Event event = (Event)((Object)request.getContext().asType(Event.class));
        try {
            EmailAddress emailAddress = ((EventService)Beans.get(EventService.class)).getEmailAddress(event);
            if (emailAddress != null) {
                response.setValue("attendees", (Object)((ICalendarEventService)Beans.get(ICalendarEventService.class)).addEmailGuest(emailAddress, (ICalendarEvent)event));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void deleteReminder(ActionRequest request, ActionResponse response) {
        try {
            EventReminderRepository eventReminderRepository = (EventReminderRepository)((Object)Beans.get(EventReminderRepository.class));
            EventReminder eventReminder = (EventReminder)((Object)eventReminderRepository.find((long)((Long)request.getContext().get((Object)"id"))));
            eventReminderRepository.remove((Model)((Object)eventReminder));
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

