/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.web;

import com.axelor.apps.base.service.MapService;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.apps.crm.service.OpportunityService;
import com.axelor.auth.AuthUtils;
import com.axelor.common.ObjectUtils;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class OpportunityController {
    public void assignToMe(ActionRequest request, ActionResponse response) {
        OpportunityService opportunityService = (OpportunityService)Beans.get(OpportunityService.class);
        OpportunityRepository opportunityRepository = (OpportunityRepository)((Object)Beans.get(OpportunityRepository.class));
        if (request.getContext().get((Object)"id") != null) {
            Opportunity opportunity = (Opportunity)((Object)opportunityRepository.find((Long)request.getContext().get((Object)"id")));
            opportunity.setUser(AuthUtils.getUser());
            opportunityService.saveOpportunity(opportunity);
        } else if (ObjectUtils.notEmpty((Object)request.getContext().get((Object)"_ids"))) {
            for (Opportunity opportunity : opportunityRepository.all().filter("id in ?1", new Object[]{request.getContext().get((Object)"_ids")}).fetch()) {
                opportunity.setUser(AuthUtils.getUser());
                opportunityService.saveOpportunity(opportunity);
            }
        } else {
            response.setNotify("Please select at least one record.");
            return;
        }
        response.setReload(true);
    }

    public void showOpportunitiesOnMap(ActionRequest request, ActionResponse response) {
        try {
            response.setView(ActionView.define((String)I18n.get((String)"Opportunities")).add("html", ((MapService)Beans.get(MapService.class)).getMapURI("opportunity")).map());
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void createClient(ActionRequest request, ActionResponse response) {
        try {
            Opportunity opportunity = (Opportunity)((Object)request.getContext().asType(Opportunity.class));
            opportunity = (Opportunity)((Object)((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).find(opportunity.getId()));
            ((OpportunityService)Beans.get(OpportunityService.class)).createClientFromLead(opportunity);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            response.setError(e.getMessage());
        }
    }
}

