/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.meta.MetaFiles;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportLeadConfiguration {
    public static final String IMPORT_LEAD_CONFIG = "import-lead-config.xml";
    public static final String IMPORT_LEAD_CSV = "Lead.csv";
    public static final String FILES_DIR = "files";
    private final Logger log = LoggerFactory.getLogger(ImportLeadConfiguration.class);
    @Inject
    private MetaFiles metaFiles;

    public Object importFiles(Object bean, Map<String, Object> values) {
        assert (bean instanceof ImportConfiguration);
        Path path = (Path)values.get("__path__");
        ImportConfiguration importConfig = (ImportConfiguration)bean;
        try {
            File file = path.resolve(FILES_DIR + File.separator + IMPORT_LEAD_CONFIG).toFile();
            importConfig.setBindMetaFile(this.metaFiles.upload(file));
            file = path.resolve(FILES_DIR + File.separator + IMPORT_LEAD_CSV).toFile();
            importConfig.setDataMetaFile(this.metaFiles.upload(file));
        }
        catch (IOException e) {
            this.log.debug("Error importing lead import config", (Throwable)e);
            return null;
        }
        return importConfig;
    }
}

