/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.MapRestService;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/map")
public class MapRestCrm {
    @Inject
    private MapRestService mapRestService;
    @Inject
    private LeadRepository leadRepo;
    @Inject
    private OpportunityRepository opportunityRepo;
    private JsonNodeFactory factory = JsonNodeFactory.instance;

    @Path(value="/lead")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getLeads() {
        ObjectNode mainNode = this.factory.objectNode();
        try {
            List leads = this.leadRepo.all().fetch();
            ArrayNode arrayNode = this.factory.arrayNode();
            for (Lead lead : leads) {
                String fullName = lead.getFirstName() + " " + lead.getName();
                if (lead.getEnterpriseName() != null) {
                    fullName = lead.getEnterpriseName() + "<br/>" + fullName;
                }
                ObjectNode objectNode = this.factory.objectNode();
                objectNode.put("fullName", fullName);
                objectNode.put("fixedPhone", lead.getFixedPhone() != null ? lead.getFixedPhone() : " ");
                if (lead.getEmailAddress() != null) {
                    objectNode.put("emailAddress", lead.getEmailAddress().getAddress());
                }
                StringBuilder addressString = new StringBuilder();
                if (lead.getPrimaryAddress() != null) {
                    addressString.append(lead.getPrimaryAddress() + "<br/>");
                }
                if (lead.getPrimaryCity() != null) {
                    addressString.append(lead.getPrimaryCity() + "<br/>");
                }
                if (lead.getPrimaryPostalCode() != null) {
                    addressString.append(lead.getPrimaryPostalCode() + "<br/>");
                }
                if (lead.getPrimaryState() != null) {
                    addressString.append(lead.getPrimaryState() + "<br/>");
                }
                if (lead.getPrimaryCountry() != null) {
                    addressString.append(lead.getPrimaryCountry().getName());
                }
                String addressFullname = addressString.toString();
                objectNode.put("address", addressFullname);
                objectNode.put("pinColor", "yellow");
                objectNode.put("pinChar", I18n.get((String)"MapRest.PinCharLead"));
                Map result = ((MapService)Beans.get(MapService.class)).getMap(addressFullname);
                if (result != null) {
                    objectNode.put("latit", (BigDecimal)result.get("latitude"));
                    objectNode.put("longit", (BigDecimal)result.get("longitude"));
                }
                arrayNode.add((JsonNode)objectNode);
            }
            this.mapRestService.setData(mainNode, arrayNode);
        }
        catch (Exception e) {
            this.mapRestService.setError(mainNode, e);
        }
        return mainNode;
    }

    @Path(value="/opportunity")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getOpportunities() {
        ObjectNode mainNode = this.factory.objectNode();
        try {
            List opportunities = this.opportunityRepo.all().fetch();
            ArrayNode arrayNode = this.factory.arrayNode();
            for (Opportunity opportunity : opportunities) {
                Address address;
                Partner partner = opportunity.getPartner();
                if (partner == null) continue;
                ObjectNode objectNode = this.factory.objectNode();
                String currencyCode = "";
                if (opportunity.getCurrency() != null) {
                    currencyCode = opportunity.getCurrency().getCode();
                }
                String amtLabel = "Amount";
                if (!Strings.isNullOrEmpty((String)I18n.get((String)"amount"))) {
                    amtLabel = I18n.get((String)"amount");
                }
                String amount = amtLabel + " : " + opportunity.getAmount() + " " + currencyCode;
                objectNode.put("fullName", opportunity.getName() + "<br/>" + amount);
                objectNode.put("fixedPhone", partner.getFixedPhone() != null ? partner.getFixedPhone() : " ");
                if (partner.getEmailAddress() != null) {
                    objectNode.put("emailAddress", partner.getEmailAddress().getAddress());
                }
                if ((address = ((PartnerService)Beans.get(PartnerService.class)).getInvoicingAddress(partner)) != null) {
                    String addressString = this.mapRestService.makeAddressString(address, objectNode);
                    objectNode.put("address", addressString);
                }
                objectNode.put("pinColor", "pink");
                objectNode.put("pinChar", I18n.get((String)"MapRest.PinCharOpportunity"));
                arrayNode.add((JsonNode)objectNode);
            }
            this.mapRestService.setData(mainNode, arrayNode);
        }
        catch (Exception e) {
            this.mapRestService.setError(mainNode, e);
        }
        return mainNode;
    }
}

