/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.control.ResponseControl;

public class AuthenticationResponse
extends Response<Boolean> {
    private final AuthenticationResultCode authenticationResultCode;
    private final String resolvedDn;
    private final LdapEntry ldapEntry;
    private AccountState accountState;

    public AuthenticationResponse(AuthenticationResultCode authRc, ResultCode rc, String dn, LdapEntry entry) {
        super(AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS == authRc, rc);
        this.authenticationResultCode = authRc;
        this.resolvedDn = dn;
        this.ldapEntry = entry;
    }

    public AuthenticationResponse(AuthenticationResultCode authRc, ResultCode rc, String dn, LdapEntry entry, String msg) {
        super(AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS == authRc, rc, msg, null, null, null, -1);
        this.authenticationResultCode = authRc;
        this.resolvedDn = dn;
        this.ldapEntry = entry;
    }

    public AuthenticationResponse(AuthenticationResultCode authRc, ResultCode rc, String dn, LdapEntry entry, String msg, ResponseControl[] controls, int msgId) {
        super(AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS == authRc, rc, msg, null, controls, null, msgId);
        this.authenticationResultCode = authRc;
        this.resolvedDn = dn;
        this.ldapEntry = entry;
    }

    public AuthenticationResultCode getAuthenticationResultCode() {
        return this.authenticationResultCode;
    }

    public String getResolvedDn() {
        return this.resolvedDn;
    }

    public LdapEntry getLdapEntry() {
        return this.ldapEntry;
    }

    public AccountState getAccountState() {
        return this.accountState;
    }

    public void setAccountState(AccountState state) {
        this.accountState = state;
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::authenticationResultCode=%s, resolvedDn=%s, ldapEntry=%s, accountState=%s, result=%s, resultCode=%s, message=%s, controls=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.authenticationResultCode, this.resolvedDn, this.ldapEntry, this.accountState, this.getResult(), this.getResultCode(), encodeCntrlChars ? LdapUtils.percentEncodeControlChars(this.getMessage()) : this.getMessage(), Arrays.toString(this.getControls())});
    }
}

