/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.marketing.db.Campaign;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MARKETING_CAMPAIGN_REMINDER", indexes={@Index(columnList="campaign")})
public class CampaignReminder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MARKETING_CAMPAIGN_REMINDER_SEQ")
    @SequenceGenerator(name="MARKETING_CAMPAIGN_REMINDER_SEQ", sequenceName="MARKETING_CAMPAIGN_REMINDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Campaign")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Campaign campaign;
    @Widget(title="Type", selection="marketing.campaign.reminder.type.select")
    private Integer typeSelect = 1;
    @Widget(title="Duration")
    private Integer duration = 0;
    @Widget(title="Duration type", selection="marketing.campaign.reminder.duration.type.select")
    private Integer durationTypeSelect = 3;
    @Widget(title="Assign to", selection="marketing.campaign.reminder.assign.to.select")
    private Integer assignToSelect = 0;
    @Widget(title="Reminded")
    private Boolean isReminded = Boolean.FALSE;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getDuration() {
        return this.duration == null ? 0 : this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getDurationTypeSelect() {
        return this.durationTypeSelect == null ? 0 : this.durationTypeSelect;
    }

    public void setDurationTypeSelect(Integer durationTypeSelect) {
        this.durationTypeSelect = durationTypeSelect;
    }

    public Integer getAssignToSelect() {
        return this.assignToSelect == null ? 0 : this.assignToSelect;
    }

    public void setAssignToSelect(Integer assignToSelect) {
        this.assignToSelect = assignToSelect;
    }

    public Boolean getIsReminded() {
        return this.isReminded == null ? Boolean.FALSE : this.isReminded;
    }

    public void setIsReminded(Boolean isReminded) {
        this.isReminded = isReminded;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CampaignReminder)) {
            return false;
        }
        CampaignReminder other = (CampaignReminder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).add("duration", (Object)this.getDuration()).add("durationTypeSelect", (Object)this.getDurationTypeSelect()).add("assignToSelect", (Object)this.getAssignToSelect()).add("isReminded", (Object)this.getIsReminded()).omitNullValues().toString();
    }
}

