/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Lead;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.studio.db.Filter;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MARKETING_TARGET_LIST", indexes={@Index(columnList="name")})
public class TargetList
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MARKETING_TARGET_LIST_SEQ")
    @SequenceGenerator(name="MARKETING_TARGET_LIST_SEQ", sequenceName="MARKETING_TARGET_LIST_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Partner filters")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Filter> partnerFilterList;
    @Widget(title="Select type", selection="target.partner.type.select")
    private Integer partnerTypeSelect = 0;
    @Widget(title="Additional Partner/Contacts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> partnerSet;
    @Widget(title="Partner Query")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String partnerQuery;
    @Widget(title="Select Query type", selection="marketing.target.list.query.type.select")
    private Integer partnerQueryTypeSelect = 0;
    @Widget(title="Lead filters")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Filter> leadFilterList;
    @Widget(title="Additional leads")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Lead> leadSet;
    @Widget(title="Lead Query")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String leadQuery;
    @Widget(title="Select Query type", selection="marketing.target.list.query.type.select")
    private Integer leadQueryTypeSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TargetList() {
    }

    public TargetList(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Filter> getPartnerFilterList() {
        return this.partnerFilterList;
    }

    public void setPartnerFilterList(List<Filter> partnerFilterList) {
        this.partnerFilterList = partnerFilterList;
    }

    public void addPartnerFilterListItem(Filter item) {
        if (this.getPartnerFilterList() == null) {
            this.setPartnerFilterList(new ArrayList<Filter>());
        }
        this.getPartnerFilterList().add(item);
    }

    public void removePartnerFilterListItem(Filter item) {
        if (this.getPartnerFilterList() == null) {
            return;
        }
        this.getPartnerFilterList().remove(item);
    }

    public void clearPartnerFilterList() {
        if (this.getPartnerFilterList() != null) {
            this.getPartnerFilterList().clear();
        }
    }

    public Integer getPartnerTypeSelect() {
        return this.partnerTypeSelect == null ? 0 : this.partnerTypeSelect;
    }

    public void setPartnerTypeSelect(Integer partnerTypeSelect) {
        this.partnerTypeSelect = partnerTypeSelect;
    }

    public Set<Partner> getPartnerSet() {
        return this.partnerSet;
    }

    public void setPartnerSet(Set<Partner> partnerSet) {
        this.partnerSet = partnerSet;
    }

    public void addPartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            this.setPartnerSet(new HashSet<Partner>());
        }
        this.getPartnerSet().add(item);
    }

    public void removePartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            return;
        }
        this.getPartnerSet().remove(item);
    }

    public void clearPartnerSet() {
        if (this.getPartnerSet() != null) {
            this.getPartnerSet().clear();
        }
    }

    public String getPartnerQuery() {
        return this.partnerQuery;
    }

    public void setPartnerQuery(String partnerQuery) {
        this.partnerQuery = partnerQuery;
    }

    public Integer getPartnerQueryTypeSelect() {
        return this.partnerQueryTypeSelect == null ? 0 : this.partnerQueryTypeSelect;
    }

    public void setPartnerQueryTypeSelect(Integer partnerQueryTypeSelect) {
        this.partnerQueryTypeSelect = partnerQueryTypeSelect;
    }

    public List<Filter> getLeadFilterList() {
        return this.leadFilterList;
    }

    public void setLeadFilterList(List<Filter> leadFilterList) {
        this.leadFilterList = leadFilterList;
    }

    public void addLeadFilterListItem(Filter item) {
        if (this.getLeadFilterList() == null) {
            this.setLeadFilterList(new ArrayList<Filter>());
        }
        this.getLeadFilterList().add(item);
    }

    public void removeLeadFilterListItem(Filter item) {
        if (this.getLeadFilterList() == null) {
            return;
        }
        this.getLeadFilterList().remove(item);
    }

    public void clearLeadFilterList() {
        if (this.getLeadFilterList() != null) {
            this.getLeadFilterList().clear();
        }
    }

    public Set<Lead> getLeadSet() {
        return this.leadSet;
    }

    public void setLeadSet(Set<Lead> leadSet) {
        this.leadSet = leadSet;
    }

    public void addLeadSetItem(Lead item) {
        if (this.getLeadSet() == null) {
            this.setLeadSet(new HashSet<Lead>());
        }
        this.getLeadSet().add(item);
    }

    public void removeLeadSetItem(Lead item) {
        if (this.getLeadSet() == null) {
            return;
        }
        this.getLeadSet().remove(item);
    }

    public void clearLeadSet() {
        if (this.getLeadSet() != null) {
            this.getLeadSet().clear();
        }
    }

    public String getLeadQuery() {
        return this.leadQuery;
    }

    public void setLeadQuery(String leadQuery) {
        this.leadQuery = leadQuery;
    }

    public Integer getLeadQueryTypeSelect() {
        return this.leadQueryTypeSelect == null ? 0 : this.leadQueryTypeSelect;
    }

    public void setLeadQueryTypeSelect(Integer leadQueryTypeSelect) {
        this.leadQueryTypeSelect = leadQueryTypeSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetList)) {
            return false;
        }
        TargetList other = (TargetList)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("partnerTypeSelect", (Object)this.getPartnerTypeSelect()).add("partnerQueryTypeSelect", (Object)this.getPartnerQueryTypeSelect()).add("leadQueryTypeSelect", (Object)this.getLeadQueryTypeSelect()).omitNullValues().toString();
    }
}

