/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.marketing.db.Campaign;
import com.axelor.apps.marketing.db.repo.CampaignRepository;
import com.axelor.apps.marketing.service.CampaignService;
import com.axelor.apps.marketing.service.TargetListService;
import com.axelor.apps.marketing.service.TemplateMessageMarketingService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Set;
import javax.mail.MessagingException;

public class CampaignServiceImpl
implements CampaignService {
    protected TemplateMessageMarketingService templateMessageMarketingService;
    protected EventRepository eventRepo;

    @Inject
    public CampaignServiceImpl(TemplateMessageService templateMessageService, EventRepository eventRepo, TemplateMessageMarketingService templateMessageMarketingService) {
        this.templateMessageMarketingService = templateMessageMarketingService;
        this.eventRepo = eventRepo;
    }

    @Override
    public MetaFile sendEmail(Campaign campaign) {
        String errorPartners = "";
        String errorLeads = "";
        this.templateMessageMarketingService.setEmailAccount(campaign.getEmailAccount());
        if (campaign.getPartnerTemplate() != null) {
            errorPartners = this.sendToPartners(campaign.getPartnerSet(), campaign.getPartnerTemplate(), campaign);
        }
        if (campaign.getLeadTemplate() != null) {
            errorLeads = this.sendToLeads(campaign.getLeadSet(), campaign.getLeadTemplate(), campaign);
        }
        if (errorPartners.isEmpty() && errorLeads.isEmpty()) {
            return null;
        }
        return this.generateLog(errorPartners, errorLeads, campaign.getEmailLog(), campaign.getId());
    }

    @Override
    public MetaFile sendReminderEmail(Campaign campaign) {
        String errorPartners = "";
        String errorLeads = "";
        this.templateMessageMarketingService.setEmailAccount(campaign.getEmailAccount());
        if (campaign.getPartnerReminderTemplate() != null) {
            errorPartners = this.sendToPartners(campaign.getInvitedPartnerSet(), campaign.getPartnerReminderTemplate(), campaign);
        }
        if (campaign.getLeadReminderTemplate() != null) {
            errorLeads = this.sendToLeads(campaign.getInvitedLeadSet(), campaign.getLeadReminderTemplate(), campaign);
        }
        if (errorPartners.isEmpty() && errorLeads.isEmpty()) {
            return null;
        }
        return this.generateLog(errorPartners, errorLeads, campaign.getEmailLog(), campaign.getId());
    }

    protected String sendToPartners(Set<Partner> partnerSet, Template template, Campaign campaign) {
        StringBuilder errors = new StringBuilder();
        for (Partner partner : partnerSet) {
            try {
                this.generateAndSendMessage(campaign, (Model)partner, template);
            }
            catch (AxelorException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | MessagingException e) {
                errors.append(partner.getName() + "\n");
                e.printStackTrace();
            }
        }
        return errors.toString();
    }

    protected String sendToLeads(Set<Lead> leadSet, Template template, Campaign campaign) {
        StringBuilder errors = new StringBuilder();
        for (Lead lead : leadSet) {
            try {
                this.generateAndSendMessage(campaign, (Model)lead, template);
            }
            catch (AxelorException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | MessagingException e) {
                errors.append(lead.getName() + "\n");
                e.printStackTrace();
            }
        }
        return errors.toString();
    }

    @Transactional(rollbackOn={Exception.class})
    protected void generateAndSendMessage(Campaign campaign, Model model, Template template) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException, AxelorException {
        Message message = this.templateMessageMarketingService.generateAndSendMessage(model, template);
        message.setRelatedTo1Select(Campaign.class.getCanonicalName());
        message.setRelatedTo1SelectId(campaign.getId());
    }

    protected MetaFile generateLog(String errorPartners, String errorLeads, MetaFile metaFile, Long campaignId) {
        if (metaFile == null) {
            metaFile = new MetaFile();
            metaFile.setFileName("EmailLog" + campaignId + ".text");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(I18n.get((String)"Error in sending an email to the following targets"));
        builder.append("\n");
        if (!errorPartners.isEmpty()) {
            builder.append(I18n.get((String)"Partners") + ":\n");
            builder.append(errorPartners);
        }
        if (!errorLeads.isEmpty()) {
            builder.append(I18n.get((String)"Leads") + ":\n");
            builder.append(errorLeads);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(builder.toString().getBytes());
        try {
            return ((MetaFiles)Beans.get(MetaFiles.class)).upload((InputStream)stream, metaFile.getFileName());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Transactional
    public void generateEvents(Campaign campaign) {
        Event event;
        LocalDateTime eventStartDateTime = campaign.getEventStartDateTime();
        Long duration = campaign.getDuration();
        LocalDateTime eventEndDateTime = eventStartDateTime.plusSeconds(duration);
        for (Partner partner : campaign.getPartnerSet()) {
            event = new Event();
            if (partner.getIsContact().booleanValue()) {
                event.setContactPartner(partner);
            } else {
                event.setPartner(partner);
            }
            event.setUser(campaign.getGenerateEventPerPartnerOrLead() != false ? partner.getUser() : campaign.getEventUser());
            event.setSubject(campaign.getSubject());
            event.setTypeSelect(campaign.getEventTypeSelect());
            event.setStartDateTime(eventStartDateTime);
            event.setEndDateTime(eventEndDateTime);
            event.setDuration(duration);
            event.setTeam(campaign.getGenerateEventPerPartnerOrLead() != false ? partner.getTeam() : campaign.getTeam());
            event.setCampaign(campaign);
            event.setStatusSelect(1);
            this.eventRepo.save((Model)((Object)event));
        }
        for (Lead lead : campaign.getLeadSet()) {
            event = new Event();
            event.setLead(lead);
            event.setUser(campaign.getGenerateEventPerPartnerOrLead() != false ? lead.getUser() : campaign.getEventUser());
            event.setSubject(campaign.getSubject());
            event.setTypeSelect(campaign.getEventTypeSelect());
            event.setStartDateTime(eventStartDateTime);
            event.setEndDateTime(eventEndDateTime);
            event.setDuration(duration);
            event.setTeam(campaign.getGenerateEventPerPartnerOrLead() != false ? lead.getTeam() : campaign.getTeam());
            event.setCampaign(campaign);
            event.setStatusSelect(1);
            this.eventRepo.save((Model)((Object)event));
        }
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void generateTargets(Campaign campaign) throws AxelorException {
        TargetListService targetListService = (TargetListService)Beans.get(TargetListService.class);
        Set<Partner> partnerSet = targetListService.getAllPartners(campaign.getTargetModelSet());
        Set<Lead> leadSet = targetListService.getAllLeads(campaign.getTargetModelSet());
        campaign.setPartnerSet(partnerSet);
        campaign.setLeadSet(leadSet);
    }

    @Override
    @Transactional
    public void inviteSelectedTargets(Campaign campaign, Campaign campaignContext) {
        Set<Partner> partners = campaign.getPartners();
        Set<Partner> notParticipatingPartnerSet = campaign.getNotParticipatingPartnerSet();
        for (Partner partner : campaignContext.getPartnerSet()) {
            if (!partner.isSelected() || partners.contains(partner) || notParticipatingPartnerSet.contains(partner)) continue;
            campaign.addInvitedPartnerSetItem(partner);
        }
        Set<Lead> leads = campaign.getLeads();
        Set<Lead> notParticipatingLeadSet = campaign.getNotParticipatingLeadSet();
        for (Lead lead : campaignContext.getLeadSet()) {
            if (!lead.isSelected() || leads.contains(lead) || notParticipatingLeadSet.contains(lead)) continue;
            campaign.addInvitedLeadSetItem(lead);
        }
        ((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).save((Model)((Object)campaign));
    }

    @Override
    @Transactional
    public void inviteAllTargets(Campaign campaign) {
        Set<Partner> partners = campaign.getPartners();
        Set<Partner> notParticipatingPartnerSet = campaign.getNotParticipatingPartnerSet();
        for (Partner partner : campaign.getPartnerSet()) {
            if (partners.contains(partner) || notParticipatingPartnerSet.contains(partner)) continue;
            campaign.addInvitedPartnerSetItem(partner);
        }
        Set<Lead> leads = campaign.getLeads();
        Set<Lead> notParticipatingLeadSet = campaign.getNotParticipatingLeadSet();
        for (Lead lead : campaign.getLeadSet()) {
            if (leads.contains(lead) || notParticipatingLeadSet.contains(lead)) continue;
            campaign.addInvitedLeadSetItem(lead);
        }
        ((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).save((Model)((Object)campaign));
    }

    @Override
    @Transactional
    public void addParticipatingTargets(Campaign campaign, Campaign campaignContext) {
        for (Partner partner : campaignContext.getInvitedPartnerSet()) {
            if (!partner.isSelected()) continue;
            campaign.addPartner(partner);
            campaign.removeInvitedPartnerSetItem(partner);
        }
        for (Lead lead : campaignContext.getInvitedLeadSet()) {
            if (!lead.isSelected()) continue;
            campaign.addLead(lead);
            campaign.removeInvitedLeadSetItem(lead);
        }
        ((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).save((Model)((Object)campaign));
    }

    @Override
    @Transactional
    public void addNotParticipatingTargets(Campaign campaign, Campaign campaignContext) {
        for (Partner partner : campaignContext.getInvitedPartnerSet()) {
            if (!partner.isSelected()) continue;
            campaign.addNotParticipatingPartnerSetItem(partner);
            campaign.removeInvitedPartnerSetItem(partner);
        }
        for (Lead lead : campaignContext.getInvitedLeadSet()) {
            if (!lead.isSelected()) continue;
            campaign.addNotParticipatingLeadSetItem(lead);
            campaign.removeInvitedLeadSetItem(lead);
        }
        ((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).save((Model)((Object)campaign));
    }

    @Override
    @Transactional
    public void markLeadPresent(Campaign campaign, Lead lead) {
        campaign.addPresentLeadSetItem(lead);
        ((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).save((Model)((Object)campaign));
    }

    @Override
    @Transactional
    public void markPartnerPresent(Campaign campaign, Partner partner) {
        campaign.addPresentPartnerSetItem(partner);
        ((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).save((Model)((Object)campaign));
    }
}

