/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.marketing.db.TargetList;
import com.axelor.apps.marketing.service.TargetListService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.studio.service.filter.FilterJpqlService;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;

public class TargetListServiceImpl
implements TargetListService {
    @Inject
    private FilterJpqlService filterJpqlService;
    @Inject
    private PartnerRepository partnerRepo;
    @Inject
    private LeadRepository leadRepo;

    @Override
    public String getPartnerQuery(TargetList targetList) {
        String partnerFilters = null;
        if (targetList.getPartnerQueryTypeSelect() == 0) {
            partnerFilters = this.filterJpqlService.getJpqlFilters(targetList.getPartnerFilterList());
        }
        if (targetList.getPartnerQueryTypeSelect() == 1) {
            partnerFilters = targetList.getPartnerQuery();
        }
        return partnerFilters;
    }

    @Override
    public String getLeadQuery(TargetList targetList) {
        String leadFilters = null;
        if (targetList.getLeadQueryTypeSelect() == 0) {
            leadFilters = this.filterJpqlService.getJpqlFilters(targetList.getLeadFilterList());
        }
        if (targetList.getLeadQueryTypeSelect() == 1) {
            leadFilters = targetList.getLeadQuery();
        }
        return leadFilters;
    }

    @Override
    public Set<Partner> getAllPartners(Set<TargetList> targetListSet) throws AxelorException {
        HashSet<Partner> partnerSet = new HashSet<Partner>();
        for (TargetList target : targetListSet) {
            String filter = this.getPartnerQuery(target);
            if (filter != null) {
                try {
                    partnerSet.addAll(this.partnerRepo.all().filter(filter).fetch());
                }
                catch (Exception e) {
                    throw new AxelorException(4, I18n.get((String)"Cannot generate targets. Please check partner filter of Target Model."));
                }
            }
            for (Partner partner : target.getPartnerSet()) {
                partnerSet.add(partner);
            }
        }
        return partnerSet;
    }

    @Override
    public Set<Lead> getAllLeads(Set<TargetList> targetListSet) throws AxelorException {
        HashSet<Lead> leadSet = new HashSet<Lead>();
        for (TargetList target : targetListSet) {
            String filter = this.getLeadQuery(target);
            if (filter != null) {
                try {
                    leadSet.addAll(this.leadRepo.all().filter(filter).fetch());
                }
                catch (Exception e) {
                    throw new AxelorException(4, I18n.get((String)"Cannot generate targets. Please check lead filter of Target Model."));
                }
            }
            for (Lead lead : target.getLeadSet()) {
                leadSet.add(lead);
            }
        }
        return leadSet;
    }
}

