/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Year;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_DECLARATION_OF_EXCHANGES", indexes={@Index(columnList="company"), @Index(columnList="country"), @Index(columnList="fiscal_year"), @Index(columnList="period")})
public class DeclarationOfExchanges
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_DECLARATION_OF_EXCHANGES_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_DECLARATION_OF_EXCHANGES_SEQ", sequenceName="SUPPLYCHAIN_DECLARATION_OF_EXCHANGES_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country country;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Year fiscalYear;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="Product type", selection="supplychain.declaration.of.exchanges.product.type.select")
    @NotNull
    private String productTypeSelect = "storable";
    @Widget(title="Stock move type", selection="stock.move.type.select")
    @NotNull
    private Integer stockMoveTypeSelect = 2;
    @Widget(title="Format", selection="iadministration.declaration.of.exchanges.export.type.select")
    @NotNull
    private String formatSelect = "pdf";
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public Year getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(Year fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public String getProductTypeSelect() {
        return this.productTypeSelect;
    }

    public void setProductTypeSelect(String productTypeSelect) {
        this.productTypeSelect = productTypeSelect;
    }

    public Integer getStockMoveTypeSelect() {
        return this.stockMoveTypeSelect == null ? 0 : this.stockMoveTypeSelect;
    }

    public void setStockMoveTypeSelect(Integer stockMoveTypeSelect) {
        this.stockMoveTypeSelect = stockMoveTypeSelect;
    }

    public String getFormatSelect() {
        return this.formatSelect;
    }

    public void setFormatSelect(String formatSelect) {
        this.formatSelect = formatSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeclarationOfExchanges)) {
            return false;
        }
        DeclarationOfExchanges other = (DeclarationOfExchanges)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("productTypeSelect", (Object)this.getProductTypeSelect()).add("stockMoveTypeSelect", (Object)this.getStockMoveTypeSelect()).add("formatSelect", (Object)this.getFormatSelect()).omitNullValues().toString();
    }
}

