/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.supplychain.db.MrpForecast;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_MRP", indexes={@Index(columnList="stock_location")})
public class Mrp
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_MRP_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_MRP_SEQ", sequenceName="SUPPLYCHAIN_MRP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Stock location")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Products")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Product categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductCategory> productCategorySet;
    @Widget(title="Product families")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductFamily> productFamilySet;
    @Widget(title="Sale orders")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<SaleOrderLine> saleOrderLineSet;
    @Widget(title="Forecasts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MrpForecast> mrpForecastSet;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Status", selection="supplychain.mrp.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Calculation Start Date")
    private LocalDateTime startDateTime;
    @Widget(title="Calculation End Date")
    private LocalDateTime endDateTime;
    @Widget(title="MRP number", readonly=true)
    private String mrpSeq;
    @Widget(title="Display product without proposal")
    private Boolean displayProductWithoutProposal = Boolean.FALSE;
    @Widget(title="Error that happened during the computation", readonly=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String errorLog;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            this.setProductSet(new HashSet<Product>());
        }
        this.getProductSet().add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            return;
        }
        this.getProductSet().remove((Object)item);
    }

    public void clearProductSet() {
        if (this.getProductSet() != null) {
            this.getProductSet().clear();
        }
    }

    public Set<ProductCategory> getProductCategorySet() {
        return this.productCategorySet;
    }

    public void setProductCategorySet(Set<ProductCategory> productCategorySet) {
        this.productCategorySet = productCategorySet;
    }

    public void addProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            this.setProductCategorySet(new HashSet<ProductCategory>());
        }
        this.getProductCategorySet().add(item);
    }

    public void removeProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            return;
        }
        this.getProductCategorySet().remove(item);
    }

    public void clearProductCategorySet() {
        if (this.getProductCategorySet() != null) {
            this.getProductCategorySet().clear();
        }
    }

    public Set<ProductFamily> getProductFamilySet() {
        return this.productFamilySet;
    }

    public void setProductFamilySet(Set<ProductFamily> productFamilySet) {
        this.productFamilySet = productFamilySet;
    }

    public void addProductFamilySetItem(ProductFamily item) {
        if (this.getProductFamilySet() == null) {
            this.setProductFamilySet(new HashSet<ProductFamily>());
        }
        this.getProductFamilySet().add(item);
    }

    public void removeProductFamilySetItem(ProductFamily item) {
        if (this.getProductFamilySet() == null) {
            return;
        }
        this.getProductFamilySet().remove(item);
    }

    public void clearProductFamilySet() {
        if (this.getProductFamilySet() != null) {
            this.getProductFamilySet().clear();
        }
    }

    public Set<SaleOrderLine> getSaleOrderLineSet() {
        return this.saleOrderLineSet;
    }

    public void setSaleOrderLineSet(Set<SaleOrderLine> saleOrderLineSet) {
        this.saleOrderLineSet = saleOrderLineSet;
    }

    public void addSaleOrderLineSetItem(SaleOrderLine item) {
        if (this.getSaleOrderLineSet() == null) {
            this.setSaleOrderLineSet(new HashSet<SaleOrderLine>());
        }
        this.getSaleOrderLineSet().add(item);
    }

    public void removeSaleOrderLineSetItem(SaleOrderLine item) {
        if (this.getSaleOrderLineSet() == null) {
            return;
        }
        this.getSaleOrderLineSet().remove((Object)item);
    }

    public void clearSaleOrderLineSet() {
        if (this.getSaleOrderLineSet() != null) {
            this.getSaleOrderLineSet().clear();
        }
    }

    public Set<MrpForecast> getMrpForecastSet() {
        return this.mrpForecastSet;
    }

    public void setMrpForecastSet(Set<MrpForecast> mrpForecastSet) {
        this.mrpForecastSet = mrpForecastSet;
    }

    public void addMrpForecastSetItem(MrpForecast item) {
        if (this.getMrpForecastSet() == null) {
            this.setMrpForecastSet(new HashSet<MrpForecast>());
        }
        this.getMrpForecastSet().add(item);
    }

    public void removeMrpForecastSetItem(MrpForecast item) {
        if (this.getMrpForecastSet() == null) {
            return;
        }
        this.getMrpForecastSet().remove((Object)item);
    }

    public void clearMrpForecastSet() {
        if (this.getMrpForecastSet() != null) {
            this.getMrpForecastSet().clear();
        }
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public String getMrpSeq() {
        return this.mrpSeq;
    }

    public void setMrpSeq(String mrpSeq) {
        this.mrpSeq = mrpSeq;
    }

    public Boolean getDisplayProductWithoutProposal() {
        return this.displayProductWithoutProposal == null ? Boolean.FALSE : this.displayProductWithoutProposal;
    }

    public void setDisplayProductWithoutProposal(Boolean displayProductWithoutProposal) {
        this.displayProductWithoutProposal = displayProductWithoutProposal;
    }

    public String getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mrp)) {
            return false;
        }
        Mrp other = (Mrp)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("endDate", (Object)this.getEndDate()).add("statusSelect", (Object)this.getStatusSelect()).add("startDateTime", (Object)this.getStartDateTime()).add("endDateTime", (Object)this.getEndDateTime()).add("mrpSeq", (Object)this.getMrpSeq()).add("displayProductWithoutProposal", (Object)this.getDisplayProductWithoutProposal()).omitNullValues().toString();
    }
}

