/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMin;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_SUPPLY_CHAIN_CONFIG", indexes={@Index(columnList="company")})
@Track(fields={@TrackField(name="company", on={TrackEvent.UPDATE}), @TrackField(name="hasOutSmForStorableProduct", on={TrackEvent.UPDATE}), @TrackField(name="hasOutSmForNonStorableProduct", on={TrackEvent.UPDATE}), @TrackField(name="hasInSmForStorableProduct", on={TrackEvent.UPDATE}), @TrackField(name="hasInSmForNonStorableProduct", on={TrackEvent.UPDATE}), @TrackField(name="autoAllocateOnReceipt", on={TrackEvent.UPDATE}), @TrackField(name="autoAllocateOnAllocation", on={TrackEvent.UPDATE}), @TrackField(name="autoRequestReservedQty", on={TrackEvent.UPDATE}), @TrackField(name="autoAllocateOnAvailabilityRequest", on={TrackEvent.UPDATE}), @TrackField(name="defaultEstimatedDate", on={TrackEvent.UPDATE}), @TrackField(name="numberOfDays", on={TrackEvent.UPDATE}), @TrackField(name="defaultEstimatedDateForPurchaseOrder", on={TrackEvent.UPDATE}), @TrackField(name="numberOfDaysForPurchaseOrder", on={TrackEvent.UPDATE})})
public class SupplyChainConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_SUPPLY_CHAIN_CONFIG_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_SUPPLY_CHAIN_CONFIG_SEQ", sequenceName="SUPPLYCHAIN_SUPPLY_CHAIN_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Generate out. moves for products")
    private Boolean hasOutSmForStorableProduct = Boolean.FALSE;
    @Widget(title="Generate out. moves for services")
    private Boolean hasOutSmForNonStorableProduct = Boolean.FALSE;
    @Widget(title="Generate inc. moves for products")
    private Boolean hasInSmForStorableProduct = Boolean.FALSE;
    @Widget(title="Generate inc. moves for services")
    private Boolean hasInSmForNonStorableProduct = Boolean.FALSE;
    @Widget(title="Auto allocate stock on receipt")
    private Boolean autoAllocateOnReceipt = Boolean.FALSE;
    @Widget(title="Auto allocate stock on other stock moves", help="If true, after allocating quantity for a given stock move we allocate the remaining quantity in others stock moves.")
    private Boolean autoAllocateOnAllocation = Boolean.FALSE;
    @Widget(title="Auto request reserved qty", help="If true, the requested quantity for reservation will be equal to the quantity of the given sale order line.")
    private Boolean autoRequestReservedQty = Boolean.FALSE;
    @Widget(title="Auto allocate during an availability request")
    private Boolean autoAllocateOnAvailabilityRequest = Boolean.FALSE;
    @Widget(title="Default estimated date in stock move from sale order", selection="supplychain.estimated.date.select")
    private Integer defaultEstimatedDate = 1;
    @Widget(title="Number of days")
    @DecimalMin(value="0")
    private BigDecimal numberOfDays = BigDecimal.ZERO;
    @Widget(title="Default estimated date in stock move from purchase order", selection="supplychain.estimated.date.select")
    private Integer defaultEstimatedDateForPurchaseOrder = 1;
    @Widget(title="Number of days")
    @DecimalMin(value="0")
    private BigDecimal numberOfDaysForPurchaseOrder = BigDecimal.ZERO;
    @Widget(title="Activate partial invoicing for incoming moves")
    private Boolean activateIncStockMovePartialInvoicing = Boolean.TRUE;
    @Widget(title="Activate partial invoicing for outgoing moves")
    private Boolean activateOutStockMovePartialInvoicing = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Boolean getHasOutSmForStorableProduct() {
        return this.hasOutSmForStorableProduct == null ? Boolean.FALSE : this.hasOutSmForStorableProduct;
    }

    public void setHasOutSmForStorableProduct(Boolean hasOutSmForStorableProduct) {
        this.hasOutSmForStorableProduct = hasOutSmForStorableProduct;
    }

    public Boolean getHasOutSmForNonStorableProduct() {
        return this.hasOutSmForNonStorableProduct == null ? Boolean.FALSE : this.hasOutSmForNonStorableProduct;
    }

    public void setHasOutSmForNonStorableProduct(Boolean hasOutSmForNonStorableProduct) {
        this.hasOutSmForNonStorableProduct = hasOutSmForNonStorableProduct;
    }

    public Boolean getHasInSmForStorableProduct() {
        return this.hasInSmForStorableProduct == null ? Boolean.FALSE : this.hasInSmForStorableProduct;
    }

    public void setHasInSmForStorableProduct(Boolean hasInSmForStorableProduct) {
        this.hasInSmForStorableProduct = hasInSmForStorableProduct;
    }

    public Boolean getHasInSmForNonStorableProduct() {
        return this.hasInSmForNonStorableProduct == null ? Boolean.FALSE : this.hasInSmForNonStorableProduct;
    }

    public void setHasInSmForNonStorableProduct(Boolean hasInSmForNonStorableProduct) {
        this.hasInSmForNonStorableProduct = hasInSmForNonStorableProduct;
    }

    public Boolean getAutoAllocateOnReceipt() {
        return this.autoAllocateOnReceipt == null ? Boolean.FALSE : this.autoAllocateOnReceipt;
    }

    public void setAutoAllocateOnReceipt(Boolean autoAllocateOnReceipt) {
        this.autoAllocateOnReceipt = autoAllocateOnReceipt;
    }

    public Boolean getAutoAllocateOnAllocation() {
        return this.autoAllocateOnAllocation == null ? Boolean.FALSE : this.autoAllocateOnAllocation;
    }

    public void setAutoAllocateOnAllocation(Boolean autoAllocateOnAllocation) {
        this.autoAllocateOnAllocation = autoAllocateOnAllocation;
    }

    public Boolean getAutoRequestReservedQty() {
        return this.autoRequestReservedQty == null ? Boolean.FALSE : this.autoRequestReservedQty;
    }

    public void setAutoRequestReservedQty(Boolean autoRequestReservedQty) {
        this.autoRequestReservedQty = autoRequestReservedQty;
    }

    public Boolean getAutoAllocateOnAvailabilityRequest() {
        return this.autoAllocateOnAvailabilityRequest == null ? Boolean.FALSE : this.autoAllocateOnAvailabilityRequest;
    }

    public void setAutoAllocateOnAvailabilityRequest(Boolean autoAllocateOnAvailabilityRequest) {
        this.autoAllocateOnAvailabilityRequest = autoAllocateOnAvailabilityRequest;
    }

    public Integer getDefaultEstimatedDate() {
        return this.defaultEstimatedDate == null ? 0 : this.defaultEstimatedDate;
    }

    public void setDefaultEstimatedDate(Integer defaultEstimatedDate) {
        this.defaultEstimatedDate = defaultEstimatedDate;
    }

    public BigDecimal getNumberOfDays() {
        return this.numberOfDays == null ? BigDecimal.ZERO : this.numberOfDays;
    }

    public void setNumberOfDays(BigDecimal numberOfDays) {
        this.numberOfDays = numberOfDays;
    }

    public Integer getDefaultEstimatedDateForPurchaseOrder() {
        return this.defaultEstimatedDateForPurchaseOrder == null ? 0 : this.defaultEstimatedDateForPurchaseOrder;
    }

    public void setDefaultEstimatedDateForPurchaseOrder(Integer defaultEstimatedDateForPurchaseOrder) {
        this.defaultEstimatedDateForPurchaseOrder = defaultEstimatedDateForPurchaseOrder;
    }

    public BigDecimal getNumberOfDaysForPurchaseOrder() {
        return this.numberOfDaysForPurchaseOrder == null ? BigDecimal.ZERO : this.numberOfDaysForPurchaseOrder;
    }

    public void setNumberOfDaysForPurchaseOrder(BigDecimal numberOfDaysForPurchaseOrder) {
        this.numberOfDaysForPurchaseOrder = numberOfDaysForPurchaseOrder;
    }

    public Boolean getActivateIncStockMovePartialInvoicing() {
        return this.activateIncStockMovePartialInvoicing == null ? Boolean.FALSE : this.activateIncStockMovePartialInvoicing;
    }

    public void setActivateIncStockMovePartialInvoicing(Boolean activateIncStockMovePartialInvoicing) {
        this.activateIncStockMovePartialInvoicing = activateIncStockMovePartialInvoicing;
    }

    public Boolean getActivateOutStockMovePartialInvoicing() {
        return this.activateOutStockMovePartialInvoicing == null ? Boolean.FALSE : this.activateOutStockMovePartialInvoicing;
    }

    public void setActivateOutStockMovePartialInvoicing(Boolean activateOutStockMovePartialInvoicing) {
        this.activateOutStockMovePartialInvoicing = activateOutStockMovePartialInvoicing;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SupplyChainConfig)) {
            return false;
        }
        SupplyChainConfig other = (SupplyChainConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("hasOutSmForStorableProduct", (Object)this.getHasOutSmForStorableProduct()).add("hasOutSmForNonStorableProduct", (Object)this.getHasOutSmForNonStorableProduct()).add("hasInSmForStorableProduct", (Object)this.getHasInSmForStorableProduct()).add("hasInSmForNonStorableProduct", (Object)this.getHasInSmForNonStorableProduct()).add("autoAllocateOnReceipt", (Object)this.getAutoAllocateOnReceipt()).add("autoAllocateOnAllocation", (Object)this.getAutoAllocateOnAllocation()).add("autoRequestReservedQty", (Object)this.getAutoRequestReservedQty()).add("autoAllocateOnAvailabilityRequest", (Object)this.getAutoAllocateOnAvailabilityRequest()).add("defaultEstimatedDate", (Object)this.getDefaultEstimatedDate()).add("numberOfDays", (Object)this.getNumberOfDays()).add("defaultEstimatedDateForPurchaseOrder", (Object)this.getDefaultEstimatedDateForPurchaseOrder()).omitNullValues().toString();
    }
}

