/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_SUPPLYCHAIN_BATCH", indexes={@Index(columnList="company"), @Index(columnList="team")})
public class SupplychainBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_SEQ", sequenceName="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Action", selection="supplychain.batch.action.select")
    @NotNull
    private Integer actionSelect = 1;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batches")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="supplychainBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Invoice orders batch type", selection="supplychain.supplychain.batch.invoice.orders.type.select")
    private Integer invoiceOrdersTypeSelect = 1;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> salespersonOrBuyerSet;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    private LocalDate orderUpToDate;
    private String deliveryOrReceiptState;
    @Widget(title="Status")
    private String statusSelect = "3";
    @Widget(title="Type", selection="supplychain.supplychain.batch.accounting.cut.off.type.select")
    private Integer accountingCutOffTypeSelect = 0;
    @Widget(title="Move date")
    private LocalDate moveDate;
    @Widget(title="Reverse move date")
    private LocalDate reverseMoveDate;
    @Widget(title="Recovered tax")
    private Boolean recoveredTax = Boolean.FALSE;
    @Widget(title="A.T.I.")
    private Boolean ati = Boolean.FALSE;
    @Widget(title="Move description")
    private String moveDescription;
    @Widget(title="Include not stock managed product")
    private Boolean includeNotStockManagedProduct = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public SupplychainBatch() {
    }

    public SupplychainBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList<Batch>());
        }
        this.getBatchList().add(item);
        item.setSupplychainBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public Integer getInvoiceOrdersTypeSelect() {
        return this.invoiceOrdersTypeSelect == null ? 0 : this.invoiceOrdersTypeSelect;
    }

    public void setInvoiceOrdersTypeSelect(Integer invoiceOrdersTypeSelect) {
        this.invoiceOrdersTypeSelect = invoiceOrdersTypeSelect;
    }

    public Set<User> getSalespersonOrBuyerSet() {
        return this.salespersonOrBuyerSet;
    }

    public void setSalespersonOrBuyerSet(Set<User> salespersonOrBuyerSet) {
        this.salespersonOrBuyerSet = salespersonOrBuyerSet;
    }

    public void addSalespersonOrBuyerSetItem(User item) {
        if (this.getSalespersonOrBuyerSet() == null) {
            this.setSalespersonOrBuyerSet(new HashSet<User>());
        }
        this.getSalespersonOrBuyerSet().add(item);
    }

    public void removeSalespersonOrBuyerSetItem(User item) {
        if (this.getSalespersonOrBuyerSet() == null) {
            return;
        }
        this.getSalespersonOrBuyerSet().remove((Object)item);
    }

    public void clearSalespersonOrBuyerSet() {
        if (this.getSalespersonOrBuyerSet() != null) {
            this.getSalespersonOrBuyerSet().clear();
        }
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public LocalDate getOrderUpToDate() {
        return this.orderUpToDate;
    }

    public void setOrderUpToDate(LocalDate orderUpToDate) {
        this.orderUpToDate = orderUpToDate;
    }

    public String getDeliveryOrReceiptState() {
        return this.deliveryOrReceiptState;
    }

    public void setDeliveryOrReceiptState(String deliveryOrReceiptState) {
        this.deliveryOrReceiptState = deliveryOrReceiptState;
    }

    public String getStatusSelect() {
        return this.statusSelect;
    }

    public void setStatusSelect(String statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getAccountingCutOffTypeSelect() {
        return this.accountingCutOffTypeSelect == null ? 0 : this.accountingCutOffTypeSelect;
    }

    public void setAccountingCutOffTypeSelect(Integer accountingCutOffTypeSelect) {
        this.accountingCutOffTypeSelect = accountingCutOffTypeSelect;
    }

    public LocalDate getMoveDate() {
        return this.moveDate;
    }

    public void setMoveDate(LocalDate moveDate) {
        this.moveDate = moveDate;
    }

    public LocalDate getReverseMoveDate() {
        return this.reverseMoveDate;
    }

    public void setReverseMoveDate(LocalDate reverseMoveDate) {
        this.reverseMoveDate = reverseMoveDate;
    }

    public Boolean getRecoveredTax() {
        return this.recoveredTax == null ? Boolean.FALSE : this.recoveredTax;
    }

    public void setRecoveredTax(Boolean recoveredTax) {
        this.recoveredTax = recoveredTax;
    }

    public Boolean getAti() {
        return this.ati == null ? Boolean.FALSE : this.ati;
    }

    public void setAti(Boolean ati) {
        this.ati = ati;
    }

    public String getMoveDescription() {
        return this.moveDescription;
    }

    public void setMoveDescription(String moveDescription) {
        this.moveDescription = moveDescription;
    }

    public Boolean getIncludeNotStockManagedProduct() {
        return this.includeNotStockManagedProduct == null ? Boolean.FALSE : this.includeNotStockManagedProduct;
    }

    public void setIncludeNotStockManagedProduct(Boolean includeNotStockManagedProduct) {
        this.includeNotStockManagedProduct = includeNotStockManagedProduct;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SupplychainBatch)) {
            return false;
        }
        SupplychainBatch other = (SupplychainBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(2138107720, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("actionSelect", (Object)this.getActionSelect()).add("invoiceOrdersTypeSelect", (Object)this.getInvoiceOrdersTypeSelect()).add("orderUpToDate", (Object)this.getOrderUpToDate()).add("deliveryOrReceiptState", (Object)this.getDeliveryOrReceiptState()).add("statusSelect", (Object)this.getStatusSelect()).add("accountingCutOffTypeSelect", (Object)this.getAccountingCutOffTypeSelect()).add("moveDate", (Object)this.getMoveDate()).add("reverseMoveDate", (Object)this.getReverseMoveDate()).add("recoveredTax", (Object)this.getRecoveredTax()).add("ati", (Object)this.getAti()).omitNullValues().toString();
    }
}

