/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.supplychain.db.TimetableTemplateLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_TIMETABLE_TEMPLATE", indexes={@Index(columnList="code"), @Index(columnList="name")})
public class TimetableTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_TIMETABLE_TEMPLATE_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_TIMETABLE_TEMPLATE_SEQ", sequenceName="SUPPLYCHAIN_TIMETABLE_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String code;
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="Terms")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="timetableTemplate", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TimetableTemplateLine> timetableTemplateLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TimetableTemplate() {
    }

    public TimetableTemplate(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TimetableTemplateLine> getTimetableTemplateLineList() {
        return this.timetableTemplateLineList;
    }

    public void setTimetableTemplateLineList(List<TimetableTemplateLine> timetableTemplateLineList) {
        this.timetableTemplateLineList = timetableTemplateLineList;
    }

    public void addTimetableTemplateLineListItem(TimetableTemplateLine item) {
        if (this.getTimetableTemplateLineList() == null) {
            this.setTimetableTemplateLineList(new ArrayList<TimetableTemplateLine>());
        }
        this.getTimetableTemplateLineList().add(item);
        item.setTimetableTemplate(this);
    }

    public void removeTimetableTemplateLineListItem(TimetableTemplateLine item) {
        if (this.getTimetableTemplateLineList() == null) {
            return;
        }
        this.getTimetableTemplateLineList().remove((Object)item);
    }

    public void clearTimetableTemplateLineList() {
        if (this.getTimetableTemplateLineList() != null) {
            this.getTimetableTemplateLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimetableTemplate)) {
            return false;
        }
        TimetableTemplate other = (TimetableTemplate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

