/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.supplychain.db.TimetableTemplate;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_TIMETABLE_TEMPLATE_LINE", indexes={@Index(columnList="payment_condition"), @Index(columnList="timetable_template")})
public class TimetableTemplateLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_TIMETABLE_TEMPLATE_LINE_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_TIMETABLE_TEMPLATE_LINE_SEQ", sequenceName="SUPPLYCHAIN_TIMETABLE_TEMPLATE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Time limit")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @NotNull
    @DecimalMin(value="0")
    @DecimalMax(value="100")
    @Digits(integer=3, fraction=2)
    private BigDecimal percentage = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TimetableTemplate timetableTemplate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public BigDecimal getPercentage() {
        return this.percentage == null ? BigDecimal.ZERO : this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public TimetableTemplate getTimetableTemplate() {
        return this.timetableTemplate;
    }

    public void setTimetableTemplate(TimetableTemplate timetableTemplate) {
        this.timetableTemplate = timetableTemplate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimetableTemplateLine)) {
            return false;
        }
        TimetableTemplateLine other = (TimetableTemplateLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("percentage", (Object)this.getPercentage()).omitNullValues().toString();
    }
}

