/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db.repo;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.repo.MrpRepository;
import com.axelor.apps.supplychain.service.MrpService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import javax.persistence.PersistenceException;

public class MrpManagementRepository
extends MrpRepository {
    public void remove(Mrp entity) {
        ((MrpService)Beans.get(MrpService.class)).reset(entity);
        super.save((Model)((Object)entity));
    }

    public Mrp save(Mrp entity) {
        try {
            if (Strings.isNullOrEmpty((String)entity.getMrpSeq())) {
                Company company = entity.getStockLocation().getCompany();
                String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("mrp", company);
                if (seq == null) {
                    throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"The company %s doesn't have any configured sequence for MRP"), new Object[]{company.getName()});
                }
                entity.setMrpSeq(seq);
            }
        }
        catch (AxelorException e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
        return (Mrp)((Object)super.save((Model)((Object)entity)));
    }

    public Mrp copy(Mrp entity, boolean deep) {
        Mrp copy = (Mrp)((Object)super.copy((Model)((Object)entity), deep));
        copy.setMrpSeq(null);
        return copy;
    }
}

