/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db.repo;

import com.axelor.apps.base.service.app.AppService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderManagementRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public class PurchaseOrderSupplychainRepository
extends PurchaseOrderManagementRepository {
    @Inject
    private AppService appService;

    public PurchaseOrder copy(PurchaseOrder entity, boolean deep) {
        PurchaseOrder copy = super.copy(entity, deep);
        if (!this.appService.isApp("supplychain")) {
            return copy;
        }
        copy.setReceiptState(1);
        copy.setAmountInvoiced(null);
        if (copy.getPurchaseOrderLineList() != null) {
            for (PurchaseOrderLine purchaseOrderLine : copy.getPurchaseOrderLineList()) {
                purchaseOrderLine.setReceiptState(null);
                purchaseOrderLine.setReceivedQty(null);
                purchaseOrderLine.setAmountInvoiced(null);
                purchaseOrderLine.setInvoiced(null);
            }
        }
        return copy;
    }

    public PurchaseOrder save(PurchaseOrder purchaseOrder) {
        if (this.appService.isApp("supplychain")) {
            ((PurchaseOrderServiceSupplychainImpl)Beans.get(PurchaseOrderServiceSupplychainImpl.class)).generateBudgetDistribution(purchaseOrder);
        }
        return super.save(purchaseOrder);
    }
}

