/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db.repo;

import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChainImpl;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.math.BigDecimal;
import java.util.Map;

public class SaleOrderLineSupplychainRepository
extends SaleOrderLineRepository {
    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        BigDecimal realQty;
        BigDecimal allocatedStock;
        Long saleOrderLineId = (Long)json.get("id");
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)this.find(saleOrderLineId));
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        if (saleOrder == null || saleOrderLine.getTypeSelect() == 1 || saleOrder.getStatusSelect() != 3 || saleOrder.getStockLocation() == null || saleOrderLine.getDeliveryState() == 3 || saleOrderLine.getProduct() != null && saleOrderLine.getProduct().getProductTypeSelect().equals("service")) {
            return super.populate(json, context);
        }
        BigDecimal availableStock = ((SaleOrderLineServiceSupplyChainImpl)Beans.get(SaleOrderLineServiceSupplyChainImpl.class)).getAvailableStock(saleOrder, saleOrderLine);
        BigDecimal availableQty = availableStock.add(allocatedStock = ((SaleOrderLineServiceSupplyChainImpl)Beans.get(SaleOrderLineServiceSupplyChainImpl.class)).getAllocatedStock(saleOrder, saleOrderLine));
        if (availableQty.compareTo(realQty = saleOrderLine.getQty()) >= 0) {
            saleOrderLine.setAvailableStatus(I18n.get((String)"Available"));
            saleOrderLine.setAvailableStatusSelect(1);
        } else if (availableQty.compareTo(realQty) < 0) {
            saleOrderLine.setAvailableStatus(I18n.get((String)"Missing") + " (" + availableQty.subtract(realQty) + ")");
            saleOrderLine.setAvailableStatusSelect(2);
        }
        json.put("availableStatus", saleOrderLine.getAvailableStatus());
        json.put("availableStatusSelect", saleOrderLine.getAvailableStatusSelect());
        return super.populate(json, context);
    }
}

