/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db.repo;

import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineStockRepository;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.util.Map;
import javax.persistence.PersistenceException;

public class StockMoveLineSupplychainRepository
extends StockMoveLineStockRepository {
    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        Long stockMoveLineId = (Long)json.get("id");
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)this.find(stockMoveLineId));
        StockMove stockMove = stockMoveLine.getStockMove();
        Map stockMoveLineMap = super.populate(json, context);
        if (stockMove != null && stockMove.getStatusSelect() == 3) {
            ((StockMoveLineServiceSupplychain)Beans.get(StockMoveLineServiceSupplychain.class)).setInvoiceStatus(stockMoveLine);
            json.put("availableStatus", stockMoveLine.getProduct() != null && stockMoveLine.getProduct().getStockManaged() != false ? stockMoveLine.getAvailableStatus() : null);
            json.put("availableStatusSelect", stockMoveLine.getAvailableStatusSelect());
        }
        return stockMoveLineMap;
    }

    public void remove(StockMoveLine stockMoveLine) {
        try {
            if (((StockMoveLineServiceSupplychain)Beans.get(StockMoveLineServiceSupplychain.class)).isAllocatedStockMoveLine(stockMoveLine)) {
                throw new AxelorException(4, I18n.get((String)"It is not possible to delete a stock move line with allocated or reserved quantity."));
            }
            super.remove((Model)((Object)stockMoveLine));
        }
        catch (AxelorException e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }
}

