/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.repo.AnalyticMoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.TaxAccountService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.generator.line.InvoiceLineManagement;
import com.axelor.apps.account.service.move.MoveCreateService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.service.AccountingCutOffService;
import com.axelor.apps.supplychain.service.config.AccountConfigSupplychainService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class AccountingCutOffServiceImpl
implements AccountingCutOffService {
    protected StockMoveRepository stockMoverepository;
    protected StockMoveLineRepository stockMoveLineRepository;
    protected MoveCreateService moveCreateService;
    protected MoveLineService moveLineService;
    protected AccountConfigSupplychainService accountConfigSupplychainService;
    protected SaleOrderRepository saleOrderRepository;
    protected PurchaseOrderRepository purchaseOrderRepository;
    protected MoveToolService moveToolService;
    protected AccountManagementAccountService accountManagementAccountService;
    protected TaxAccountService taxAccountService;
    protected AppAccountService appAccountService;
    protected AnalyticMoveLineService analyticMoveLineService;
    protected MoveRepository moveRepository;
    protected MoveValidateService moveValidateService;
    protected UnitConversionService unitConversionService;
    protected AnalyticMoveLineRepository analyticMoveLineRepository;
    protected ReconcileService reconcileService;
    protected int counter = 0;

    @Inject
    public AccountingCutOffServiceImpl(StockMoveRepository stockMoverepository, StockMoveLineRepository stockMoveLineRepository, MoveCreateService moveCreateService, MoveLineService moveLineService, AccountConfigSupplychainService accountConfigSupplychainService, SaleOrderRepository saleOrderRepository, PurchaseOrderRepository purchaseOrderRepository, MoveToolService moveToolService, AccountManagementAccountService accountManagementAccountService, TaxAccountService taxAccountService, AppAccountService appAccountService, AnalyticMoveLineService analyticMoveLineService, MoveRepository moveRepository, MoveValidateService moveValidateService, UnitConversionService unitConversionService, AnalyticMoveLineRepository analyticMoveLineRepository, ReconcileService reconcileService) {
        this.stockMoverepository = stockMoverepository;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.moveCreateService = moveCreateService;
        this.moveLineService = moveLineService;
        this.accountConfigSupplychainService = accountConfigSupplychainService;
        this.saleOrderRepository = saleOrderRepository;
        this.purchaseOrderRepository = purchaseOrderRepository;
        this.moveToolService = moveToolService;
        this.accountManagementAccountService = accountManagementAccountService;
        this.taxAccountService = taxAccountService;
        this.appAccountService = appAccountService;
        this.analyticMoveLineService = analyticMoveLineService;
        this.moveRepository = moveRepository;
        this.moveValidateService = moveValidateService;
        this.unitConversionService = unitConversionService;
        this.analyticMoveLineRepository = analyticMoveLineRepository;
        this.reconcileService = reconcileService;
    }

    @Override
    public List<StockMove> getStockMoves(Company company, int accountingCutOffTypeSelect, LocalDate moveDate, Integer limit, Integer offset) {
        int stockMoveTypeSelect = 0;
        if (accountingCutOffTypeSelect == 1) {
            stockMoveTypeSelect = 3;
        } else if (accountingCutOffTypeSelect == 2) {
            stockMoveTypeSelect = 2;
        }
        String queryStr = "self.invoicingStatusSelect != :stockMoveInvoiced AND self.statusSelect = :stockMoveStatusRealized and self.realDate <= :moveDate AND self.typeSelect = :stockMoveType ";
        if (company != null) {
            queryStr = queryStr + "AND self.company.id = :companyId";
        }
        Query query = this.stockMoverepository.all().filter(queryStr).bind("stockMoveInvoiced", (Object)2).bind("stockMoveStatusRealized", (Object)3).bind("stockMoveType", (Object)stockMoveTypeSelect).bind("moveDate", (Object)moveDate);
        if (company != null) {
            query.bind("companyId", (Object)company.getId());
        }
        if (limit != null && offset != null) {
            return query.order("id").fetch(limit.intValue(), offset.intValue());
        }
        return query.order("id").fetch();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public List<Move> generateCutOffMoves(StockMove stockMove, LocalDate moveDate, LocalDate reverseMoveDate, int accountingCutOffTypeSelect, boolean recoveredTax, boolean ati, String moveDescription, boolean includeNotStockManagedProduct) throws AxelorException {
        ArrayList<Move> moveList = new ArrayList<Move>();
        List<StockMoveLine> stockMoveLineSortedList = stockMove.getStockMoveLineList();
        Collections.sort(stockMoveLineSortedList, Comparator.comparing(StockMoveLine::getSequence));
        Move move = this.generateCutOffMove(stockMove, stockMoveLineSortedList, moveDate, moveDate, accountingCutOffTypeSelect == 1, recoveredTax, ati, moveDescription, includeNotStockManagedProduct, false);
        if (move == null) {
            return null;
        }
        moveList.add(move);
        Move reverseMove = this.generateCutOffMove(stockMove, stockMoveLineSortedList, reverseMoveDate, moveDate, accountingCutOffTypeSelect == 1, recoveredTax, ati, moveDescription, includeNotStockManagedProduct, true);
        if (reverseMove == null) {
            return null;
        }
        moveList.add(reverseMove);
        this.reconcile(move, reverseMove);
        return moveList;
    }

    @Override
    public Move generateCutOffMove(StockMove stockMove, List<StockMoveLine> sortedStockMoveLine, LocalDate moveDate, LocalDate originDate, boolean isPurchase, boolean recoveredTax, boolean ati, String moveDescription, boolean includeNotStockManagedProduct, boolean isReverse) throws AxelorException {
        if (moveDate == null || stockMove.getOriginTypeSelect() == null || stockMove.getOriginId() == null) {
            return null;
        }
        Company company = stockMove.getCompany();
        AccountConfig accountConfig = this.accountConfigSupplychainService.getAccountConfig(company);
        Partner partner = stockMove.getPartner();
        Account partnerAccount = null;
        Currency currency = null;
        if ("com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect()) && stockMove.getOriginId() != null) {
            SaleOrder saleOrder = (SaleOrder)((Object)this.saleOrderRepository.find(stockMove.getOriginId()));
            currency = saleOrder.getCurrency();
            if (partner == null) {
                partner = saleOrder.getClientPartner();
            }
            partnerAccount = this.accountConfigSupplychainService.getForecastedInvCustAccount(accountConfig);
        }
        if ("com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect()) && stockMove.getOriginId() != null) {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)this.purchaseOrderRepository.find(stockMove.getOriginId()));
            currency = purchaseOrder.getCurrency();
            if (partner == null) {
                partner = purchaseOrder.getSupplierPartner();
            }
            partnerAccount = this.accountConfigSupplychainService.getForecastedInvSuppAccount(accountConfig);
        }
        String origin = stockMove.getStockMoveSeq();
        Move move = this.moveCreateService.createMove(this.accountConfigSupplychainService.getAutoMiscOpeJournal(accountConfig), company, currency, partner, moveDate, null, 2);
        this.counter = 0;
        this.generateMoveLines(move, stockMove.getStockMoveLineList(), origin, isPurchase, recoveredTax, ati, moveDescription, isReverse, originDate, includeNotStockManagedProduct);
        this.generatePartnerMoveLine(move, origin, partnerAccount, moveDescription, originDate);
        if (move.getMoveLineList() == null || move.getMoveLineList().isEmpty()) {
            this.moveRepository.remove((Model)((Object)move));
            return null;
        }
        move.setStockMove(stockMove);
        this.moveValidateService.validate(move);
        return move;
    }

    protected List<MoveLine> generateMoveLines(Move move, List<StockMoveLine> stockMoveLineList, String origin, boolean isPurchase, boolean recoveredTax, boolean ati, String moveDescription, boolean isReverse, LocalDate originDate, boolean includeNotStockManagedProduct) throws AxelorException {
        if (stockMoveLineList != null) {
            for (StockMoveLine stockMoveLine : stockMoveLineList) {
                Product product;
                if (this.checkStockMoveLine(stockMoveLine, product = stockMoveLine.getProduct(), includeNotStockManagedProduct)) continue;
                this.generateProductMoveLine(move, stockMoveLine, origin, isPurchase, recoveredTax, ati, moveDescription, isReverse, originDate);
            }
        }
        return move.getMoveLineList();
    }

    protected boolean checkStockMoveLine(StockMoveLine stockMoveLine, Product product, boolean includeNotStockManagedProduct) {
        return stockMoveLine.getRealQty().compareTo(BigDecimal.ZERO) == 0 || product == null || !includeNotStockManagedProduct && product.getStockManaged() == false || stockMoveLine.getRealQty().compareTo(stockMoveLine.getQtyInvoiced()) == 0;
    }

    protected MoveLine generateProductMoveLine(Move move, StockMoveLine stockMoveLine, String origin, boolean isPurchase, boolean recoveredTax, boolean ati, String moveDescription, boolean isReverse, LocalDate originDate) throws AxelorException {
        TaxLine taxLine;
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        PurchaseOrderLine purchaseOrderLine = stockMoveLine.getPurchaseOrderLine();
        Company company = move.getCompany();
        LocalDate moveDate = move.getDate();
        Partner partner = move.getPartner();
        boolean isFixedAssets = false;
        BigDecimal amountInCurrency = null;
        BigDecimal totalQty = null;
        BigDecimal notInvoicedQty = null;
        if (isPurchase && purchaseOrderLine != null) {
            totalQty = purchaseOrderLine.getQty();
            notInvoicedQty = this.unitConversionService.convert(stockMoveLine.getUnit(), purchaseOrderLine.getUnit(), stockMoveLine.getRealQty().subtract(stockMoveLine.getQtyInvoiced()), stockMoveLine.getRealQty().scale(), purchaseOrderLine.getProduct());
            isFixedAssets = purchaseOrderLine.getFixedAssets();
            amountInCurrency = ati && !recoveredTax ? purchaseOrderLine.getInTaxTotal() : purchaseOrderLine.getExTaxTotal();
        }
        if (!isPurchase && saleOrderLine != null) {
            totalQty = saleOrderLine.getQty();
            notInvoicedQty = this.unitConversionService.convert(stockMoveLine.getUnit(), saleOrderLine.getUnit(), stockMoveLine.getRealQty().subtract(stockMoveLine.getQtyInvoiced()), stockMoveLine.getRealQty().scale(), saleOrderLine.getProduct());
            amountInCurrency = ati ? saleOrderLine.getInTaxTotal() : saleOrderLine.getExTaxTotal();
        }
        if (totalQty == null || BigDecimal.ZERO.compareTo(totalQty) == 0) {
            return null;
        }
        BigDecimal qtyRate = notInvoicedQty.divide(totalQty, 10, RoundingMode.HALF_EVEN);
        if ((amountInCurrency = amountInCurrency.multiply(qtyRate).setScale(2, RoundingMode.HALF_EVEN)) == null || amountInCurrency.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        Product product = stockMoveLine.getProduct();
        Account account = this.accountManagementAccountService.getProductAccount(product, company, partner.getFiscalPosition(), isPurchase, isFixedAssets);
        boolean isDebit = false;
        if (isPurchase && amountInCurrency.compareTo(BigDecimal.ZERO) == 1 || !isPurchase && amountInCurrency.compareTo(BigDecimal.ZERO) == -1) {
            isDebit = true;
        }
        if (isReverse) {
            isDebit = !isDebit;
        }
        MoveLine moveLine = this.moveLineService.createMoveLine(move, partner, account, amountInCurrency, isDebit, originDate, ++this.counter, origin, moveDescription);
        moveLine.setDate(moveDate);
        moveLine.setDueDate(moveDate);
        this.getAndComputeAnalyticDistribution(product, move, moveLine);
        move.addMoveLineListItem(moveLine);
        if (recoveredTax && (taxLine = this.accountManagementAccountService.getTaxLine(originDate, product, company, partner.getFiscalPosition(), isPurchase)) != null) {
            moveLine.setTaxLine(taxLine);
            moveLine.setTaxRate(taxLine.getValue());
            moveLine.setTaxCode(taxLine.getTax().getCode());
            if (taxLine.getValue().compareTo(BigDecimal.ZERO) != 0) {
                this.generateTaxMoveLine(move, moveLine, origin, isPurchase, isFixedAssets, moveDescription);
            }
        }
        return moveLine;
    }

    protected void generateTaxMoveLine(Move move, MoveLine productMoveLine, String origin, boolean isPurchase, boolean isFixedAssets, String moveDescription) throws AxelorException {
        TaxLine taxLine = productMoveLine.getTaxLine();
        Tax tax = taxLine.getTax();
        Account taxAccount = this.taxAccountService.getAccount(tax, move.getCompany(), isPurchase, isFixedAssets);
        BigDecimal currencyTaxAmount = InvoiceLineManagement.computeAmount((BigDecimal)productMoveLine.getCurrencyAmount(), (BigDecimal)taxLine.getValue());
        MoveLine taxMoveLine = this.moveLineService.createMoveLine(move, move.getPartner(), taxAccount, currencyTaxAmount, productMoveLine.getDebit().compareTo(BigDecimal.ZERO) == 1, productMoveLine.getOriginDate(), ++this.counter, origin, moveDescription);
        taxMoveLine.setDate(move.getDate());
        taxMoveLine.setDueDate(move.getDate());
        move.addMoveLineListItem(taxMoveLine);
    }

    protected MoveLine generatePartnerMoveLine(Move move, String origin, Account account, String moveDescription, LocalDate originDate) throws AxelorException {
        LocalDate moveDate = move.getDate();
        BigDecimal currencyBalance = this.moveToolService.getBalanceCurrencyAmount(move.getMoveLineList());
        BigDecimal balance = this.moveToolService.getBalanceAmount(move.getMoveLineList());
        if (balance.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        MoveLine moveLine = this.moveLineService.createMoveLine(move, move.getPartner(), account, currencyBalance.abs(), balance.abs(), null, balance.compareTo(BigDecimal.ZERO) == -1, moveDate, moveDate, originDate, ++this.counter, origin, moveDescription);
        move.addMoveLineListItem(moveLine);
        return moveLine;
    }

    protected void getAndComputeAnalyticDistribution(Product product, Move move, MoveLine moveLine) {
        if (this.appAccountService.getAppAccount().getAnalyticDistributionTypeSelect() == 1) {
            return;
        }
        AnalyticDistributionTemplate analyticDistributionTemplate = this.analyticMoveLineService.getAnalyticDistributionTemplate(move.getPartner(), product, move.getCompany());
        moveLine.setAnalyticDistributionTemplate(analyticDistributionTemplate);
        List analyticMoveLineList = this.moveLineService.createAnalyticDistributionWithTemplate(moveLine).getAnalyticMoveLineList();
        for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
            analyticMoveLine.setMoveLine(moveLine);
        }
        analyticMoveLineList.stream().forEach(arg_0 -> ((AnalyticMoveLineRepository)this.analyticMoveLineRepository).save(arg_0));
    }

    protected void reconcile(Move move, Move reverseMove) throws AxelorException {
        List<MoveLine> moveLineSortedList = move.getMoveLineList();
        Collections.sort(moveLineSortedList, Comparator.comparing(MoveLine::getCounter));
        List<MoveLine> reverseMoveLineSortedList = reverseMove.getMoveLineList();
        Collections.sort(reverseMoveLineSortedList, Comparator.comparing(MoveLine::getCounter));
        Iterator<MoveLine> reverseMoveLinesIt = reverseMoveLineSortedList.iterator();
        for (MoveLine moveLine : moveLineSortedList) {
            MoveLine reverseMoveLine = reverseMoveLinesIt.next();
            this.reconcileService.reconcile(moveLine, reverseMoveLine, false, false);
        }
    }

    @Override
    public List<Long> getStockMoveLines(Batch batch) {
        int offset = 0;
        Boolean includeNotStockManagedProduct = batch.getSupplychainBatch().getIncludeNotStockManagedProduct();
        ArrayList<Long> stockMoveLineIdList = new ArrayList<Long>();
        Query stockMoveQuery = this.stockMoverepository.all().filter(":batch MEMBER OF self.batchSet").bind("batch", (Object)batch);
        List stockMoveIdList = stockMoveQuery.select(new String[]{"id"}).fetch(0, 0).stream().map(m -> (Long)m.get("id")).collect(Collectors.toList());
        if (stockMoveIdList.isEmpty()) {
            stockMoveLineIdList.add(0L);
        } else {
            List stockMoveLineList;
            Query stockMoveLineQuery = this.stockMoveLineRepository.all().filter("self.stockMove.id IN :stockMoveIdList").bind("stockMoveIdList", stockMoveIdList).order("id");
            while (!(stockMoveLineList = stockMoveLineQuery.fetch(10, offset)).isEmpty()) {
                offset += stockMoveLineList.size();
                for (StockMoveLine stockMoveLine : stockMoveLineList) {
                    Product product;
                    if (this.checkStockMoveLine(stockMoveLine, product = stockMoveLine.getProduct(), includeNotStockManagedProduct)) continue;
                    stockMoveLineIdList.add(stockMoveLine.getId());
                }
                JPA.clear();
            }
        }
        return stockMoveLineIdList;
    }
}

