/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.repo.AccountingSituationRepository;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.AccountingSituationServiceImpl;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.sale.db.SaleConfig;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.exception.BlockedSaleOrderException;
import com.axelor.apps.sale.service.config.SaleConfigService;
import com.axelor.apps.supplychain.service.AccountingSituationSupplychainService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

@Singleton
public class AccountingSituationSupplychainServiceImpl
extends AccountingSituationServiceImpl
implements AccountingSituationSupplychainService {
    private SaleConfigService saleConfigService;
    @Inject
    private AppAccountService appAccountService;

    @Inject
    public AccountingSituationSupplychainServiceImpl(AccountConfigService accountConfigService, SequenceService sequenceService, AccountingSituationRepository accountingSituationRepo, SaleConfigService saleConfigService) {
        super(accountConfigService, sequenceService, accountingSituationRepo);
        this.saleConfigService = saleConfigService;
    }

    public AccountingSituation createAccountingSituation(Partner partner, Company company) throws AxelorException {
        SaleConfig config;
        AccountingSituation accountingSituation = super.createAccountingSituation(partner, company);
        AppAccountService appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        if (appAccountService.getAppAccount().getManageCustomerCredit().booleanValue() && appAccountService.isApp("supplychain") && (config = this.saleConfigService.getSaleConfig(accountingSituation.getCompany())) != null) {
            accountingSituation.setAcceptedCredit(config.getAcceptedCredit());
        }
        return accountingSituation;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateUsedCredit(Partner partner) throws AxelorException {
        if (this.appAccountService.getAppAccount().getManageCustomerCredit().booleanValue()) {
            List accountingSituationList = this.accountingSituationRepo.all().filter("self.partner = ?1", new Object[]{partner}).fetch();
            for (AccountingSituation accountingSituation : accountingSituationList) {
                this.accountingSituationRepo.save((Model)((Object)this.computeUsedCredit(accountingSituation)));
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateCustomerCredit(Partner partner) throws AxelorException {
        if (!((AppAccountService)Beans.get(AppAccountService.class)).isApp("supplychain")) {
            super.updateCustomerCredit(partner);
            return;
        }
        if (!this.appAccountService.getAppAccount().getManageCustomerCredit().booleanValue() || partner.getIsContact().booleanValue() || !partner.getIsCustomer().booleanValue()) {
            return;
        }
        List<AccountingSituation> accountingSituationList = partner.getAccountingSituationList();
        for (AccountingSituation accountingSituation : accountingSituationList) {
            this.computeUsedCredit(accountingSituation);
        }
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class}, ignore={BlockedSaleOrderException.class})
    public void updateCustomerCreditFromSaleOrder(SaleOrder saleOrder) throws AxelorException {
        if (!this.appAccountService.getAppAccount().getManageCustomerCredit().booleanValue()) {
            return;
        }
        Partner partner = saleOrder.getClientPartner();
        List<AccountingSituation> accountingSituationList = partner.getAccountingSituationList();
        for (AccountingSituation accountingSituation : accountingSituationList) {
            boolean usedCreditExceeded;
            if (!accountingSituation.getCompany().equals((Object)saleOrder.getCompany())) continue;
            accountingSituation = this.computeUsedCredit(accountingSituation);
            if (saleOrder.getStatusSelect() == 1) {
                BigDecimal inTaxInvoicedAmount = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).getInTaxInvoicedAmount(saleOrder);
                BigDecimal usedCredit = accountingSituation.getUsedCredit().add(saleOrder.getInTaxTotal()).subtract(inTaxInvoicedAmount);
                accountingSituation.setUsedCredit(usedCredit);
            }
            if (!(usedCreditExceeded = this.isUsedCreditExceeded(accountingSituation))) continue;
            saleOrder.setBlockedOnCustCreditExceed(true);
            if (saleOrder.getManualUnblock().booleanValue()) continue;
            String message = accountingSituation.getCompany().getOrderBloquedMessage();
            if (Strings.isNullOrEmpty((String)message)) {
                message = String.format(I18n.get((String)"%s blocked : maximal accepted credit exceeded for %s."), partner.getFullName(), saleOrder.getSaleOrderSeq());
            }
            throw new BlockedSaleOrderException((Model)((Object)accountingSituation), message);
        }
    }

    @Override
    public AccountingSituation computeUsedCredit(AccountingSituation accountingSituation) throws AxelorException {
        List invoicePaymentList;
        BigDecimal sum = BigDecimal.ZERO;
        List saleOrderList = ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.company = ?1 AND self.clientPartner = ?2 AND self.statusSelect > ?3 AND self.statusSelect < ?4", new Object[]{accountingSituation.getCompany(), accountingSituation.getPartner(), 1, 5}).fetch();
        for (SaleOrder saleOrder : saleOrderList) {
            sum = sum.add(saleOrder.getInTaxTotal().subtract(((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).getInTaxInvoicedAmount(saleOrder)));
        }
        if (!this.accountConfigService.getAccountConfig(accountingSituation.getCompany()).getGenerateMoveForInvoicePayment().booleanValue() && (invoicePaymentList = ((InvoicePaymentRepository)Beans.get(InvoicePaymentRepository.class)).all().filter("self.invoice.company = :company AND self.invoice.partner = :partner AND self.statusSelect = :validated AND self.typeSelect != :imputation").bind("company", (Object)accountingSituation.getCompany()).bind("partner", (Object)accountingSituation.getPartner()).bind("validated", (Object)1).bind("imputation", (Object)6).fetch()) != null) {
            for (InvoicePayment invoicePayment : invoicePaymentList) {
                sum = sum.subtract(invoicePayment.getAmount());
            }
        }
        sum = accountingSituation.getBalanceCustAccount().add(sum);
        accountingSituation.setUsedCredit(sum.setScale(2, RoundingMode.HALF_EVEN));
        return accountingSituation;
    }

    private boolean isUsedCreditExceeded(AccountingSituation accountingSituation) {
        return accountingSituation.getUsedCredit().compareTo(accountingSituation.getAcceptedCredit()) > 0;
    }
}

