/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.BudgetLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.BudgetDistributionRepository;
import com.axelor.apps.account.db.repo.BudgetLineRepository;
import com.axelor.apps.account.db.repo.BudgetRepository;
import com.axelor.apps.account.service.BudgetService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.List;
import java.util.Optional;

public class BudgetSupplychainService
extends BudgetService {
    @Inject
    public BudgetSupplychainService(BudgetLineRepository budgetLineRepository, BudgetRepository budgetRepository) {
        super(budgetLineRepository, budgetRepository);
    }

    @Transactional
    public List<BudgetLine> updateLines(Budget budget) {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.updateLines(budget);
        }
        if (budget.getBudgetLineList() != null && !budget.getBudgetLineList().isEmpty()) {
            for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                budgetLine.setAmountCommitted(BigDecimal.ZERO);
                budgetLine.setAmountRealized(BigDecimal.ZERO);
            }
            List budgetDistributionList = null;
            budgetDistributionList = ((BudgetDistributionRepository)((Object)Beans.get(BudgetDistributionRepository.class))).all().filter("self.budget.id = ?1 AND self.purchaseOrderLine.purchaseOrder.statusSelect in (?2,?3)", new Object[]{budget.getId(), 3, 4}).fetch();
            block1: for (BudgetDistribution budgetDistribution : budgetDistributionList) {
                LocalDate orderDate = budgetDistribution.getPurchaseOrderLine().getPurchaseOrder().getOrderDate();
                if (orderDate == null) continue;
                for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                    LocalDate fromDate = budgetLine.getFromDate();
                    LocalDate toDate = budgetLine.getToDate();
                    if (fromDate == null || toDate == null || !fromDate.isBefore(orderDate) && !fromDate.isEqual(orderDate) || !toDate.isAfter(orderDate) && !toDate.isEqual(orderDate)) continue;
                    budgetLine.setAmountCommitted(budgetLine.getAmountCommitted().add(budgetDistribution.getAmount()));
                    this.budgetLineRepository.save((Model)((Object)budgetLine));
                    continue block1;
                }
            }
            budgetDistributionList = ((BudgetDistributionRepository)((Object)Beans.get(BudgetDistributionRepository.class))).all().filter("self.budget.id = ?1 AND (self.invoiceLine.invoice.statusSelect = ?2 OR self.invoiceLine.invoice.statusSelect = ?3)", new Object[]{budget.getId(), 2, 3}).fetch();
            for (BudgetDistribution budgetDistribution : budgetDistributionList) {
                Optional<LocalDate> optionaldate = this.getDate(budgetDistribution);
                Invoice invoice = budgetDistribution.getInvoiceLine().getInvoice();
                optionaldate.ifPresent(date -> {
                    for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                        LocalDate fromDate = budgetLine.getFromDate();
                        LocalDate toDate = budgetLine.getToDate();
                        if (fromDate == null || toDate == null || !fromDate.isBefore((ChronoLocalDate)date) && !fromDate.isEqual((ChronoLocalDate)date) || !toDate.isAfter((ChronoLocalDate)date) && !toDate.isEqual((ChronoLocalDate)date)) continue;
                        budgetLine.setAmountRealized(invoice.getOperationTypeSelect() == 2 ? budgetLine.getAmountRealized().subtract(budgetDistribution.getAmount()) : budgetLine.getAmountRealized().add(budgetDistribution.getAmount()));
                        break;
                    }
                });
            }
        }
        return budget.getBudgetLineList();
    }

    public void computeBudgetDistributionSumAmount(BudgetDistribution budgetDistribution, LocalDate computeDate) {
        if (budgetDistribution.getBudget() != null && budgetDistribution.getBudget().getBudgetLineList() != null && computeDate != null) {
            List<BudgetLine> budgetLineList = budgetDistribution.getBudget().getBudgetLineList();
            BigDecimal budgetAmountAvailable = BigDecimal.ZERO;
            for (BudgetLine budgetLine : budgetLineList) {
                LocalDate fromDate = budgetLine.getFromDate();
                LocalDate toDate = budgetLine.getToDate();
                if (fromDate == null || !DateTool.isBetween((LocalDate)fromDate, (LocalDate)toDate, (LocalDate)computeDate)) continue;
                BigDecimal amount = budgetLine.getAmountExpected().subtract(budgetLine.getAmountCommitted());
                budgetAmountAvailable = budgetAmountAvailable.add(amount);
            }
            budgetDistribution.setBudgetAmountAvailable(budgetAmountAvailable);
        }
    }

    protected Optional<LocalDate> getDate(BudgetDistribution budgetDistribution) {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getDate(budgetDistribution);
        }
        InvoiceLine invoiceLine = budgetDistribution.getInvoiceLine();
        if (invoiceLine == null) {
            return Optional.empty();
        }
        Invoice invoice = invoiceLine.getInvoice();
        if (invoice.getPurchaseOrder() != null) {
            return Optional.of(invoice.getPurchaseOrder().getOrderDate());
        }
        return super.getDate(budgetDistribution);
    }

    @Transactional
    public BigDecimal computeTotalAmountCommitted(Budget budget) {
        List<BudgetLine> budgetLineList = budget.getBudgetLineList();
        if (budgetLineList == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalAmountCommitted = budgetLineList.stream().map(BudgetLine::getAmountCommitted).reduce(BigDecimal.ZERO, BigDecimal::add);
        budget.setTotalAmountCommitted(totalAmountCommitted);
        return totalAmountCommitted;
    }

    public void updateBudgetLinesFromPurchaseOrder(PurchaseOrder purchaseOrder) {
        List<PurchaseOrderLine> purchaseOrderLineList = purchaseOrder.getPurchaseOrderLineList();
        if (purchaseOrderLineList == null) {
            return;
        }
        purchaseOrderLineList.stream().flatMap(x -> x.getBudgetDistributionList().stream()).forEach(budgetDistribution -> {
            Budget budget = budgetDistribution.getBudget();
            this.updateLines(budget);
            this.computeTotalAmountCommitted(budget);
        });
    }
}

