/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceLineServiceImpl;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseProductService;
import com.axelor.apps.purchase.service.SupplierCatalogService;
import com.axelor.apps.supplychain.service.BudgetSupplychainService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceLineSupplychainService
extends InvoiceLineServiceImpl {
    protected PurchaseProductService purchaseProductService;
    @Inject
    protected SupplierCatalogService supplierCatalogService;

    @Inject
    public InvoiceLineSupplychainService(CurrencyService currencyService, PriceListService priceListService, AppAccountService appAccountService, AnalyticMoveLineService analyticMoveLineService, AccountManagementAccountService accountManagementAccountService, PurchaseProductService purchaseProductService, ProductCompanyService productCompanyService) {
        super(currencyService, priceListService, appAccountService, analyticMoveLineService, accountManagementAccountService, productCompanyService);
        this.purchaseProductService = purchaseProductService;
    }

    public Unit getUnit(Product product, boolean isPurchase) {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getUnit(product, isPurchase);
        }
        if (isPurchase) {
            if (product.getPurchasesUnit() != null) {
                return product.getPurchasesUnit();
            }
            return product.getUnit();
        }
        if (product.getSalesUnit() != null) {
            return product.getPurchasesUnit();
        }
        return product.getUnit();
    }

    public Map<String, Object> getDiscount(Invoice invoice, InvoiceLine invoiceLine, BigDecimal price) throws AxelorException {
        Map<String, Object> catalogInfo;
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getDiscount(invoice, invoiceLine, price);
        }
        HashMap<String, Object> discounts = new HashMap<String, Object>();
        if (invoice.getOperationTypeSelect() < 3 && (catalogInfo = this.updateInfoFromCatalog(invoice, invoiceLine)) != null) {
            if (catalogInfo.get("price") != null) {
                price = (BigDecimal)catalogInfo.get("price");
            }
            discounts.put("productName", catalogInfo.get("productName"));
        }
        discounts.putAll(super.getDiscount(invoice, invoiceLine, price));
        return discounts;
    }

    private Map<String, Object> updateInfoFromCatalog(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        return this.supplierCatalogService.updateInfoFromCatalog(invoiceLine.getProduct(), invoiceLine.getQty(), invoice.getPartner(), invoice.getCurrency(), invoice.getInvoiceDate(), invoice.getCompany());
    }

    public Map<String, Object> fillPriceAndAccount(Invoice invoice, InvoiceLine invoiceLine, boolean isPurchase) throws AxelorException {
        return super.fillPriceAndAccount(invoice, invoiceLine, isPurchase);
    }

    public Map<String, Object> fillProductInformation(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.fillProductInformation(invoice, invoiceLine);
        }
        HashMap<String, Object> productInformation = new HashMap<String, Object>();
        Integer sequence = invoiceLine.getSequence();
        if (sequence == null) {
            sequence = 0;
        }
        if (sequence == 0 && invoice.getInvoiceLineList() != null) {
            sequence = invoice.getInvoiceLineList().size();
            invoiceLine.setSequence(sequence);
        }
        productInformation.put("typeSelect", 0);
        invoiceLine.setTypeSelect(0);
        productInformation.putAll(super.fillProductInformation(invoice, invoiceLine));
        return productInformation;
    }

    public void computeBudgetDistributionSumAmount(InvoiceLine invoiceLine, Invoice invoice) {
        List<BudgetDistribution> budgetDistributionList = invoiceLine.getBudgetDistributionList();
        PurchaseOrderLine purchaseOrderLine = invoiceLine.getPurchaseOrderLine();
        BigDecimal budgetDistributionSumAmount = BigDecimal.ZERO;
        LocalDate computeDate = invoice.getInvoiceDate();
        if (purchaseOrderLine != null && purchaseOrderLine.getPurchaseOrder().getOrderDate() != null) {
            computeDate = purchaseOrderLine.getPurchaseOrder().getOrderDate();
        }
        if (budgetDistributionList != null && !budgetDistributionList.isEmpty()) {
            for (BudgetDistribution budgetDistribution : budgetDistributionList) {
                budgetDistributionSumAmount = budgetDistributionSumAmount.add(budgetDistribution.getAmount());
                ((BudgetSupplychainService)((Object)Beans.get(BudgetSupplychainService.class))).computeBudgetDistributionSumAmount(budgetDistribution, computeDate);
            }
        }
        invoiceLine.setBudgetDistributionSumAmount(budgetDistributionSumAmount);
    }
}

