/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.service.StockRulesService;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.MrpForecast;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.apps.supplychain.db.MrpLineOrigin;
import com.axelor.apps.supplychain.db.MrpLineType;
import com.axelor.apps.supplychain.service.MrpLineService;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrpLineServiceImpl
implements MrpLineService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppBaseService appBaseService;
    protected PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    protected PurchaseOrderLineService purchaseOrderLineService;
    protected PurchaseOrderRepository purchaseOrderRepo;
    protected StockRulesService stockRulesService;

    @Inject
    public MrpLineServiceImpl(AppBaseService appBaseService, PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl, PurchaseOrderLineService purchaseOrderLineService, PurchaseOrderRepository purchaseOrderRepo, StockRulesService stockRulesService) {
        this.appBaseService = appBaseService;
        this.purchaseOrderServiceSupplychainImpl = purchaseOrderServiceSupplychainImpl;
        this.purchaseOrderLineService = purchaseOrderLineService;
        this.purchaseOrderRepo = purchaseOrderRepo;
        this.stockRulesService = stockRulesService;
    }

    @Override
    public void generateProposal(MrpLine mrpLine) throws AxelorException {
        this.generateProposal(mrpLine, null, null, false);
    }

    @Override
    public void generateProposal(MrpLine mrpLine, Map<Pair<Partner, LocalDate>, PurchaseOrder> purchaseOrders, Map<Partner, PurchaseOrder> purchaseOrdersPerSupplier, boolean isProposalsPerSupplier) throws AxelorException {
        if (mrpLine.getMrpLineType().getElementSelect() == 5) {
            this.generatePurchaseProposal(mrpLine, purchaseOrders, purchaseOrdersPerSupplier, isProposalsPerSupplier);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void generatePurchaseProposal(MrpLine mrpLine, Map<Pair<Partner, LocalDate>, PurchaseOrder> purchaseOrders, Map<Partner, PurchaseOrder> purchaseOrdersPerSupplier, boolean isProposalsPerSupplier) throws AxelorException {
        Product product = mrpLine.getProduct();
        StockLocation stockLocation = mrpLine.getStockLocation();
        LocalDate maturityDate = mrpLine.getMaturityDate();
        Partner supplierPartner = product.getDefaultSupplierPartner();
        if (supplierPartner == null) {
            throw new AxelorException((Model)((Object)mrpLine), 4, I18n.get((String)"No default supplier is defined for the product %s"), new Object[]{product.getFullName()});
        }
        Company company = stockLocation.getCompany();
        Pair key = null;
        PurchaseOrder purchaseOrder = null;
        if (isProposalsPerSupplier) {
            if (purchaseOrdersPerSupplier != null) {
                purchaseOrder = purchaseOrdersPerSupplier.get((Object)supplierPartner);
            }
        } else if (purchaseOrders != null) {
            key = Pair.of((Object)((Object)supplierPartner), (Object)maturityDate);
            purchaseOrder = purchaseOrders.get(key);
        }
        if (purchaseOrder == null) {
            purchaseOrder = (PurchaseOrder)((Object)this.purchaseOrderRepo.save((Model)((Object)this.purchaseOrderServiceSupplychainImpl.createPurchaseOrder(AuthUtils.getUser(), company, null, supplierPartner.getCurrency(), maturityDate, "MRP-" + this.appBaseService.getTodayDate(company).toString(), null, stockLocation, this.appBaseService.getTodayDate(company), ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(supplierPartner, 2), supplierPartner, null))));
            if (isProposalsPerSupplier) {
                if (purchaseOrdersPerSupplier != null) {
                    purchaseOrdersPerSupplier.put(supplierPartner, purchaseOrder);
                }
            } else if (purchaseOrders != null) {
                purchaseOrders.put((Pair<Partner, LocalDate>)key, purchaseOrder);
            }
        }
        Unit unit = product.getPurchasesUnit();
        BigDecimal qty = mrpLine.getQty();
        if (unit == null) {
            unit = product.getUnit();
        } else {
            qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(product.getUnit(), unit, qty, qty.scale(), product);
        }
        PurchaseOrderLine poLine = this.purchaseOrderLineService.createPurchaseOrderLine(purchaseOrder, product, null, null, qty, unit);
        poLine.setDesiredDelivDate(maturityDate);
        purchaseOrder.addPurchaseOrderLineListItem(poLine);
        this.purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
        this.linkToOrder(mrpLine, purchaseOrder);
    }

    protected void linkToOrder(MrpLine mrpLine, AuditableModel order) {
        mrpLine.setProposalSelect(order.getClass().getName());
        mrpLine.setProposalSelectId(order.getId());
        mrpLine.setProposalGenerated(true);
    }

    @Override
    public MrpLine createMrpLine(Mrp mrp, Product product, int maxLevel, MrpLineType mrpLineType, BigDecimal qty, LocalDate maturityDate, BigDecimal cumulativeQty, StockLocation stockLocation, Model model) {
        MrpLine mrpLine = new MrpLine();
        mrpLine.setMrp(mrp);
        mrpLine.setProduct(product);
        mrpLine.setMaxLevel(maxLevel);
        mrpLine.setMrpLineType(mrpLineType);
        if (mrpLineType.getTypeSelect() == 2) {
            mrpLine.setQty(qty.negate());
        } else {
            mrpLine.setQty(qty);
        }
        mrpLine.setMaturityDate(maturityDate);
        mrpLine.setCumulativeQty(cumulativeQty);
        mrpLine.setStockLocation(stockLocation);
        mrpLine.setMinQty(this.getMinQty(product, stockLocation));
        this.updatePartner(mrpLine, model);
        this.createMrpLineOrigins(mrpLine, model);
        this.log.debug("Create mrp line for the product {}, level {}, mrpLineType {}, qty {}, maturity date {}, cumulative qty {}, stock location {}, related to {}", new Object[]{product.getCode(), maxLevel, mrpLineType.getCode(), qty, maturityDate, cumulativeQty, stockLocation.getName(), mrpLine.getRelatedToSelectName()});
        return mrpLine;
    }

    protected BigDecimal getMinQty(Product product, StockLocation stockLocation) {
        StockRules stockRules = this.stockRulesService.getStockRules(product, stockLocation, 2, 1);
        if (stockRules != null) {
            return stockRules.getMinQty();
        }
        return BigDecimal.ZERO;
    }

    protected void createMrpLineOrigins(MrpLine mrpLine, Model model) {
        if (model != null) {
            mrpLine.addMrpLineOriginListItem(this.createMrpLineOrigin(model));
            mrpLine.setRelatedToSelectName(this.computeRelatedName(model));
        }
    }

    @Override
    public MrpLineOrigin createMrpLineOrigin(Model model) {
        Class klass = EntityHelper.getEntityClass((Object)model);
        MrpLineOrigin mrpLineOrigin = new MrpLineOrigin();
        mrpLineOrigin.setRelatedToSelect(klass.getCanonicalName());
        mrpLineOrigin.setRelatedToSelectId(model.getId());
        return mrpLineOrigin;
    }

    @Override
    public MrpLineOrigin copyMrpLineOrigin(MrpLineOrigin mrpLineOrigin) {
        MrpLineOrigin copyMrpLineOrigin = new MrpLineOrigin();
        copyMrpLineOrigin.setRelatedToSelect(mrpLineOrigin.getRelatedToSelect());
        copyMrpLineOrigin.setRelatedToSelectId(mrpLineOrigin.getRelatedToSelectId());
        return copyMrpLineOrigin;
    }

    protected String computeRelatedName(Model model) {
        if (model instanceof SaleOrderLine) {
            return ((SaleOrderLine)((Object)model)).getSaleOrder().getSaleOrderSeq();
        }
        if (model instanceof PurchaseOrderLine) {
            return ((PurchaseOrderLine)((Object)model)).getPurchaseOrder().getPurchaseOrderSeq();
        }
        if (model instanceof MrpForecast) {
            MrpForecast mrpForecast = (MrpForecast)((Object)model);
            return mrpForecast.getId() + "-" + mrpForecast.getForecastDate();
        }
        return null;
    }

    protected void updatePartner(MrpLine mrpLine, Model model) {
        if (model != null) {
            mrpLine.setPartner(this.getPartner(model));
        }
    }

    protected Partner getPartner(Model model) {
        if (model instanceof SaleOrderLine) {
            return ((SaleOrderLine)((Object)model)).getSaleOrder().getClientPartner();
        }
        if (model instanceof PurchaseOrderLine) {
            return ((PurchaseOrderLine)((Object)model)).getPurchaseOrder().getSupplierPartner();
        }
        if (model instanceof MrpForecast) {
            return ((MrpForecast)((Object)model)).getPartner();
        }
        return null;
    }
}

