/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.repo.TimetableRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderInvoiceServiceImpl
implements PurchaseOrderInvoiceService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private InvoiceService invoiceService;
    @Inject
    private InvoiceRepository invoiceRepo;
    @Inject
    protected TimetableRepository timetableRepo;
    @Inject
    protected AppSupplychainService appSupplychainService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(PurchaseOrder purchaseOrder) throws AxelorException {
        Invoice invoice = this.createInvoice(purchaseOrder);
        invoice = (Invoice)((Object)this.invoiceRepo.save((Model)((Object)invoice)));
        this.invoiceService.setDraftSequence(invoice);
        invoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getAddress()));
        return invoice;
    }

    @Override
    public Invoice createInvoice(PurchaseOrder purchaseOrder) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(purchaseOrder);
        Invoice invoice = invoiceGenerator.generate();
        List<InvoiceLine> invoiceLineList = this.createInvoiceLines(invoice, purchaseOrder.getPurchaseOrderLineList());
        invoiceGenerator.populate(invoice, invoiceLineList);
        invoice.setPurchaseOrder(purchaseOrder);
        return invoice;
    }

    @Override
    public InvoiceGenerator createInvoiceGenerator(PurchaseOrder purchaseOrder) throws AxelorException {
        return this.createInvoiceGenerator(purchaseOrder, false);
    }

    @Override
    public InvoiceGenerator createInvoiceGenerator(PurchaseOrder purchaseOrder, boolean isRefund) throws AxelorException {
        if (purchaseOrder.getCurrency() == null) {
            throw new AxelorException((Model)((Object)purchaseOrder), 4, I18n.get((String)"Please, select a currency for the order %s"), new Object[]{purchaseOrder.getPurchaseOrderSeq()});
        }
        return new InvoiceGeneratorSupplyChain(purchaseOrder, isRefund){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<PurchaseOrderLine> purchaseOrderLineList) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            this.processPurchaseOrderLine(invoice, invoiceLineList, purchaseOrderLine);
        }
        return invoiceLineList;
    }

    @Override
    public void processPurchaseOrderLine(Invoice invoice, List<InvoiceLine> invoiceLineList, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        invoiceLineList.addAll(this.createInvoiceLine(invoice, purchaseOrderLine));
        purchaseOrderLine.setInvoiced(true);
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        Product product = purchaseOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit(), purchaseOrderLine.getSequence(), false, null, purchaseOrderLine, null){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    @Override
    public BigDecimal getInvoicedAmount(PurchaseOrder purchaseOrder) {
        return this.getInvoicedAmount(purchaseOrder, null, true);
    }

    @Override
    public BigDecimal getInvoicedAmount(PurchaseOrder purchaseOrder, Long currentInvoiceId, boolean excludeCurrentInvoice) {
        BigDecimal invoicedAmount = BigDecimal.ZERO;
        BigDecimal purchaseAmount = this.getAmountVentilated(purchaseOrder, currentInvoiceId, excludeCurrentInvoice, 1);
        BigDecimal refundAmount = this.getAmountVentilated(purchaseOrder, currentInvoiceId, excludeCurrentInvoice, 2);
        if (purchaseAmount != null) {
            invoicedAmount = invoicedAmount.add(purchaseAmount);
        }
        if (refundAmount != null) {
            invoicedAmount = invoicedAmount.subtract(refundAmount);
        }
        if (!purchaseOrder.getCurrency().equals((Object)purchaseOrder.getCompany().getCurrency()) && purchaseOrder.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rate = invoicedAmount.divide(purchaseOrder.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmount = purchaseOrder.getExTaxTotal().multiply(rate);
        }
        this.log.debug("Compute the invoiced amount ({}) of the purchase order : {}", (Object)invoicedAmount, (Object)purchaseOrder.getPurchaseOrderSeq());
        return invoicedAmount;
    }

    private BigDecimal getAmountVentilated(PurchaseOrder purchaseOrder, Long currentInvoiceId, boolean excludeCurrentInvoice, int invoiceOperationTypeSelect) {
        BigDecimal invoicedAmount;
        String query = "SELECT SUM(self.companyExTaxTotal) FROM InvoiceLine as self WHERE ((self.purchaseOrderLine.purchaseOrder.id = :purchaseOrderId AND self.invoice.purchaseOrder IS NULL) OR self.invoice.purchaseOrder.id = :purchaseOrderId ) AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect AND self.invoice.statusSelect = :statusVentilated";
        if (currentInvoiceId != null) {
            query = excludeCurrentInvoice ? query + " AND self.invoice.id <> :invoiceId" : query + " OR (self.invoice.id = :invoiceId AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect) ";
        }
        TypedQuery q = JPA.em().createQuery(query, BigDecimal.class);
        q.setParameter("purchaseOrderId", (Object)purchaseOrder.getId());
        q.setParameter("statusVentilated", (Object)3);
        q.setParameter("invoiceOperationTypeSelect", (Object)invoiceOperationTypeSelect);
        if (currentInvoiceId != null) {
            q.setParameter("invoiceId", (Object)currentInvoiceId);
        }
        if ((invoicedAmount = (BigDecimal)q.getSingleResult()) != null) {
            return invoicedAmount;
        }
        return BigDecimal.ZERO;
    }

    @Transactional(rollbackOn={Exception.class})
    protected Invoice generateInvoiceFromTimetableForPurchaseOrder(PurchaseOrder purchaseOrder, List<Long> timetableIdList) throws AxelorException {
        if (ObjectUtils.isEmpty(timetableIdList)) {
            throw new AxelorException((Model)((Object)purchaseOrder), 5, I18n.get((String)"There are no selected timetables to invoice"));
        }
        BigDecimal percentSum = BigDecimal.ZERO;
        ArrayList<Timetable> timetableList = new ArrayList<Timetable>();
        for (Long timetableId : timetableIdList) {
            Timetable timetable = (Timetable)((Object)this.timetableRepo.find(timetableId));
            timetableList.add(timetable);
            percentSum = percentSum.add(timetable.getPercentage());
        }
        Invoice invoice = this.generateInvoiceFromLines(purchaseOrder, percentSum);
        for (Timetable timetable : timetableList) {
            timetable.setInvoice(invoice);
            timetable.setInvoiced(true);
            this.timetableRepo.save((Model)((Object)timetable));
        }
        return invoice;
    }

    public Invoice generateInvoiceFromLines(PurchaseOrder purchaseOrder, BigDecimal percentSum) throws AxelorException {
        if (percentSum.equals(BigDecimal.ZERO)) {
            throw new AxelorException((Model)((Object)purchaseOrder), 5, I18n.get((String)"There are no lines to invoice"));
        }
        HashMap<Long, BigDecimal> qtyToInvoiceMap = new HashMap<Long, BigDecimal>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            BigDecimal realQty = purchaseOrderLine.getQty().multiply(percentSum).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN);
            qtyToInvoiceMap.put(purchaseOrderLine.getId(), realQty);
            if (((BigDecimal)qtyToInvoiceMap.get(purchaseOrderLine.getId())).compareTo(purchaseOrderLine.getQty()) <= 0) continue;
            throw new AxelorException((Model)((Object)purchaseOrderLine), 5, I18n.get((String)"The quantity to invoice is greater than the quantity in the purchase order"));
        }
        return this.generateInvoice(purchaseOrder, purchaseOrder.getPurchaseOrderLineList(), qtyToInvoiceMap);
    }

    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(PurchaseOrder purchaseOrder, List<PurchaseOrderLine> purchaseOrderLinesSelected, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        Invoice invoice = this.createInvoice(purchaseOrder, purchaseOrderLinesSelected, qtyToInvoiceMap);
        this.invoiceRepo.save((Model)((Object)invoice));
        ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).save((Model)((Object)this.fillPurchaseOrder(purchaseOrder, invoice)));
        return invoice;
    }

    public Invoice createInvoice(PurchaseOrder purchaseOrder, List<PurchaseOrderLine> purchaseOrderLineList, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(purchaseOrder);
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, purchaseOrderLineList, qtyToInvoiceMap));
        return invoice;
    }

    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<PurchaseOrderLine> purchaseOrderLineList, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            if (!qtyToInvoiceMap.containsKey(purchaseOrderLine.getId())) continue;
            List<InvoiceLine> invoiceLines = this.createInvoiceLine(invoice, purchaseOrderLine, qtyToInvoiceMap.get(purchaseOrderLine.getId()));
            invoiceLineList.addAll(invoiceLines);
            purchaseOrderLine.setInvoiced(true);
        }
        return invoiceLineList;
    }

    public List<InvoiceLine> createInvoiceLine(Invoice invoice, PurchaseOrderLine purchaseOrderLine, BigDecimal qtyToInvoice) throws AxelorException {
        Product product = purchaseOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), qtyToInvoice, purchaseOrderLine.getUnit(), purchaseOrderLine.getSequence(), false, null, purchaseOrderLine, null){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    public PurchaseOrder fillPurchaseOrder(PurchaseOrder purchaseOrder, Invoice invoice) {
        purchaseOrder.setOrderDate(this.appSupplychainService.getTodayDate(purchaseOrder.getCompany()));
        return purchaseOrder;
    }
}

