/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseRequest;
import com.axelor.apps.purchase.service.PurchaseRequestServiceImpl;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public class PurchaseRequestServiceSupplychainImpl
extends PurchaseRequestServiceImpl {
    @Inject
    StockLocationRepository stockLocationRepo;

    protected PurchaseOrder createPurchaseOrder(PurchaseRequest purchaseRequest) throws AxelorException {
        PurchaseOrder purchaseOrder = super.createPurchaseOrder(purchaseRequest);
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            purchaseOrder.setStockLocation(purchaseRequest.getStockLocation());
        }
        return purchaseOrder;
    }

    protected String getPurchaseOrderGroupBySupplierKey(PurchaseRequest purchaseRequest) {
        String key = super.getPurchaseOrderGroupBySupplierKey(purchaseRequest);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return key;
        }
        StockLocation stockLocation = purchaseRequest.getStockLocation();
        if (stockLocation != null) {
            key = key + "_" + stockLocation.getId().toString();
        }
        return key;
    }
}

