/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.supplychain.db.SupplyChainConfig;
import com.axelor.apps.supplychain.service.ReservedQtyService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.config.SupplyChainConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReservedQtyServiceImpl
implements ReservedQtyService {
    protected StockLocationLineService stockLocationLineService;
    protected StockMoveLineRepository stockMoveLineRepository;
    protected UnitConversionService unitConversionService;
    protected SupplyChainConfigService supplychainConfigService;
    protected AppBaseService appBaseService;

    @Inject
    public ReservedQtyServiceImpl(StockLocationLineService stockLocationLineService, StockMoveLineRepository stockMoveLineRepository, UnitConversionService unitConversionService, SupplyChainConfigService supplyChainConfigService, AppBaseService appBaseService) {
        this.stockLocationLineService = stockLocationLineService;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.unitConversionService = unitConversionService;
        this.supplychainConfigService = supplyChainConfigService;
        this.appBaseService = appBaseService;
    }

    @Override
    public void updateReservedQuantity(StockMove stockMove, int status) throws AxelorException {
        List<StockMoveLine> stockMoveLineList = stockMove.getStockMoveLineList();
        if (stockMoveLineList != null) {
            stockMoveLineList = stockMoveLineList.stream().filter(smLine -> smLine.getProduct() != null && smLine.getProduct().getStockManaged() != false).collect(Collectors.toList());
            for (StockMoveLine stockMoveLine : stockMoveLineList) {
                if (status == 2) {
                    this.changeRequestedQtyLowerThanQty(stockMoveLine);
                }
                this.checkRequestedAndReservedQty(stockMoveLine);
            }
            if (status == 3) {
                this.consolidateReservedQtyInStockMoveLineByProduct(stockMove);
            }
            stockMoveLineList.sort(Comparator.comparing(StockMoveLine::getId));
            for (StockMoveLine stockMoveLine : stockMoveLineList) {
                BigDecimal qty = stockMoveLine.getRealQty();
                BigDecimal requestedReservedQty = stockMoveLine.getRequestedReservedQty().subtract(stockMoveLine.getReservedQty());
                this.updateRequestedQuantityInLocations(stockMoveLine, stockMove.getFromStockLocation(), stockMove.getToStockLocation(), stockMoveLine.getProduct(), qty, requestedReservedQty, status);
            }
        }
    }

    protected void changeRequestedQtyLowerThanQty(StockMoveLine stockMoveLine) throws AxelorException {
        BigDecimal qty = stockMoveLine.getRealQty().max(BigDecimal.ZERO);
        BigDecimal requestedReservedQty = stockMoveLine.getRequestedReservedQty();
        if (requestedReservedQty.compareTo(qty) > 0) {
            Product product = stockMoveLine.getProduct();
            BigDecimal diffRequestedQty = requestedReservedQty.subtract(qty);
            stockMoveLine.setRequestedReservedQty(qty);
            StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), product);
            BigDecimal diffRequestedQuantityLocation = this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), diffRequestedQty, product);
            stockLocationLine.setRequestedReservedQty(stockLocationLine.getRequestedReservedQty().add(diffRequestedQuantityLocation));
        }
    }

    protected void checkRequestedAndReservedQty(StockMoveLine stockMoveLine) throws AxelorException {
        String stockMoveLineSeq;
        BigDecimal plannedQty = stockMoveLine.getQty().max(BigDecimal.ZERO);
        BigDecimal requestedReservedQty = stockMoveLine.getRequestedReservedQty();
        BigDecimal reservedQty = stockMoveLine.getReservedQty();
        String string = stockMoveLineSeq = stockMoveLine.getStockMove() == null ? stockMoveLine.getId().toString() : stockMoveLine.getStockMove().getStockMoveSeq() + "-" + stockMoveLine.getSequence();
        if (reservedQty.signum() < 0 || requestedReservedQty.signum() < 0) {
            throw new AxelorException(5, I18n.get((String)"Please do not enter negative quantity for reservation."));
        }
        if (requestedReservedQty.compareTo(plannedQty) > 0) {
            throw new AxelorException(5, I18n.get((String)"The requested quantity must not be greater than the quantity in the stock move line %s."), new Object[]{stockMoveLineSeq});
        }
        if (reservedQty.compareTo(plannedQty) > 0) {
            throw new AxelorException(5, I18n.get((String)"The allocated quantity must not be greater than the quantity in the stock move line %s."), new Object[]{stockMoveLineSeq});
        }
    }

    @Override
    public void consolidateReservedQtyInStockMoveLineByProduct(StockMove stockMove) {
        if (stockMove.getStockMoveLineList() == null) {
            return;
        }
        List productList = stockMove.getStockMoveLineList().stream().map(StockMoveLine::getProduct).filter(Objects::nonNull).filter(Product::getStockManaged).distinct().collect(Collectors.toList());
        for (Product product : productList) {
            List<StockMoveLine> stockMoveLineListToConsolidate;
            if (product == null || (stockMoveLineListToConsolidate = stockMove.getStockMoveLineList().stream().filter(stockMoveLine1 -> product.equals((Object)stockMoveLine1.getProduct())).collect(Collectors.toList())).size() <= 1) continue;
            stockMoveLineListToConsolidate.sort(Comparator.comparing(StockMoveLine::getId));
            BigDecimal reservedQtySum = stockMoveLineListToConsolidate.stream().map(StockMoveLine::getReservedQty).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            stockMoveLineListToConsolidate.forEach(toConsolidateStockMoveLine -> toConsolidateStockMoveLine.setReservedQty(BigDecimal.ZERO));
            ((StockMoveLine)((Object)stockMoveLineListToConsolidate.get(0))).setReservedQty(reservedQtySum);
        }
    }

    @Override
    public void updateRequestedQuantityInLocations(StockMoveLine stockMoveLine, StockLocation fromStockLocation, StockLocation toStockLocation, Product product, BigDecimal qty, BigDecimal requestedReservedQty, int toStatus) throws AxelorException {
        if (fromStockLocation.getTypeSelect() != 3) {
            this.updateRequestedQuantityInFromStockLocation(stockMoveLine, fromStockLocation, product, toStatus, requestedReservedQty);
        }
        if (toStockLocation.getTypeSelect() != 3) {
            this.updateRequestedQuantityInToStockLocation(stockMoveLine, toStockLocation, product, toStatus, qty);
        }
    }

    @Override
    public void updateRequestedQuantityInFromStockLocation(StockMoveLine stockMoveLine, StockLocation stockLocation, Product product, int toStatus, BigDecimal requestedReservedQty) throws AxelorException {
        if (product == null || !product.getStockManaged().booleanValue()) {
            return;
        }
        Unit stockMoveLineUnit = stockMoveLine.getUnit();
        StockLocationLine stockLocationLine = this.stockLocationLineService.getStockLocationLine(stockLocation, product);
        if (stockLocationLine == null) {
            return;
        }
        Unit stockLocationLineUnit = stockLocationLine.getUnit();
        if (toStatus == 4 || toStatus == 3) {
            BigDecimal realReservedStockMoveQty = stockMoveLine.getReservedQty();
            BigDecimal realReservedQty = this.convertUnitWithProduct(stockMoveLineUnit, stockLocationLineUnit, realReservedStockMoveQty, stockMoveLine.getProduct());
            if (this.isReallocatingQtyOnCancel(stockMoveLine)) {
                this.reallocateQty(stockMoveLine, stockLocation, stockLocationLine, product, realReservedQty);
            }
            this.updateReservedQuantityFromStockMoveLine(stockMoveLine, product, stockMoveLine.getReservedQty().negate());
            SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
            if (saleOrderLine != null) {
                if (toStatus == 3) {
                    saleOrderLine.setRequestedReservedQty(saleOrderLine.getRequestedReservedQty().max(saleOrderLine.getDeliveredQty()));
                } else if (!saleOrderLine.getIsQtyRequested().booleanValue()) {
                    saleOrderLine.setRequestedReservedQty(saleOrderLine.getDeliveredQty());
                }
            }
        } else {
            BigDecimal requestedReservedQtyInLocation = this.convertUnitWithProduct(stockMoveLineUnit, stockLocationLine.getUnit(), requestedReservedQty, product);
            BigDecimal realReservedQty = this.computeRealReservedQty(stockLocationLine, requestedReservedQtyInLocation);
            BigDecimal realReservedStockMoveQty = this.convertUnitWithProduct(stockLocationLineUnit, stockMoveLineUnit, realReservedQty, stockMoveLine.getProduct());
            this.updateReservedQuantityFromStockMoveLine(stockMoveLine, product, realReservedStockMoveQty);
            if (this.supplychainConfigService.getSupplyChainConfig(stockLocation.getCompany()).getAutoAllocateOnAllocation().booleanValue()) {
                BigDecimal availableQuantityInLocation = stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
                availableQuantityInLocation = this.convertUnitWithProduct(stockLocationLineUnit, stockMoveLineUnit, availableQuantityInLocation, product);
                BigDecimal qtyRemainingToAllocate = availableQuantityInLocation.subtract(realReservedStockMoveQty);
                this.reallocateQty(stockMoveLine, stockLocation, stockLocationLine, product, qtyRemainingToAllocate);
            }
        }
        this.updateReservedQty(stockLocationLine);
        this.updateRequestedReservedQty(stockLocationLine);
        this.checkReservedQtyStocks(stockLocationLine, stockMoveLine, toStatus);
    }

    protected boolean isReallocatingQtyOnCancel(StockMoveLine stockMoveLine) {
        return Optional.of(stockMoveLine).map(StockMoveLine::getStockMove).map(StockMove::getCancelReason).map(CancelReason::getCancelQuantityAllocation).orElse(false);
    }

    @Override
    public void updateRequestedQuantityInToStockLocation(StockMoveLine stockMoveLine, StockLocation stockLocation, Product product, int toStatus, BigDecimal qty) throws AxelorException {
        if (product == null || !product.getStockManaged().booleanValue()) {
            return;
        }
        StockLocationLine stockLocationLine = this.stockLocationLineService.getStockLocationLine(stockLocation, product);
        if (stockLocationLine == null) {
            return;
        }
        Company company = stockLocationLine.getStockLocation().getCompany();
        SupplyChainConfig supplyChainConfig = this.supplychainConfigService.getSupplyChainConfig(company);
        if (toStatus == 3 && supplyChainConfig.getAutoAllocateOnReceipt().booleanValue()) {
            this.reallocateQty(stockMoveLine, stockLocation, stockLocationLine, product, qty);
        }
        this.updateRequestedReservedQty(stockLocationLine);
        this.checkReservedQtyStocks(stockLocationLine, stockMoveLine, toStatus);
    }

    protected void reallocateQty(StockMoveLine stockMoveLine, StockLocation stockLocation, StockLocationLine stockLocationLine, Product product, BigDecimal qty) throws AxelorException {
        Unit stockMoveLineUnit = stockMoveLine.getUnit();
        Unit stockLocationLineUnit = stockLocationLine.getUnit();
        BigDecimal stockLocationQty = this.convertUnitWithProduct(stockMoveLineUnit, stockLocationLineUnit, qty, product);
        BigDecimal leftToAllocate = stockLocationLine.getRequestedReservedQty().subtract(stockLocationLine.getReservedQty());
        BigDecimal realReservedQty = stockLocationQty.min(leftToAllocate);
        this.allocateReservedQuantityInSaleOrderLines(realReservedQty, stockLocation, product, stockLocationLineUnit, Optional.of(stockMoveLine));
        this.updateReservedQty(stockLocationLine);
    }

    @Override
    public BigDecimal allocateReservedQuantityInSaleOrderLines(BigDecimal qtyToAllocate, StockLocation stockLocation, Product product, Unit stockLocationLineUnit) throws AxelorException {
        if (product == null || !product.getStockManaged().booleanValue()) {
            return BigDecimal.ZERO;
        }
        return this.allocateReservedQuantityInSaleOrderLines(qtyToAllocate, stockLocation, product, stockLocationLineUnit, Optional.empty());
    }

    protected BigDecimal allocateReservedQuantityInSaleOrderLines(BigDecimal qtyToAllocate, StockLocation stockLocation, Product product, Unit stockLocationLineUnit, Optional<StockMoveLine> allocatedStockMoveLine) throws AxelorException {
        List stockMoveLineListToAllocate = this.stockMoveLineRepository.all().filter("self.stockMove.fromStockLocation.id = :stockLocationId AND self.product.id = :productId AND self.stockMove.statusSelect = :planned AND self.reservationDateTime IS NOT NULL AND self.reservedQty < self.requestedReservedQty").bind("stockLocationId", (Object)stockLocation.getId()).bind("productId", (Object)product.getId()).bind("planned", (Object)2).order("reservationDateTime").order("stockMove.estimatedDate").fetch();
        allocatedStockMoveLine.ifPresent(stockMoveLine -> stockMoveLineListToAllocate.sort((sml1, sml2) -> {
            if (sml1.getStockMove().equals((Object)sml2.getStockMove())) {
                return 0;
            }
            if (sml1.getStockMove().equals((Object)stockMoveLine.getStockMove())) {
                return -1;
            }
            if (sml2.getStockMove().equals((Object)stockMoveLine.getStockMove())) {
                return 1;
            }
            return 0;
        }));
        BigDecimal leftQtyToAllocate = qtyToAllocate;
        for (StockMoveLine stockMoveLine2 : stockMoveLineListToAllocate) {
            BigDecimal leftQtyToAllocateStockMove = this.convertUnitWithProduct(stockLocationLineUnit, stockMoveLine2.getUnit(), leftQtyToAllocate, product);
            BigDecimal neededQtyToAllocate = stockMoveLine2.getRequestedReservedQty().subtract(stockMoveLine2.getReservedQty());
            BigDecimal allocatedStockMoveQty = leftQtyToAllocateStockMove.min(neededQtyToAllocate);
            BigDecimal allocatedQty = this.convertUnitWithProduct(stockMoveLine2.getUnit(), stockLocationLineUnit, allocatedStockMoveQty, product);
            this.updateReservedQuantityFromStockMoveLine(stockMoveLine2, product, allocatedStockMoveQty);
            leftQtyToAllocate = leftQtyToAllocate.subtract(allocatedQty);
        }
        return qtyToAllocate.subtract(leftQtyToAllocate);
    }

    @Override
    public void updateReservedQuantityFromStockMoveLine(StockMoveLine stockMoveLine, Product product, BigDecimal reservedQtyToAdd) throws AxelorException {
        if (product == null || !product.getStockManaged().booleanValue()) {
            return;
        }
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        stockMoveLine.setReservedQty(stockMoveLine.getReservedQty().add(reservedQtyToAdd));
        if (saleOrderLine != null) {
            this.updateReservedQty(saleOrderLine);
        }
    }

    @Override
    public void updateReservedQuantityInStockMoveLineFromSaleOrderLine(SaleOrderLine saleOrderLine, Product product, BigDecimal newReservedQty) throws AxelorException {
        if (product == null || !product.getStockManaged().booleanValue()) {
            return;
        }
        List<StockMoveLine> stockMoveLineList = this.getPlannedStockMoveLines(saleOrderLine);
        BigDecimal allocatedQty = newReservedQty;
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            BigDecimal stockMoveAllocatedQty = this.convertUnitWithProduct(saleOrderLine.getUnit(), stockMoveLine.getUnit(), allocatedQty, product);
            BigDecimal reservedQtyInStockMoveLine = stockMoveLine.getRequestedReservedQty().min(stockMoveAllocatedQty);
            stockMoveLine.setReservedQty(reservedQtyInStockMoveLine);
            BigDecimal saleOrderReservedQtyInStockMoveLine = this.convertUnitWithProduct(stockMoveLine.getUnit(), saleOrderLine.getUnit(), reservedQtyInStockMoveLine, product);
            allocatedQty = allocatedQty.subtract(saleOrderReservedQtyInStockMoveLine);
        }
        this.updateReservedQty(saleOrderLine);
    }

    @Override
    public BigDecimal updateRequestedReservedQuantityInStockMoveLines(SaleOrderLine saleOrderLine, Product product, BigDecimal newReservedQty) throws AxelorException {
        if (product == null || !product.getStockManaged().booleanValue()) {
            return BigDecimal.ZERO;
        }
        List<StockMoveLine> stockMoveLineList = this.getPlannedStockMoveLines(saleOrderLine);
        BigDecimal deliveredQty = saleOrderLine.getDeliveredQty();
        BigDecimal allocatedRequestedQty = newReservedQty.subtract(deliveredQty);
        if (allocatedRequestedQty.signum() < 0) {
            throw new AxelorException(5, I18n.get((String)"The requested quantity must be greater than the already delivered quantity."));
        }
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            BigDecimal stockMoveRequestedQty = this.convertUnitWithProduct(saleOrderLine.getUnit(), stockMoveLine.getUnit(), allocatedRequestedQty, product);
            BigDecimal requestedQtyInStockMoveLine = stockMoveLine.getQty().min(stockMoveRequestedQty);
            stockMoveLine.setRequestedReservedQty(requestedQtyInStockMoveLine);
            BigDecimal saleOrderRequestedQtyInStockMoveLine = this.convertUnitWithProduct(stockMoveLine.getUnit(), saleOrderLine.getUnit(), requestedQtyInStockMoveLine, product);
            allocatedRequestedQty = allocatedRequestedQty.subtract(saleOrderRequestedQtyInStockMoveLine);
        }
        saleOrderLine.setRequestedReservedQty(newReservedQty.subtract(allocatedRequestedQty));
        return saleOrderLine.getRequestedReservedQty().subtract(deliveredQty);
    }

    protected List<StockMoveLine> getPlannedStockMoveLines(SaleOrderLine saleOrderLine) {
        return this.stockMoveLineRepository.all().filter("self.saleOrderLine.id = :saleOrderLineId AND self.stockMove.statusSelect = :planned").bind("saleOrderLineId", (Object)saleOrderLine.getId()).bind("planned", (Object)2).order("id").fetch();
    }

    protected void checkReservedQtyStocks(StockLocationLine stockLocationLine, StockMoveLine stockMoveLine, int toStatus) throws AxelorException {
        if ((toStatus == 3 || toStatus == 4) && stockLocationLine.getReservedQty().compareTo(stockLocationLine.getCurrentQty()) > 0) {
            BigDecimal convertedAvailableQtyInStockMove = this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), stockMoveLine.getRealQty(), stockLocationLine.getProduct());
            BigDecimal convertedReservedQtyInStockMove = this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), stockMoveLine.getReservedQty(), stockLocationLine.getProduct());
            BigDecimal availableQty = convertedAvailableQtyInStockMove.add(stockLocationLine.getCurrentQty()).subtract(convertedReservedQtyInStockMove.add(stockLocationLine.getReservedQty()));
            BigDecimal neededQty = convertedAvailableQtyInStockMove.subtract(convertedReservedQtyInStockMove);
            throw new AxelorException(4, I18n.get((String)"This operation cannot be performed. Available stock for product %s: %s, stock needed: %s. Please deallocate."), new Object[]{stockLocationLine.getProduct().getFullName(), availableQty, neededQty});
        }
    }

    @Override
    public BigDecimal computeRealReservedQty(StockLocationLine stockLocationLine, BigDecimal requestedReservedQty) {
        BigDecimal qtyLeftToBeAllocated = stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
        return qtyLeftToBeAllocated.min(requestedReservedQty).max(BigDecimal.ZERO);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateReservedQty(SaleOrderLine saleOrderLine, BigDecimal newReservedQty) throws AxelorException {
        BigDecimal newRequestedReservedQty;
        if (saleOrderLine.getProduct() == null || !saleOrderLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        StockMoveLine stockMoveLine = this.getPlannedStockMoveLine(saleOrderLine);
        this.checkBeforeUpdatingQties(stockMoveLine, newReservedQty);
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getBlockDeallocationOnAvailabilityRequest().booleanValue()) {
            this.checkAvailabilityRequest(stockMoveLine, newReservedQty, false);
        }
        if ((newRequestedReservedQty = newReservedQty.add(saleOrderLine.getDeliveredQty())).compareTo(saleOrderLine.getRequestedReservedQty()) > 0 && newReservedQty.compareTo(BigDecimal.ZERO) > 0) {
            this.requestQty(saleOrderLine);
        }
        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), stockMoveLine.getProduct());
        BigDecimal availableQtyToBeReserved = stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
        BigDecimal diffReservedQuantity = newReservedQty.subtract(saleOrderLine.getReservedQty());
        Product product = stockMoveLine.getProduct();
        BigDecimal diffReservedQuantityLocation = this.convertUnitWithProduct(saleOrderLine.getUnit(), stockLocationLine.getUnit(), diffReservedQuantity, product);
        if (availableQtyToBeReserved.compareTo(diffReservedQuantityLocation) < 0) {
            throw new AxelorException(5, I18n.get((String)"This quantity is not available in stock."));
        }
        this.updateReservedQuantityInStockMoveLineFromSaleOrderLine(saleOrderLine, stockMoveLine.getProduct(), newReservedQty);
        this.updateReservedQty(stockLocationLine);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateRequestedReservedQty(SaleOrderLine saleOrderLine, BigDecimal newReservedQty) throws AxelorException {
        if (saleOrderLine.getProduct() == null || !saleOrderLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        StockMoveLine stockMoveLine = this.getPlannedStockMoveLine(saleOrderLine);
        if (stockMoveLine == null) {
            saleOrderLine.setRequestedReservedQty(newReservedQty);
            return;
        }
        this.checkBeforeUpdatingQties(stockMoveLine, newReservedQty);
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getBlockDeallocationOnAvailabilityRequest().booleanValue()) {
            this.checkAvailabilityRequest(stockMoveLine, newReservedQty, true);
        }
        BigDecimal diffReservedQuantity = newReservedQty.subtract(saleOrderLine.getRequestedReservedQty());
        BigDecimal newAllocatedQty = this.updateRequestedReservedQuantityInStockMoveLines(saleOrderLine, stockMoveLine.getProduct(), newReservedQty);
        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), stockMoveLine.getProduct());
        Product product = stockMoveLine.getProduct();
        BigDecimal diffReservedQuantityLocation = this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), diffReservedQuantity, product);
        stockLocationLine.setRequestedReservedQty(stockLocationLine.getRequestedReservedQty().add(diffReservedQuantityLocation));
        if (newAllocatedQty.compareTo(saleOrderLine.getReservedQty()) < 0) {
            this.updateReservedQty(saleOrderLine, newAllocatedQty);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateReservedQty(StockMoveLine stockMoveLine, BigDecimal newReservedQty) throws AxelorException {
        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), stockMoveLine.getProduct());
        this.updateReservedQty(stockLocationLine, stockMoveLine, newReservedQty);
    }

    protected void updateReservedQty(StockLocationLine stockLocationLine, StockMoveLine stockMoveLine, BigDecimal newReservedQty) throws AxelorException {
        if (stockMoveLine.getProduct() == null || !stockMoveLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        if (saleOrderLine != null) {
            this.updateReservedQty(saleOrderLine, newReservedQty);
        } else {
            this.checkBeforeUpdatingQties(stockMoveLine, newReservedQty);
            if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getBlockDeallocationOnAvailabilityRequest().booleanValue()) {
                this.checkAvailabilityRequest(stockMoveLine, newReservedQty, false);
            }
            if (stockMoveLine.getRequestedReservedQty().compareTo(newReservedQty) < 0 && newReservedQty.compareTo(BigDecimal.ZERO) > 0) {
                this.updateRequestedReservedQty(stockLocationLine, stockMoveLine, newReservedQty);
                this.requestQty(stockMoveLine);
            }
            BigDecimal availableQtyToBeReserved = stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
            BigDecimal diffReservedQuantity = newReservedQty.subtract(stockMoveLine.getReservedQty());
            Product product = stockMoveLine.getProduct();
            BigDecimal diffReservedQuantityLocation = this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), diffReservedQuantity, product);
            if (availableQtyToBeReserved.compareTo(diffReservedQuantityLocation) < 0) {
                throw new AxelorException(5, I18n.get((String)"This quantity is not available in stock."));
            }
            stockMoveLine.setReservedQty(newReservedQty);
            this.updateReservedQty(stockLocationLine);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateRequestedReservedQty(StockMoveLine stockMoveLine, BigDecimal newReservedQty) throws AxelorException {
        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), stockMoveLine.getProduct());
        this.updateRequestedReservedQty(stockLocationLine, stockMoveLine, newReservedQty);
    }

    protected void updateRequestedReservedQty(StockLocationLine stockLocationLine, StockMoveLine stockMoveLine, BigDecimal newReservedQty) throws AxelorException {
        BigDecimal diffReservedQuantity = newReservedQty.subtract(stockMoveLine.getRequestedReservedQty());
        BigDecimal diffReservedQuantityLocation = this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), diffReservedQuantity, stockMoveLine.getProduct());
        stockLocationLine.setRequestedReservedQty(stockLocationLine.getRequestedReservedQty().add(diffReservedQuantityLocation));
        stockMoveLine.setRequestedReservedQty(newReservedQty);
    }

    protected void checkBeforeUpdatingQties(StockMoveLine stockMoveLine, BigDecimal qty) throws AxelorException {
        if (stockMoveLine == null) {
            throw new AxelorException(5, I18n.get((String)"Please generate a stock move for this sale order before modifying allocated quantity."));
        }
        if (qty.signum() < 0) {
            throw new AxelorException(5, I18n.get((String)"Please do not enter negative quantity for reservation."));
        }
    }

    protected void checkAvailabilityRequest(StockMoveLine stockMoveLine, BigDecimal qty, boolean isRequested) throws AxelorException {
        BigDecimal stockMoveLineQty;
        BigDecimal bigDecimal = stockMoveLineQty = isRequested ? stockMoveLine.getRequestedReservedQty() : stockMoveLine.getReservedQty();
        if (stockMoveLine.getStockMove().getAvailabilityRequest().booleanValue() && stockMoveLineQty.compareTo(qty) > 0) {
            throw new AxelorException((Model)((Object)stockMoveLine.getStockMove()), 5, I18n.get((String)"The reservation for an availability requested stock move cannot be lowered."));
        }
    }

    @Override
    public void deallocateStockMoveLineAfterSplit(StockMoveLine stockMoveLine, BigDecimal amountToDeallocate) throws AxelorException {
        StockLocationLine stockLocationLine;
        if (stockMoveLine.getProduct() == null || !stockMoveLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        if (saleOrderLine != null) {
            this.updateReservedQty(saleOrderLine);
        }
        if (stockMoveLine.getStockMove() != null && (stockLocationLine = this.stockLocationLineService.getStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), stockMoveLine.getProduct())) != null) {
            this.updateReservedQty(stockLocationLine);
        }
    }

    protected StockMoveLine getPlannedStockMoveLine(SaleOrderLine saleOrderLine) {
        return (StockMoveLine)((Object)this.stockMoveLineRepository.all().filter("self.saleOrderLine = :saleOrderLine AND self.stockMove.statusSelect = :planned").bind("saleOrderLine", (Object)saleOrderLine).bind("planned", (Object)2).fetchOne());
    }

    private BigDecimal convertUnitWithProduct(Unit startUnit, Unit endUnit, BigDecimal qtyToConvert, Product product) throws AxelorException {
        if (startUnit != null && !startUnit.equals((Object)endUnit)) {
            return this.unitConversionService.convert(startUnit, endUnit, qtyToConvert, qtyToConvert.scale(), product);
        }
        return qtyToConvert;
    }

    @Override
    public void updateRequestedReservedQty(StockLocationLine stockLocationLine) throws AxelorException {
        List stockMoveLineList = this.stockMoveLineRepository.all().filter("self.product.id = :productId AND self.stockMove.fromStockLocation.id = :stockLocationId AND self.stockMove.statusSelect = :planned").bind("productId", (Object)stockLocationLine.getProduct().getId()).bind("stockLocationId", (Object)stockLocationLine.getStockLocation().getId()).bind("planned", (Object)2).fetch();
        BigDecimal requestedReservedQty = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            requestedReservedQty = requestedReservedQty.add(this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), stockMoveLine.getRequestedReservedQty(), stockLocationLine.getProduct()));
        }
        stockLocationLine.setRequestedReservedQty(requestedReservedQty);
    }

    @Override
    public void updateReservedQty(SaleOrderLine saleOrderLine) throws AxelorException {
        List stockMoveLineList = this.stockMoveLineRepository.all().filter("self.saleOrderLine.id = :saleOrderLineId AND self.stockMove.statusSelect = :planned").bind("saleOrderLineId", (Object)saleOrderLine.getId()).bind("planned", (Object)2).fetch();
        BigDecimal reservedQty = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            reservedQty = reservedQty.add(this.convertUnitWithProduct(stockMoveLine.getUnit(), saleOrderLine.getUnit(), stockMoveLine.getReservedQty(), saleOrderLine.getProduct()));
        }
        saleOrderLine.setReservedQty(reservedQty);
    }

    @Override
    public void updateReservedQty(StockLocationLine stockLocationLine) throws AxelorException {
        List stockMoveLineList = this.stockMoveLineRepository.all().filter("self.product.id = :productId AND self.stockMove.fromStockLocation.id = :stockLocationId AND self.stockMove.statusSelect = :planned").bind("productId", (Object)stockLocationLine.getProduct().getId()).bind("stockLocationId", (Object)stockLocationLine.getStockLocation().getId()).bind("planned", (Object)2).fetch();
        BigDecimal reservedQty = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            reservedQty = reservedQty.add(this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), stockMoveLine.getReservedQty(), stockLocationLine.getProduct()));
        }
        stockLocationLine.setReservedQty(reservedQty);
    }

    @Override
    public void allocateAll(SaleOrderLine saleOrderLine) throws AxelorException {
        if (saleOrderLine.getProduct() == null || !saleOrderLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        this.requestQty(saleOrderLine);
        StockMoveLine stockMoveLine = this.getPlannedStockMoveLine(saleOrderLine);
        if (stockMoveLine == null) {
            throw new AxelorException(5, I18n.get((String)"Please generate a stock move for this sale order before modifying allocated quantity."));
        }
        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), stockMoveLine.getProduct());
        BigDecimal availableQtyToBeReserved = stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
        Product product = stockMoveLine.getProduct();
        BigDecimal availableQtyToBeReservedSaleOrderLine = this.convertUnitWithProduct(saleOrderLine.getUnit(), stockLocationLine.getUnit(), availableQtyToBeReserved, product).add(saleOrderLine.getReservedQty());
        BigDecimal qtyThatWillBeAllocated = saleOrderLine.getQty().min(availableQtyToBeReservedSaleOrderLine);
        if (qtyThatWillBeAllocated.compareTo(saleOrderLine.getReservedQty()) > 0) {
            this.updateReservedQty(saleOrderLine, qtyThatWillBeAllocated);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void allocateAll(StockMoveLine stockMoveLine) throws AxelorException {
        this.requestQty(stockMoveLine);
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        if (saleOrderLine != null) {
            this.allocateAll(saleOrderLine);
        } else {
            StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockMoveLine.getStockMove().getFromStockLocation(), stockMoveLine.getProduct());
            BigDecimal availableQtyToBeReserved = stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
            Product product = stockMoveLine.getProduct();
            BigDecimal availableQtyToBeReservedStockMoveLine = this.convertUnitWithProduct(stockMoveLine.getUnit(), stockLocationLine.getUnit(), availableQtyToBeReserved, product).add(stockMoveLine.getReservedQty());
            BigDecimal qtyThatWillBeAllocated = stockMoveLine.getQty().min(availableQtyToBeReservedStockMoveLine);
            if (qtyThatWillBeAllocated.compareTo(stockMoveLine.getReservedQty()) > 0) {
                this.updateReservedQty(stockLocationLine, stockMoveLine, qtyThatWillBeAllocated);
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void requestQty(SaleOrderLine saleOrderLine) throws AxelorException {
        if (saleOrderLine.getProduct() == null || !saleOrderLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        saleOrderLine.setIsQtyRequested(true);
        if (saleOrderLine.getQty().signum() < 0) {
            throw new AxelorException(5, I18n.get((String)"You cannot request reservation with a negative quantity."));
        }
        StockMoveLine stockMoveLine = this.getPlannedStockMoveLine(saleOrderLine);
        if (stockMoveLine != null) {
            stockMoveLine.setIsQtyRequested(true);
        }
        this.updateRequestedReservedQty(saleOrderLine, saleOrderLine.getQty());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void requestQty(StockMoveLine stockMoveLine) throws AxelorException {
        if (stockMoveLine.getProduct() == null || !stockMoveLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        if (saleOrderLine != null) {
            this.requestQty(saleOrderLine);
        } else {
            stockMoveLine.setReservationDateTime(this.appBaseService.getTodayDateTime().toLocalDateTime());
            stockMoveLine.setIsQtyRequested(true);
            if (stockMoveLine.getQty().signum() < 0) {
                throw new AxelorException(5, I18n.get((String)"You cannot request reservation with a negative quantity."));
            }
            this.updateRequestedReservedQty(stockMoveLine, stockMoveLine.getQty());
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancelReservation(SaleOrderLine saleOrderLine) throws AxelorException {
        if (saleOrderLine.getProduct() == null || !saleOrderLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        saleOrderLine.setIsQtyRequested(false);
        StockMoveLine stockMoveLine = this.getPlannedStockMoveLine(saleOrderLine);
        if (stockMoveLine != null) {
            stockMoveLine.setIsQtyRequested(false);
        }
        this.updateRequestedReservedQty(saleOrderLine, saleOrderLine.getDeliveredQty());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancelReservation(StockMoveLine stockMoveLine) throws AxelorException {
        if (stockMoveLine.getProduct() == null || !stockMoveLine.getProduct().getStockManaged().booleanValue()) {
            return;
        }
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        if (saleOrderLine != null) {
            this.cancelReservation(saleOrderLine);
        } else {
            stockMoveLine.setIsQtyRequested(false);
            stockMoveLine.setReservationDateTime(null);
            this.updateRequestedReservedQty(stockMoveLine, BigDecimal.ZERO);
        }
    }
}

